/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import java.util.Set;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationServiceImpl;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.RemoteAuthorizationManager;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileUtil;

public class APIManagerComponent {
    private static final Log log = LogFactory.getLog(APIManagerComponent.class);
    private ServiceRegistration registration;

    protected void activate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"API manager component activated");
        }
        try {
            this.addRxtConfigs();
            this.addTierPolicies();
            APIManagerConfiguration configuration = new APIManagerConfiguration();
            String filePath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "api-manager.xml";
            configuration.load(filePath);
            APIManagerConfigurationServiceImpl configurationService = new APIManagerConfigurationServiceImpl(configuration);
            ServiceReferenceHolder.getInstance().setAPIManagerConfigurationService(configurationService);
            this.registration = componentContext.getBundleContext().registerService(APIManagerConfigurationService.class.getName(), (Object)configurationService, (Dictionary)new Properties());
            this.setupSelfRegistration(configuration);
            AuthorizationUtils.addAuthorizeRoleListener((int)200, (String)RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)"/_system/governance/apimgt/applicationdata"), (String)"/permission/admin/manage/api/create", (String)"ui.execute", null);
            AuthorizationUtils.addAuthorizeRoleListener((int)201, (String)RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)"/_system/governance/trunk"), (String)"/permission/admin/manage/api/create", (String)"ui.execute", null);
            AuthorizationUtils.addAuthorizeRoleListener((int)202, (String)RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)"/_system/governance/apimgt/applicationdata"), (String)"/permission/admin/manage/api/publish", (String)"ui.execute", null);
            RemoteAuthorizationManager authorizationManager = RemoteAuthorizationManager.getInstance();
            authorizationManager.init();
        }
        catch (APIManagementException e) {
            log.fatal((Object)"Error while initializing the API manager component", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivating API manager component");
        }
        this.registration.unregister();
        APIManagerFactory.getInstance().clearAll();
        RemoteAuthorizationManager authorizationManager = RemoteAuthorizationManager.getInstance();
        authorizationManager.destroy();
    }

    protected void setRegistryService(RegistryService registryService) {
        if (registryService != null && log.isDebugEnabled()) {
            log.debug((Object)"Registry service initialized");
        }
        ServiceReferenceHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ServiceReferenceHolder.getInstance().setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        if (realmService != null && log.isDebugEnabled()) {
            log.debug((Object)"Realm service initialized");
        }
        ServiceReferenceHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        ServiceReferenceHolder.getInstance().setRealmService(null);
    }

    protected void setListenerManager(ListenerManager listenerManager) {
        log.debug((Object)"Listener manager bound to the API manager component");
        APIManagerConfigurationService service = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService();
        if (service != null) {
            service.getAPIManagerConfiguration().reloadSystemProperties();
        }
    }

    protected void unsetListenerManager(ListenerManager listenerManager) {
        log.debug((Object)"Listener manager unbound from the API manager component");
    }

    private void addRxtConfigs() throws APIManagementException {
        UserRegistry registry;
        UserRegistry systemRegistry;
        String rxtDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "rxts";
        File file = new File(rxtDir);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rxt");
            }
        };
        String[] rxtFilePaths = file.list(filenameFilter);
        RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
        try {
            systemRegistry = registryService.getRegistry("wso2.system.user");
            registry = registryService.getRegistry();
        }
        catch (RegistryException e) {
            throw new APIManagementException("Failed to get registry", (Throwable)e);
        }
        for (String rxtPath : rxtFilePaths) {
            String msg;
            String resourcePath = "/_system/governance/repository/components/org.wso2.carbon.governance/types/" + rxtPath;
            try {
                if (registry.resourceExists(resourcePath)) continue;
                String rxt = FileUtil.readFileToString((String)(rxtDir + File.separator + rxtPath));
                Resource resource = registry.newResource();
                resource.setContent((Object)rxt.getBytes());
                resource.setMediaType("application/vnd.wso2.registry-ext-type+xml");
                systemRegistry.put(resourcePath, resource);
            }
            catch (IOException e) {
                msg = "Failed to read rxt files";
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (RegistryException e) {
                msg = "Failed to add rxt to registry ";
                throw new APIManagementException(msg, (Throwable)e);
            }
        }
    }

    private void addTierPolicies() throws APIManagementException {
        RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
        try {
            UserRegistry registry = registryService.getGovernanceSystemRegistry();
            if (registry.resourceExists("/apimgt/applicationdata/tiers.xml")) {
                log.debug((Object)"Tier policies already uploaded to the registry");
                return;
            }
            log.debug((Object)"Adding API tier policies to the registry");
            InputStream inputStream = APIManagerComponent.class.getResourceAsStream("/tiers/default-tiers.xml");
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Resource resource = registry.newResource();
            resource.setContent((Object)data);
            Properties descriptions = new Properties();
            descriptions.load(APIManagerComponent.class.getResourceAsStream("/tiers/default-tier-info.properties"));
            Set<String> names = descriptions.stringPropertyNames();
            for (String name : names) {
                resource.setProperty("tier.desc." + name, descriptions.getProperty(name));
            }
            resource.setProperty("tier.desc.Unlimited", "Allows unlimited requests");
            registry.put("/apimgt/applicationdata/tiers.xml", resource);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while saving policy information to the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading policy file content", (Throwable)e);
        }
    }

    private void setupSelfRegistration(APIManagerConfiguration config) throws APIManagementException {
        boolean enabled = Boolean.parseBoolean(config.getFirstProperty("SelfSignUp.Enabled"));
        if (!enabled) {
            return;
        }
        String role = config.getFirstProperty("SelfSignUp.SubscriberRoleName");
        if (role == null) {
            throw new APIManagementException("Required subscriber role parameter missing in the self sign up configuration");
        }
        boolean create = Boolean.parseBoolean(config.getFirstProperty("SelfSignUp.CreateSubscriberRole"));
        if (create) {
            String[] permissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
            try {
                RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
                UserRealm realm = realmService.getBootstrapRealm();
                UserStoreManager manager = realm.getUserStoreManager();
                AuthorizationManager authorizationManager = realm.getAuthorizationManager();
                authorizationManager.clearRoleActionOnAllResources(role, "ui.execute");
                for (String permission : permissions) {
                    authorizationManager.authorizeRole(role, permission, "ui.execute");
                }
                if (!manager.isExistingRole(role)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating subscriber role: " + role));
                    }
                    manager.addRole(role, null, null);
                }
            }
            catch (UserStoreException e) {
                throw new APIManagementException("Error while creating subscriber role: " + role + " - " + "Self registration might not function properly.", (Throwable)e);
            }
        }
    }
}

