/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.dto.UserApplicationAPIUsage;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIKey;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.LifeCycleEvent;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.impl.dto.APIInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.APIKeyInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.utils.APIMgtDBUtil;
import org.wso2.carbon.apimgt.impl.utils.APIVersionComparator;
import org.wso2.carbon.apimgt.impl.utils.LRUCache;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ApiMgtDAO {
    private static final Log log = LogFactory.getLog(ApiMgtDAO.class);

    public ApiMgtDAO() throws APIManagementException {
        APIMgtDBUtil.initialize();
    }

    public String getAccessKeyForAPI(String userId, String applicationName, APIInfoDTO identifier, String keyType) throws APIManagementException, IdentityException {
        String accessKey = null;
        String tenantAwareUserId = MultitenantUtils.getTenantAwareUsername((String)userId);
        int tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for: " + identifier.getAPIIdentifier() + ", User: " + tenantAwareUserId + ", ApplicationName: " + applicationName + ", Tenant ID: " + tenantId));
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT    SKM.ACCESS_TOKEN AS ACCESS_TOKEN FROM    AM_SUBSCRIPTION SP,   AM_API API,   AM_SUBSCRIBER SB,   AM_APPLICATION APP,    AM_SUBSCRIPTION_KEY_MAPPING SKM WHERE    SB.USER_ID=?    AND SB.TENANT_ID=?    AND API.API_PROVIDER=?    AND API.API_NAME=?   AND API.API_VERSION=?   AND APP.NAME=?    AND SKM.KEY_TYPE=?    AND API.API_ID = SP.API_ID   AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID = SP.APPLICATION_ID    AND SP.SUBSCRIPTION_ID = SKM.SUBSCRIPTION_ID ";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, tenantAwareUserId);
            ps.setInt(2, tenantId);
            ps.setString(3, identifier.getProviderId());
            ps.setString(4, identifier.getApiName());
            ps.setString(5, identifier.getVersion());
            ps.setString(6, applicationName);
            ps.setString(7, keyType);
            rs = ps.executeQuery();
            while (rs.next()) {
                accessKey = rs.getString("ACCESS_TOKEN");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error when executing the SQL query to read the access key for user : " + userId + "of tenant(id) : " + tenantId), (Throwable)e);
                throw new APIManagementException("Error when executing the SQL query to read the access key ", (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return accessKey;
    }

    public String getAccessKeyForApplication(String userId, String applicationName, String keyType) throws APIManagementException, IdentityException {
        String accessKey = null;
        String tenantAwareUserId = MultitenantUtils.getTenantAwareUsername((String)userId);
        int tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT    AKM.ACCESS_TOKEN AS ACCESS_TOKEN FROM    AM_SUBSCRIBER SB,   AM_APPLICATION APP,    AM_APPLICATION_KEY_MAPPING AKM WHERE    SB.USER_ID=?    AND SB.TENANT_ID=?    AND APP.NAME=?    AND AKM.KEY_TYPE=?    AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID = AKM.APPLICATION_ID";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, tenantAwareUserId);
            ps.setInt(2, tenantId);
            ps.setString(3, applicationName);
            ps.setString(4, keyType);
            rs = ps.executeQuery();
            while (rs.next()) {
                accessKey = rs.getString("ACCESS_TOKEN");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error when executing the SQL query to read the access key for user : " + userId + "of tenant(id) : " + tenantId), (Throwable)e);
                throw new APIManagementException("Error when executing the SQL query to read the access key ", (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return accessKey;
    }

    public APIInfoDTO[] getSubscribedAPIsOfUser(String userId) throws APIManagementException, IdentityException {
        String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)userId);
        int tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
        ArrayList<APIInfoDTO> apiInfoDTOList = new ArrayList<APIInfoDTO>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT    API.API_PROVIDER AS API_PROVIDER,   API.API_NAME AS API_NAME,   API.API_VERSION AS API_VERSION FROM    AM_SUBSCRIPTION SP,    AM_API API,   AM_SUBSCRIBER SB,    AM_APPLICATION APP WHERE    SB.USER_ID = ?    AND SB.TENANT_ID = ?    AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID=SP.APPLICATION_ID    AND API.API_ID = SP.API_ID";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, tenantAwareUsername);
            ps.setInt(2, tenantId);
            rs = ps.executeQuery();
            while (rs.next()) {
                APIInfoDTO infoDTO = new APIInfoDTO();
                infoDTO.setProviderId(rs.getString("API_PROVIDER"));
                infoDTO.setApiName(rs.getString("API_NAME"));
                infoDTO.setVersion(rs.getString("API_VERSION"));
                apiInfoDTOList.add(infoDTO);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new APIManagementException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return apiInfoDTOList.toArray(new APIInfoDTO[apiInfoDTOList.size()]);
    }

    public APIKeyInfoDTO[] getSubscribedUsersForAPI(APIInfoDTO apiInfoDTO) throws APIManagementException {
        APIKeyInfoDTO[] apiKeyInfoDTOs = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT    SB.USER_ID,    SB.TENANT_ID FROM    AM_SUBSCRIBER SB,    AM_APPLICATION APP,    AM_SUBSCRIPTION SP,    AM_API API WHERE    API.API_PROVIDER = ?    AND API.API_NAME = ?   AND API.API_VERSION = ?   AND SP.APPLICATION_ID = APP.APPLICATION_ID    AND APP.SUBSCRIBER_ID=SB.SUBSCRIBER_ID    AND API.API_ID = SP.API_ID";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, apiInfoDTO.getProviderId());
            ps.setString(2, apiInfoDTO.getApiName());
            ps.setString(3, apiInfoDTO.getVersion());
            rs = ps.executeQuery();
            ArrayList<APIKeyInfoDTO> apiKeyInfoList = new ArrayList<APIKeyInfoDTO>();
            while (rs.next()) {
                String userId = rs.getString("USER_ID");
                APIKeyInfoDTO apiKeyInfoDTO = new APIKeyInfoDTO();
                apiKeyInfoDTO.setUserId(userId);
                apiKeyInfoList.add(apiKeyInfoDTO);
            }
            apiKeyInfoDTOs = apiKeyInfoList.toArray(new APIKeyInfoDTO[apiKeyInfoList.size()]);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new APIManagementException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return apiKeyInfoDTOs;
    }

    public void changeAccessTokenStatus(String userId, APIInfoDTO apiInfoDTO, String statusEnum) throws APIManagementException, IdentityException {
        String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)userId);
        int tenantId = 0;
        IdentityUtil.getTenantIdOFUser((String)userId);
        Connection conn = null;
        PreparedStatement ps = null;
        String sqlQuery = "UPDATE IDENTITY_OAUTH2_ACCESS_TOKEN IAT , AM_SUBSCRIBER SB, AM_SUBSCRIPTION SP , AM_APPLICATION APP, AM_API API SET IAT.TOKEN_STATE=? WHERE SB.USER_ID=? AND SB.TENANT_ID=? AND API.API_PROVIDER=? AND API.API_NAME=? AND API.API_VERSION=? AND SP.ACCESS_TOKEN=IAT.ACCESS_TOKEN AND SB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID AND APP.APPLICATION_ID = SP.APPLICATION_ID AND API.API_ID = SP.API_ID";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, statusEnum);
            ps.setString(2, tenantAwareUsername);
            ps.setInt(3, tenantId);
            ps.setString(4, apiInfoDTO.getProviderId());
            ps.setString(5, apiInfoDTO.getApiName());
            ps.setString(6, apiInfoDTO.getVersion());
            int count = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of rows being updated : " + count));
            }
            conn.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                log.error((Object)"Failed to rollback the changeAccessTokenStatus operation", (Throwable)e);
            }
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, null);
        }
    }

    public APIKeyValidationInfoDTO validateKey(String context, String version, String accessToken) throws APIManagementException {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        APIKeyValidationInfoDTO keyValidationInfoDTO;
        block11: {
            APIKeyValidationInfoDTO aPIKeyValidationInfoDTO;
            String username;
            String type;
            String tier;
            String status;
            block10: {
                String sqlQuery;
                block9: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A request is received to process the token : " + accessToken + " to access" + " the context URL : " + context));
                    }
                    keyValidationInfoDTO = new APIKeyValidationInfoDTO();
                    conn = null;
                    ps = null;
                    rs = null;
                    String applicationSqlQuery = "SELECT    IAT.VALIDITY_PERIOD,    IAT.TIME_CREATED ,   IAT.TOKEN_STATE,   SUB.TIER_ID,   SUBS.USER_ID,   APP.APPLICATION_ID,   AKM.KEY_TYPE FROM    IDENTITY_OAUTH2_ACCESS_TOKEN IAT,   AM_SUBSCRIPTION SUB,   AM_SUBSCRIBER SUBS,   AM_APPLICATION APP,   AM_APPLICATION_KEY_MAPPING AKM,   AM_API API WHERE    AKM.ACCESS_TOKEN = ?    AND API.CONTEXT = ?    AND API.API_VERSION = ?    AND IAT.ACCESS_TOKEN=AKM.ACCESS_TOKEN    AND APP.APPLICATION_ID = APP.APPLICATION_ID   AND SUB.APPLICATION_ID = APP.APPLICATION_ID   AND APP.SUBSCRIBER_ID = SUBS.SUBSCRIBER_ID   AND API.API_ID = SUB.API_ID   AND AKM.APPLICATION_ID=APP.APPLICATION_ID";
                    sqlQuery = "SELECT    IAT.VALIDITY_PERIOD,    IAT.TIME_CREATED ,   IAT.TOKEN_STATE,   SUB.TIER_ID,   SUBS.USER_ID,   APP.APPLICATION_ID,   SKM.KEY_TYPE FROM    IDENTITY_OAUTH2_ACCESS_TOKEN IAT,   AM_SUBSCRIPTION SUB,   AM_SUBSCRIBER SUBS,   AM_APPLICATION APP,   AM_SUBSCRIPTION_KEY_MAPPING SKM,   AM_API API WHERE    SKM.ACCESS_TOKEN = ?    AND API.CONTEXT = ?    AND API.API_VERSION = ?    AND IAT.ACCESS_TOKEN=SKM.ACCESS_TOKEN    AND SUB.SUBSCRIPTION_ID = SKM.SUBSCRIPTION_ID   AND SUB.APPLICATION_ID = APP.APPLICATION_ID   AND APP.SUBSCRIBER_ID = SUBS.SUBSCRIBER_ID   AND API.API_ID = SUB.API_ID";
                    conn = APIMgtDBUtil.getConnection();
                    ps = conn.prepareStatement(applicationSqlQuery);
                    ps.setString(1, accessToken);
                    ps.setString(2, context);
                    ps.setString(3, version);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block9;
                    status = rs.getString("TOKEN_STATE");
                    tier = rs.getString("TIER_ID");
                    type = rs.getString("KEY_TYPE");
                    username = rs.getString("USER_ID");
                    if (!"ACTIVE".equals(status)) break block9;
                    keyValidationInfoDTO.setAuthorized(true);
                    keyValidationInfoDTO.setTier(tier);
                    keyValidationInfoDTO.setType(type);
                    keyValidationInfoDTO.setUsername(username);
                    APIKeyValidationInfoDTO aPIKeyValidationInfoDTO2 = keyValidationInfoDTO;
                    APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                    return aPIKeyValidationInfoDTO2;
                }
                rs.close();
                ps.close();
                ps = conn.prepareStatement(sqlQuery);
                ps.setString(1, accessToken);
                ps.setString(2, context);
                ps.setString(3, version);
                rs = ps.executeQuery();
                if (rs.next()) {
                    status = rs.getString("TOKEN_STATE");
                    tier = rs.getString("TIER_ID");
                    type = rs.getString("KEY_TYPE");
                    username = rs.getString("USER_ID");
                    break block10;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid Access Token is provided : " + accessToken));
                }
                keyValidationInfoDTO.setAuthorized(false);
                APIKeyValidationInfoDTO aPIKeyValidationInfoDTO3 = keyValidationInfoDTO;
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                return aPIKeyValidationInfoDTO3;
            }
            try {
                if (!"ACTIVE".equals(status)) break block11;
                keyValidationInfoDTO.setAuthorized(true);
                keyValidationInfoDTO.setTier(tier);
                keyValidationInfoDTO.setType(type);
                keyValidationInfoDTO.setUsername(username);
                aPIKeyValidationInfoDTO = keyValidationInfoDTO;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"Error when executing the SQL ");
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new APIManagementException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                    throw throwable;
                }
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            return aPIKeyValidationInfoDTO;
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return keyValidationInfoDTO;
    }

    public void addSubscriber(Subscriber subscriber) throws APIManagementException {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String query = "INSERT INTO AM_SUBSCRIBER (USER_ID, TENANT_ID, EMAIL_ADDRESS, DATE_SUBSCRIBED) VALUES (?,?,?,?)";
            ps = conn.prepareStatement(query, 1);
            ps.setString(1, subscriber.getName());
            ps.setInt(2, subscriber.getTenantId());
            ps.setString(3, subscriber.getEmail());
            ps.setTimestamp(4, new Timestamp(subscriber.getSubscribedDate().getTime()));
            ps.executeUpdate();
            int subscriberId = 0;
            rs = ps.getGeneratedKeys();
            if (rs.next()) {
                subscriberId = rs.getInt(1);
            }
            subscriber.setId(subscriberId);
            Application defaultApp = new Application("DefaultApplication", subscriber);
            this.addApplication(defaultApp, subscriber.getName());
        }
        catch (SQLException e) {
            try {
                String msg = "Error in adding new subscriber: " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
    }

    public void updateSubscriber(Subscriber subscriber) throws APIManagementException {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String query = "UPDATE AM_SUBSCRIBER SET USER_ID=?, TENANT_ID=?, EMAIL_ADDRESS=?, DATE_SUBSCRIBED=? WHERE SUBSCRIBER_ID=?";
            ps = conn.prepareStatement(query);
            ps.setString(1, subscriber.getName());
            ps.setInt(2, subscriber.getTenantId());
            ps.setString(3, subscriber.getEmail());
            ps.setTimestamp(4, new Timestamp(subscriber.getSubscribedDate().getTime()));
            ps.setInt(5, subscriber.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                String msg = "Error in updating subscriber: " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
    }

    public Subscriber getSubscriber(int subscriberId) throws APIManagementException {
        Subscriber subscriber2;
        PreparedStatement ps;
        ResultSet rs;
        Connection conn;
        block5: {
            conn = null;
            rs = null;
            ps = null;
            conn = APIMgtDBUtil.getConnection();
            String query = "SELECT USER_ID, TENANT_ID, EMAIL_ADDRESS, DATE_SUBSCRIBED FROM AM_SUBSCRIBER WHERE SUBSCRIBER_ID=?";
            ps = conn.prepareStatement(query);
            ps.setInt(1, subscriberId);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Subscriber subscriber2 = new Subscriber(rs.getString("USER_ID"));
            subscriber2.setId(subscriberId);
            subscriber2.setTenantId(rs.getInt("TENANT_ID"));
            subscriber2.setEmail(rs.getString("EMAIL_ADDRESS"));
            subscriber2.setSubscribedDate(new Date(rs.getTimestamp("DATE_SUBSCRIBED").getTime()));
            Subscriber subscriber3 = subscriber2;
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            return subscriber3;
        }
        try {
            subscriber2 = null;
        }
        catch (SQLException e) {
            try {
                String msg = "Error in retrieving subscriber: " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return subscriber2;
    }

    public int addSubscription(APIIdentifier identifier, String context, int applicationId) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        int subscriptionId = -1;
        int apiId = -1;
        try {
            conn = APIMgtDBUtil.getConnection();
            String getApiQuery = "SELECT API_ID FROM AM_API API WHERE API_PROVIDER = ? AND API_NAME = ? AND API_VERSION = ?";
            ps = conn.prepareStatement(getApiQuery);
            ps.setString(1, identifier.getProviderName());
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                apiId = resultSet.getInt("API_ID");
            }
            resultSet.close();
            ps.close();
            if (apiId == -1) {
                throw new APIManagementException("Unable to get the API ID for: " + identifier);
            }
            String sqlQuery = "INSERT INTO AM_SUBSCRIPTION (TIER_ID,API_ID,APPLICATION_ID) VALUES (?,?,?)";
            ps = conn.prepareStatement(sqlQuery, 1);
            ps.setString(1, identifier.getTier());
            ps.setInt(2, apiId);
            ps.setInt(3, applicationId);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            while (rs.next()) {
                subscriptionId = rs.getInt(1);
            }
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to add subscriber data ";
                log.error((Object)msg, (Throwable)e);
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the add subscription ", (Throwable)e);
                    }
                }
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return subscriptionId;
    }

    public void removeSubscription(APIIdentifier identifier, int applicationId) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        int subscriptionId = -1;
        int apiId = -1;
        try {
            conn = APIMgtDBUtil.getConnection();
            String getApiQuery = "SELECT API_ID FROM AM_API API WHERE API_PROVIDER = ? AND API_NAME = ? AND API_VERSION = ?";
            ps = conn.prepareStatement(getApiQuery);
            ps.setString(1, identifier.getProviderName());
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                apiId = resultSet.getInt("API_ID");
            }
            resultSet.close();
            ps.close();
            if (apiId == -1) {
                throw new APIManagementException("Unable to get the API ID for: " + identifier);
            }
            String sqlQuery = "DELETE FROM AM_SUBSCRIPTION WHERE API_ID = ? AND APPLICATION_ID = ?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, apiId);
            ps.setInt(2, applicationId);
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to add subscriber data ";
                log.error((Object)msg, (Throwable)e);
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the add subscription ", (Throwable)e);
                    }
                }
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    public Subscriber getSubscriber(String subscriberName) throws APIManagementException {
        int tenantId;
        Connection conn = null;
        Subscriber subscriber = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            tenantId = IdentityUtil.getTenantIdOFUser((String)subscriberName);
        }
        catch (IdentityException e) {
            String msg = "Failed to get tenant id of user : " + subscriberName;
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        String sqlQuery = "SELECT    SUBSCRIBER_ID,    USER_ID,    TENANT_ID,    EMAIL_ADDRESS,    DATE_SUBSCRIBED FROM    AM_SUBSCRIBER WHERE    USER_ID = ?    AND TENANT_ID = ?";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, subscriberName);
            ps.setInt(2, tenantId);
            result = ps.executeQuery();
            if (result.next()) {
                subscriber = new Subscriber(result.getString("EMAIL_ADDRESS"));
                subscriber.setEmail(result.getString("EMAIL_ADDRESS"));
                subscriber.setId(result.getInt("SUBSCRIBER_ID"));
                subscriber.setName(subscriberName);
                subscriber.setSubscribedDate((Date)result.getDate("DATE_SUBSCRIBED"));
                subscriber.setTenantId(result.getInt("TENANT_ID"));
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to get Subscriber for :" + subscriberName;
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, result);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, result);
        return subscriber;
    }

    public Set<APIIdentifier> getAPIByConsumerKey(String accessToken) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String getAPISql = "SELECT API.API_PROVIDER, API.API_NAME, API.API_VERSION FROM AM_SUBSCRIPTION SUB, AM_SUBSCRIPTION_KEY_MAPPING SKM,  AM_API API WHERE SKM.ACCESS_TOKEN=? AND SKM.SUBSCRIPTION_ID=SUB.SUBSCRIPTION_ID AND API.API_ID = SUB.API_ID";
        HashSet<APIIdentifier> apiList = new HashSet<APIIdentifier>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getAPISql);
            nestedPS.setString(1, accessToken);
            ResultSet nestedRS = nestedPS.executeQuery();
            while (nestedRS.next()) {
                apiList.add(new APIIdentifier(nestedRS.getString("API_PROVIDER"), nestedRS.getString("API_NAME"), nestedRS.getString("API_VERSION")));
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get API ID for token: " + accessToken;
            throw new APIManagementException(msg, (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<SubscribedAPI> getSubscribedAPIs(Subscriber subscriber) throws APIManagementException {
        ResultSet result;
        PreparedStatement ps;
        Connection connection;
        LinkedHashSet<SubscribedAPI> subscribedAPIs;
        block13: {
            subscribedAPIs = new LinkedHashSet<SubscribedAPI>();
            connection = null;
            ps = null;
            result = null;
            connection = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT    SUBS.SUBSCRIPTION_ID   ,API.API_PROVIDER AS API_PROVIDER   ,API.API_NAME AS API_NAME   ,API.API_VERSION AS API_VERSION   ,SUBS.TIER_ID AS TIER_ID   ,APP.APPLICATION_ID AS APP_ID   ,SUBS.LAST_ACCESSED AS LAST_ACCESSED   ,APP.NAME AS APP_NAME FROM    AM_SUBSCRIBER SUB,   AM_APPLICATION APP,    AM_SUBSCRIPTION SUBS,    AM_API API WHERE    SUB.USER_ID = ?    AND SUB.TENANT_ID = ?    AND SUB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID=SUBS.APPLICATION_ID    AND API.API_ID=SUBS.API_ID";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, subscriber.getName());
            int tenantId = IdentityUtil.getTenantIdOFUser((String)subscriber.getName());
            ps.setInt(2, tenantId);
            result = ps.executeQuery();
            if (result != null) break block13;
            LinkedHashSet<SubscribedAPI> linkedHashSet = subscribedAPIs;
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
            return linkedHashSet;
        }
        try {
            TreeMap<String, TreeSet<SubscribedAPI>> map = new TreeMap<String, TreeSet<SubscribedAPI>>();
            LRUCache<Integer, Application> applicationCache = new LRUCache<Integer, Application>(100);
            while (result.next()) {
                APIIdentifier apiIdentifier = new APIIdentifier(result.getString("API_PROVIDER"), result.getString("API_NAME"), result.getString("API_VERSION"));
                SubscribedAPI subscribedAPI = new SubscribedAPI(subscriber, apiIdentifier);
                subscribedAPI.setTier(new Tier(result.getString("TIER_ID")));
                subscribedAPI.setLastAccessed((Date)result.getDate("LAST_ACCESSED"));
                int applicationId = result.getInt("APP_ID");
                Application application = (Application)applicationCache.get(applicationId);
                if (application == null) {
                    application = new Application(result.getString("APP_NAME"), subscriber);
                    application.setId(result.getInt("APP_ID"));
                    Set<APIKey> keys = this.getApplicationKeys(applicationId);
                    for (APIKey key : keys) {
                        application.addKey(key);
                    }
                    applicationCache.put(applicationId, application);
                }
                subscribedAPI.setApplication(application);
                int subscriptionId = result.getInt("SUBSCRIPTION_ID");
                Set<APIKey> apiKeys = this.getAPIKeysBySubscription(subscriptionId);
                for (APIKey key : apiKeys) {
                    subscribedAPI.addKey(key);
                }
                if (!map.containsKey(application.getName())) {
                    map.put(application.getName(), new TreeSet<SubscribedAPI>(new Comparator<SubscribedAPI>(){

                        @Override
                        public int compare(SubscribedAPI o1, SubscribedAPI o2) {
                            int placement = o1.getApiId().getApiName().compareTo(o2.getApiId().getApiName());
                            if (placement == 0) {
                                return new APIVersionComparator().compare(new API(o1.getApiId()), new API(o2.getApiId()));
                            }
                            return placement;
                        }
                    }));
                }
                ((Set)map.get(application.getName())).add(subscribedAPI);
            }
            for (String application : map.keySet()) {
                Set apis = (Set)map.get(application);
                for (SubscribedAPI api : apis) {
                    subscribedAPIs.add(api);
                }
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to get SubscribedAPI of :" + subscriber.getName();
                throw new APIManagementException(msg, (Throwable)e);
                catch (IdentityException e2) {
                    msg = "Failed get tenant id of user " + subscriber.getName();
                    throw new APIManagementException(msg, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return subscribedAPIs;
    }

    private Set<APIKey> getAPIKeysBySubscription(int subscriptionId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String getKeysSql = "SELECT  SKM.ACCESS_TOKEN AS ACCESS_TOKEN, SKM.KEY_TYPE AS TOKEN_TYPE FROM AM_SUBSCRIPTION_KEY_MAPPING SKM WHERE SKM.SUBSCRIPTION_ID = ?";
        HashSet<APIKey> apiKeys = new HashSet<APIKey>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getKeysSql);
            nestedPS.setInt(1, subscriptionId);
            ResultSet nestedRS = nestedPS.executeQuery();
            while (nestedRS.next()) {
                APIKey apiKey = new APIKey();
                apiKey.setKey(nestedRS.getString("ACCESS_TOKEN"));
                apiKey.setType(nestedRS.getString("TOKEN_TYPE"));
                apiKeys.add(apiKey);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get API keys for subscription: " + subscriptionId;
            throw new APIManagementException(msg, (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiKeys;
    }

    private Set<APIKey> getApplicationKeys(int applicationId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String getKeysSql = "SELECT  AKM.ACCESS_TOKEN AS ACCESS_TOKEN, AKM.KEY_TYPE AS TOKEN_TYPE FROM AM_APPLICATION_KEY_MAPPING AKM WHERE AKM.APPLICATION_ID = ?";
        HashSet<APIKey> apiKeys = new HashSet<APIKey>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getKeysSql);
            nestedPS.setInt(1, applicationId);
            ResultSet nestedRS = nestedPS.executeQuery();
            while (nestedRS.next()) {
                APIKey apiKey = new APIKey();
                apiKey.setKey(nestedRS.getString("ACCESS_TOKEN"));
                apiKey.setType(nestedRS.getString("TOKEN_TYPE"));
                apiKeys.add(apiKey);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get keys for application: " + applicationId;
            throw new APIManagementException(msg, (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiKeys;
    }

    public Set<Subscriber> getSubscribersOfProvider(String providerName) throws APIManagementException {
        HashSet<Subscriber> subscribers = new HashSet<Subscriber>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT    SUBS.USER_ID AS USER_ID,   SUBS.EMAIL_ADDRESS AS EMAIL_ADDRESS,    SUBS.DATE_SUBSCRIBED AS DATE_SUBSCRIBED FROM    AM_SUBSCRIBER  SUBS,   AM_APPLICATION  APP,    AM_SUBSCRIPTION SUB,    AM_API API WHERE     SUB.APPLICATION_ID = APP.APPLICATION_ID    AND SUBS. SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND API.API_ID = SUB.API_ID    AND API.API_PROVIDER = ?";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, providerName);
            result = ps.executeQuery();
            while (result.next()) {
                Subscriber subscriber = new Subscriber(result.getString("EMAIL_ADDRESS"));
                subscriber.setName(result.getString("USER_ID"));
                subscriber.setSubscribedDate((Date)result.getDate("DATE_SUBSCRIBED"));
                subscribers.add(subscriber);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to subscribers for :" + providerName;
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return subscribers;
    }

    public Set<Subscriber> getSubscribersOfAPI(APIIdentifier identifier) throws APIManagementException {
        ResultSet result;
        PreparedStatement ps;
        Connection connection;
        HashSet<Subscriber> subscribers;
        block6: {
            subscribers = new HashSet<Subscriber>();
            connection = null;
            ps = null;
            result = null;
            connection = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT SB.USER_ID, SB.DATE_SUBSCRIBED FROM AM_SUBSCRIBER SB, AM_SUBSCRIPTION SP,AM_APPLICATION APP,AM_API API WHERE API.API_PROVIDER=? AND API.API_NAME=? AND API.API_VERSION=? AND SP.APPLICATION_ID=APP.APPLICATION_ID AND APP.SUBSCRIBER_ID=SB.SUBSCRIBER_ID  AND API.API_ID = SP.API_ID";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, identifier.getProviderName());
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            result = ps.executeQuery();
            if (result != null) break block6;
            HashSet<Subscriber> hashSet = subscribers;
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
            return hashSet;
        }
        try {
            while (result.next()) {
                Subscriber subscriber = new Subscriber(result.getString("USER_ID"));
                subscriber.setSubscribedDate((Date)result.getTimestamp("DATE_SUBSCRIBED"));
                subscribers.add(subscriber);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to get subscribers for :" + identifier.getApiName();
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return subscribers;
    }

    public long getAPISubscriptionCountByAPI(APIIdentifier identifier) throws APIManagementException {
        ResultSet result;
        PreparedStatement ps;
        Connection connection;
        long subscriptions;
        block6: {
            String sqlQuery = "SELECT COUNT(SUB.SUBSCRIPTION_ID) AS SUB_ID FROM AM_SUBSCRIPTION SUB, AM_API API  WHERE API.API_PROVIDER=?  AND API.API_NAME=? AND API.API_VERSION=? AND API.API_ID=SUB.API_ID";
            subscriptions = 0L;
            connection = null;
            ps = null;
            result = null;
            connection = APIMgtDBUtil.getConnection();
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, identifier.getProviderName());
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            result = ps.executeQuery();
            if (result != null) break block6;
            long l = subscriptions;
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
            return l;
        }
        try {
            while (result.next()) {
                subscriptions = result.getLong("SUB_ID");
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to get subscription count for API";
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return subscriptions;
    }

    public void updateSubscriptions(APIIdentifier identifier, String context, int applicationId) throws APIManagementException {
        this.addSubscription(identifier, context, applicationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerAccessToken(String consumerKey, String applicationName, String userId, int tenantId, APIInfoDTO apiInfoDTO, String keyType) throws IdentityException {
        String sqlAddAccessToken = "INSERT INTO IDENTITY_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, CONSUMER_KEY, TOKEN_STATE, TOKEN_SCOPE)  VALUES (?,?,?,?)";
        String getSubscriptionId = "SELECT SUBS.SUBSCRIPTION_ID FROM   AM_SUBSCRIPTION SUBS,   AM_APPLICATION APP,   AM_SUBSCRIBER SUB,   AM_API API WHERE   SUB.USER_ID = ?  AND SUB.TENANT_ID = ?  AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID  AND APP.NAME = ?  AND API.API_PROVIDER = ?  AND API.API_NAME = ?  AND API.API_VERSION = ?  AND APP.APPLICATION_ID = SUBS.APPLICATION_ID  AND API.API_ID = SUBS.API_ID";
        String addSubscriptionKeyMapping = "INSERT INTO AM_SUBSCRIPTION_KEY_MAPPING (SUBSCRIPTION_ID, ACCESS_TOKEN, KEY_TYPE) VALUES (?,?,?)";
        String accessToken = OAuthUtil.getRandomNumber();
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlAddAccessToken);
            prepStmt.setString(1, accessToken);
            prepStmt.setString(2, consumerKey);
            prepStmt.setString(3, "ACTIVE");
            prepStmt.setString(4, keyType);
            prepStmt.execute();
            prepStmt.close();
            int subscriptionId = -1;
            prepStmt = connection.prepareStatement(getSubscriptionId);
            prepStmt.setString(1, userId);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, applicationName);
            prepStmt.setString(4, apiInfoDTO.getProviderId());
            prepStmt.setString(5, apiInfoDTO.getApiName());
            prepStmt.setString(6, apiInfoDTO.getVersion());
            ResultSet getSubscriptionIdResult = prepStmt.executeQuery();
            while (getSubscriptionIdResult.next()) {
                subscriptionId = getSubscriptionIdResult.getInt(1);
            }
            prepStmt.close();
            prepStmt = connection.prepareStatement(addSubscriptionKeyMapping);
            prepStmt.setInt(1, subscriptionId);
            prepStmt.setString(2, accessToken);
            prepStmt.setString(3, keyType);
            prepStmt.execute();
            prepStmt.close();
            connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add access token ", (Throwable)e);
                }
            }
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerApplicationAccessToken(String consumerKey, String applicationName, String userId, int tenantId, String keyType) throws IdentityException {
        String sqlAddAccessToken = "INSERT INTO IDENTITY_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, CONSUMER_KEY, TOKEN_STATE, TOKEN_SCOPE)  VALUES (?,?,?,?)";
        String getApplicationId = "SELECT APP.APPLICATION_ID FROM   AM_APPLICATION APP,   AM_SUBSCRIBER SUB WHERE   SUB.USER_ID = ?  AND SUB.TENANT_ID = ?  AND APP.NAME = ?  AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID";
        String addApplicationKeyMapping = "INSERT INTO AM_APPLICATION_KEY_MAPPING (APPLICATION_ID, ACCESS_TOKEN, KEY_TYPE) VALUES (?,?,?)";
        String accessToken = OAuthUtil.getRandomNumber();
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlAddAccessToken);
            prepStmt.setString(1, accessToken);
            prepStmt.setString(2, consumerKey);
            prepStmt.setString(3, "ACTIVE");
            prepStmt.setString(4, keyType);
            prepStmt.execute();
            prepStmt.close();
            int applicationId = -1;
            prepStmt = connection.prepareStatement(getApplicationId);
            prepStmt.setString(1, userId);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, applicationName);
            ResultSet getApplicationIdResult = prepStmt.executeQuery();
            while (getApplicationIdResult.next()) {
                applicationId = getApplicationIdResult.getInt(1);
            }
            prepStmt.close();
            prepStmt = connection.prepareStatement(addApplicationKeyMapping);
            prepStmt.setInt(1, applicationId);
            prepStmt.setString(2, accessToken);
            prepStmt.setString(3, keyType);
            prepStmt.execute();
            prepStmt.close();
            connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add access token ", (Throwable)e);
                }
            }
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        return accessToken;
    }

    public boolean isSubscribed(APIIdentifier apiIdentifier, String userId) throws APIManagementException {
        boolean isSubscribed = false;
        String apiId = apiIdentifier.getProviderName() + "_" + apiIdentifier.getApiName() + "_" + apiIdentifier.getVersion();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT    SUBS.TIER_ID ,   API.API_PROVIDER ,   API.API_NAME ,   API.API_VERSION ,   SUBS.LAST_ACCESSED ,   SUBS.APPLICATION_ID FROM    AM_SUBSCRIPTION SUBS,   AM_SUBSCRIBER SUB,    AM_APPLICATION  APP,    AM_API API WHERE    API.API_PROVIDER  = ?   AND API.API_NAME = ?   AND API.API_VERSION = ?   AND SUB.USER_ID = ?   AND SUB.TENANT_ID = ?    AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID   AND API.API_ID = SUBS.API_ID";
        try {
            int tenantId;
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, apiIdentifier.getProviderName());
            ps.setString(2, apiIdentifier.getApiName());
            ps.setString(3, apiIdentifier.getVersion());
            ps.setString(4, userId);
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
            }
            catch (IdentityException e) {
                throw new APIManagementException("Failed to get tenant id of user : " + userId, (Throwable)e);
            }
            ps.setInt(5, tenantId);
            rs = ps.executeQuery();
            if (rs.next()) {
                isSubscribed = true;
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error when executing the SQL query : " + sqlQuery), (Throwable)e);
                throw new APIManagementException("Error while checking if user has subscribed to the API ", (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return isSubscribed;
    }

    public UserApplicationAPIUsage[] getAllAPIUsageByProvider(String providerName) throws APIManagementException {
        UserApplicationAPIUsage[] userApplicationAPIUsageArray;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT    SUBS.SUBSCRIPTION_ID AS SUBSCRIPTION_ID,    SUBS.TIER_ID AS TIER_ID,    API.API_PROVIDER AS API_PROVIDER,    API.API_NAME AS API_NAME,    API.API_VERSION AS API_VERSION,    SUBS.LAST_ACCESSED AS LAST_ACCESSED,    SUB.USER_ID AS USER_ID,    APP.NAME AS APPNAME FROM    AM_SUBSCRIPTION SUBS,    AM_APPLICATION APP,    AM_SUBSCRIBER SUB,    AM_API API WHERE    SUBS.APPLICATION_ID = APP.APPLICATION_ID    AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID    AND API.API_PROVIDER = ?    AND API.API_ID = SUBS.API_ID ORDER BY    APP.NAME";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, providerName);
            result = ps.executeQuery();
            TreeMap<String, UserApplicationAPIUsage> userApplicationUsages = new TreeMap<String, UserApplicationAPIUsage>();
            while (result.next()) {
                String userId = result.getString("USER_ID");
                String application = result.getString("APPNAME");
                String key = userId + "::" + application;
                UserApplicationAPIUsage usage = (UserApplicationAPIUsage)userApplicationUsages.get(key);
                if (usage == null) {
                    usage = new UserApplicationAPIUsage();
                    usage.setUserId(userId);
                    usage.setApplicationName(application);
                    userApplicationUsages.put(key, usage);
                }
                usage.addApiIdentifier(new APIIdentifier(result.getString("API_PROVIDER"), result.getString("API_NAME"), result.getString("API_VERSION")));
            }
            userApplicationAPIUsageArray = userApplicationUsages.values().toArray(new UserApplicationAPIUsage[userApplicationUsages.size()]);
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to find API Usage for :" + providerName;
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return userApplicationAPIUsageArray;
    }

    public Subscriber getSubscriberById(String accessToken) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        Subscriber subscriber = null;
        String query = " SELECT SB.USER_ID, SB.DATE_SUBSCRIBED FROM AM_SUBSCRIBER SB , AM_SUBSCRIPTION SP, AM_APPLICATION APP, AM_SUBSCRIPTION_KEY_MAPPING SKM WHERE SKM.ACCESS_TOKEN=? AND SP.APPLICATION_ID=APP.APPLICATION_ID AND APP.SUBSCRIBER_ID=SB.SUBSCRIBER_ID AND SP.SUBSCRIPTION_ID=SKM.SUBSCRIPTION_ID";
        try {
            connection = APIMgtDBUtil.getConnection();
            ps = connection.prepareStatement(query);
            ps.setString(1, accessToken);
            result = ps.executeQuery();
            while (result.next()) {
                subscriber = new Subscriber(result.getString("USER_ID"));
                subscriber.setSubscribedDate((Date)result.getDate("DATE_SUBSCRIBED"));
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to get Subscriber for accessToken";
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return subscriber;
    }

    public String[] addOAuthConsumer(String username, int tenantId) throws IdentityOAuthAdminException, APIManagementException {
        String consumerKey;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        String sqlStmt = "INSERT INTO IDENTITY_OAUTH_CONSUMER_APPLICATIONS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, OAUTH_VERSION) VALUES (?,?,?,?,?) ";
        String consumerSecret = OAuthUtil.getRandomNumber();
        while (this.isDuplicateConsumer(consumerKey = OAuthUtil.getRandomNumber())) {
        }
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlStmt);
            prepStmt.setString(1, consumerKey);
            prepStmt.setString(2, consumerSecret);
            prepStmt.setString(3, username);
            prepStmt.setInt(4, tenantId);
            prepStmt.setString(5, "OAuth-1.0a");
            prepStmt.execute();
            connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Error when executing the SQL : " + sqlStmt));
            throw new APIManagementException("Error when adding a new OAuth consumer.", (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
        }
        return new String[]{consumerKey, consumerSecret};
    }

    private boolean isDuplicateConsumer(String consumerKey) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rSet = null;
        String sqlQuery = "SELECT * FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?";
        boolean isDuplicateConsumer = false;
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, consumerKey);
            rSet = prepStmt.executeQuery();
            if (rSet.next()) {
                isDuplicateConsumer = true;
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error when executing the SQL : " + sqlQuery));
                throw new APIManagementException("Error when reading the application information from the persistence store.", (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rSet);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rSet);
        return isDuplicateConsumer;
    }

    public void addApplication(Application application, String userId) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        try {
            int tenantId;
            conn = APIMgtDBUtil.getConnection();
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
            }
            catch (IdentityException e) {
                String msg = "Failed to get tenant id of user : " + userId;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            Subscriber subscriber = this.getSubscriber(userId, tenantId);
            if (subscriber == null) {
                throw new APIManagementException("Could not load Subscriber record for : " + userId);
            }
            String sqlQuery = "INSERT INTO AM_APPLICATION (NAME, SUBSCRIBER_ID) VALUES (?,?)";
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, application.getName());
            ps.setInt(2, subscriber.getId());
            ps.executeUpdate();
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to add Application";
                log.error((Object)msg, (Throwable)e);
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the add Application ", (Throwable)e);
                    }
                }
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    public void updateApplication(Application application) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "UPDATE AM_APPLICATION SET NAME = ? WHERE APPLICATION_ID = ?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, application.getName());
            ps.setInt(2, application.getId());
            ps.executeUpdate();
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to update Application";
                log.error((Object)msg, (Throwable)e);
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the update Application ", (Throwable)e);
                    }
                }
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    /*
     * Unable to fully structure code
     */
    public Application[] getApplications(Subscriber subscriber) throws APIManagementException {
        block9: {
            if (subscriber == null) {
                return null;
            }
            connection = null;
            prepStmt = null;
            rs = null;
            sqlQuery = "SELECT    APPLICATION_ID    ,NAME   ,SUBSCRIBER_ID  FROM    AM_APPLICATION WHERE    SUBSCRIBER_ID  = ?";
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)subscriber.getName());
            }
            catch (IdentityException e) {
                msg = "Failed to get tenant id of user : " + subscriber.getName();
                ApiMgtDAO.log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            if (subscriber.getId() != 0) ** GOTO lbl24
            subs = this.getSubscriber(subscriber.getName(), tenantId);
            if (subs != null) break block9;
            msg = null;
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
            return msg;
        }
        try {
            subscriber = subs;
lbl24:
            // 2 sources

            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, subscriber.getId());
            rs = prepStmt.executeQuery();
            applicationsList = new ArrayList<Application>();
            while (rs.next()) {
                application = new Application(rs.getString("NAME"), subscriber);
                application.setId(rs.getInt("APPLICATION_ID"));
                applicationsList.add(application);
            }
            var10_14 = applications = applicationsList.toArray(new Application[applicationsList.size()]);
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.log.error((Object)("Error when executing the SQL : " + sqlQuery));
                throw new APIManagementException("Error when reading the application information from the persistence store.", (Throwable)e);
            }
            catch (Throwable var11_15) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw var11_15;
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        return var10_14;
    }

    public void deleteApplication(Application application) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String getSubscriptionsQuery = "SELECT SUBSCRIPTION_ID FROM AM_SUBSCRIPTION WHERE APPLICATION_ID = ?";
        String deleteKeyMappingQuery = "DELETE FROM AM_SUBSCRIPTION_KEY_MAPPING WHERE SUBSCRIPTION_ID = ?";
        String deleteSubscriptionsQuery = "DELETE FROM AM_SUBSCRIPTION WHERE APPLICATION_ID = ?";
        String deleteApplicationKeyQuery = "DELETE FROM AM_APPLICATION_KEY_MAPPING WHERE APPLICATION_ID = ?";
        String deleteApplicationQuery = "DELETE FROM AM_APPLICATION WHERE APPLICATION_ID = ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(getSubscriptionsQuery);
            prepStmt.setInt(1, application.getId());
            rs = prepStmt.executeQuery();
            ArrayList<Integer> subscriptions = new ArrayList<Integer>();
            while (rs.next()) {
                subscriptions.add(rs.getInt("SUBSCRIPTION_ID"));
            }
            prepStmt.close();
            rs.close();
            prepStmt = connection.prepareStatement(deleteKeyMappingQuery);
            for (Integer subscriptionId : subscriptions) {
                prepStmt.setInt(1, subscriptionId);
                prepStmt.execute();
            }
            prepStmt.close();
            prepStmt = connection.prepareStatement(deleteSubscriptionsQuery);
            prepStmt.setInt(1, application.getId());
            prepStmt.execute();
            prepStmt.close();
            prepStmt = connection.prepareStatement(deleteApplicationKeyQuery);
            prepStmt.setInt(1, application.getId());
            prepStmt.execute();
            prepStmt.close();
            prepStmt = connection.prepareStatement(deleteApplicationQuery);
            prepStmt.setInt(1, application.getId());
            prepStmt.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Error while removing application details from the database";
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
    }

    private Subscriber getSubscriber(String username, int tenantId) throws APIManagementException {
        Subscriber subscriber;
        ResultSet rs;
        PreparedStatement prepStmt;
        Connection connection;
        block4: {
            Subscriber subscriber2;
            connection = null;
            prepStmt = null;
            rs = null;
            subscriber = null;
            String sqlQuery = "SELECT    SUB.SUBSCRIBER_ID AS SUBSCRIBER_ID   ,SUB.USER_ID AS USER_ID    ,SUB.TENANT_ID AS TENANT_ID   ,SUB.EMAIL_ADDRESS AS EMAIL_ADDRESS   ,SUB.DATE_SUBSCRIBED AS DATE_SUBSCRIBED FROM    AM_SUBSCRIBER SUB WHERE SUB.USER_ID = ? AND SUB.TENANT_ID = ?";
            try {
                connection = APIMgtDBUtil.getConnection();
                prepStmt = connection.prepareStatement(sqlQuery);
                prepStmt.setString(1, username);
                prepStmt.setInt(2, tenantId);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block4;
                subscriber = new Subscriber(rs.getString("USER_ID"));
                subscriber.setEmail(rs.getString("EMAIL_ADDRESS"));
                subscriber.setId(rs.getInt("SUBSCRIBER_ID"));
                subscriber.setSubscribedDate((Date)rs.getDate("DATE_SUBSCRIBED"));
                subscriber.setTenantId(rs.getInt("TENANT_ID"));
                subscriber2 = subscriber;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Error when executing the SQL : " + sqlQuery));
                    throw new APIManagementException("Error when reading the application information from the persistence store.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                    throw throwable;
                }
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
            return subscriber2;
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        return subscriber;
    }

    public void recordAPILifeCycleEvent(APIIdentifier identifier, APIStatus oldStatus, APIStatus newStatus, String userId) throws APIManagementException {
        int tenantId;
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        int apiId = -1;
        try {
            tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
        }
        catch (IdentityException e) {
            String msg = "Failed to get tenant id of user : " + userId;
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        if (oldStatus == null && !newStatus.equals((Object)APIStatus.CREATED)) {
            throw new APIManagementException("Invalid old and new state combination");
        }
        if (oldStatus != null && oldStatus.equals((Object)newStatus)) {
            throw new APIManagementException("No measurable differences in API state");
        }
        String getAPIQuery = "SELECT API.API_ID FROM AM_API API WHERE API.API_PROVIDER = ?AND API.API_NAME = ?AND API.API_VERSION = ?";
        String sqlQuery = "INSERT INTO AM_API_LC_EVENT (API_ID, PREVIOUS_STATE, NEW_STATE, USER_ID, TENANT_ID, EVENT_DATE) VALUES (?,?,?,?,?,?)";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(getAPIQuery);
            ps.setString(1, identifier.getProviderName());
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                apiId = resultSet.getInt("API_ID");
            }
            resultSet.close();
            ps.close();
            if (apiId == -1) {
                throw new APIManagementException("Unable to find the API: " + identifier);
            }
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, apiId);
            if (oldStatus != null) {
                ps.setString(2, oldStatus.getStatus());
            } else {
                ps.setNull(2, 12);
            }
            ps.setString(3, newStatus.getStatus());
            ps.setString(4, userId);
            ps.setInt(5, tenantId);
            ps.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            ps.executeUpdate();
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to record API state change";
                log.error((Object)msg, (Throwable)e);
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the API state change record", (Throwable)e);
                    }
                }
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    public List<LifeCycleEvent> getLifeCycleEvents(APIIdentifier apiId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT LC.API_ID AS API_ID, LC.PREVIOUS_STATE AS PREVIOUS_STATE, LC.NEW_STATE AS NEW_STATE, LC.USER_ID AS USER_ID, LC.EVENT_DATE AS EVENT_DATE FROM AM_API_LC_EVENT LC,  AM_API API WHERE API.API_PROVIDER = ? AND API.API_NAME = ? AND API.API_VERSION = ? AND API.API_ID = LC.API_ID";
        ArrayList<LifeCycleEvent> events = new ArrayList<LifeCycleEvent>();
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, apiId.getProviderName());
            prepStmt.setString(2, apiId.getApiName());
            prepStmt.setString(3, apiId.getVersion());
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                LifeCycleEvent event = new LifeCycleEvent();
                event.setApi(apiId);
                String oldState = rs.getString("PREVIOUS_STATE");
                event.setOldStatus(oldState != null ? APIStatus.valueOf((String)oldState) : null);
                event.setNewStatus(APIStatus.valueOf((String)rs.getString("NEW_STATE")));
                event.setUserId(rs.getString("USER_ID"));
                event.setDate((Date)rs.getTimestamp("EVENT_DATE"));
                events.add(event);
            }
            Collections.sort(events, new Comparator<LifeCycleEvent>(){

                @Override
                public int compare(LifeCycleEvent o1, LifeCycleEvent o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error when executing the SQL : " + sqlQuery));
                throw new APIManagementException("Error when reading the application information from the persistence store.", (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        return events;
    }

    public void makeKeysForwardCompatible(String provider, String apiName, String oldVersion, String newVersion, String context) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String getSubscriptionDataQuery = "SELECT SUB.SUBSCRIPTION_ID AS SUBSCRIPTION_ID, SUB.TIER_ID AS TIER_ID, SUB.APPLICATION_ID AS APPLICATION_ID, API.CONTEXT AS CONTEXT, SKM.ACCESS_TOKEN AS ACCESS_TOKEN, SKM.KEY_TYPE AS KEY_TYPE FROM AM_SUBSCRIPTION SUB, AM_SUBSCRIPTION_KEY_MAPPING SKM,  AM_API API WHERE API.API_PROVIDER = ? AND API.API_NAME = ? AND API.API_VERSION = ? AND SKM.SUBSCRIPTION_ID = SUB.SUBSCRIPTION_ID AND API.API_ID = SUB.API_ID";
        String addSubKeyMapping = "INSERT INTO AM_SUBSCRIPTION_KEY_MAPPING (SUBSCRIPTION_ID, ACCESS_TOKEN, KEY_TYPE) VALUES (?,?,?)";
        String getApplicationDataQuery = "SELECT SUB.SUBSCRIPTION_ID AS SUBSCRIPTION_ID, SUB.TIER_ID AS TIER_ID, APP.APPLICATION_ID AS APPLICATION_ID, API.CONTEXT AS CONTEXT FROM AM_SUBSCRIPTION SUB, AM_APPLICATION APP, AM_API API WHERE API.API_PROVIDER = ? AND API.API_NAME = ? AND API.API_VERSION = ? AND SUB.APPLICATION_ID = APP.APPLICATION_ID AND API.API_ID = SUB.API_ID";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(getSubscriptionDataQuery);
            prepStmt.setString(1, provider);
            prepStmt.setString(2, apiName);
            prepStmt.setString(3, oldVersion);
            rs = prepStmt.executeQuery();
            ArrayList<SubscriptionInfo> subscriptionData = new ArrayList<SubscriptionInfo>();
            HashSet<Integer> subscribedApplications = new HashSet<Integer>();
            while (rs.next()) {
                SubscriptionInfo info = new SubscriptionInfo();
                info.subscriptionId = rs.getInt("SUBSCRIPTION_ID");
                info.tierId = rs.getString("TIER_ID");
                info.context = rs.getString("CONTEXT");
                info.applicationId = rs.getInt("APPLICATION_ID");
                info.accessToken = rs.getString("ACCESS_TOKEN");
                info.tokenType = rs.getString("KEY_TYPE");
                subscriptionData.add(info);
            }
            prepStmt.close();
            rs.close();
            HashMap<Integer, Integer> subscriptionIdMap = new HashMap<Integer, Integer>();
            APIIdentifier apiId = new APIIdentifier(provider, apiName, newVersion);
            for (SubscriptionInfo info : subscriptionData) {
                int subscriptionId;
                if (!subscriptionIdMap.containsKey(info.subscriptionId)) {
                    apiId.setTier(info.tierId);
                    subscriptionId = this.addSubscription(apiId, context, info.applicationId);
                    if (subscriptionId == -1) {
                        throw new APIManagementException("Unable to add a new subscription for the API: " + apiName + ":v" + newVersion);
                    }
                    subscriptionIdMap.put(info.subscriptionId, subscriptionId);
                }
                subscriptionId = (Integer)subscriptionIdMap.get(info.subscriptionId);
                prepStmt = connection.prepareStatement(addSubKeyMapping);
                prepStmt.setInt(1, subscriptionId);
                prepStmt.setString(2, info.accessToken);
                prepStmt.setString(3, info.tokenType);
                prepStmt.execute();
                prepStmt.close();
                subscribedApplications.add(info.applicationId);
            }
            prepStmt = connection.prepareStatement(getApplicationDataQuery);
            prepStmt.setString(1, provider);
            prepStmt.setString(2, apiName);
            prepStmt.setString(3, oldVersion);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                int applicationId = rs.getInt("APPLICATION_ID");
                if (subscribedApplications.contains(applicationId)) continue;
                apiId.setTier(rs.getString("TIER_ID"));
                this.addSubscription(apiId, rs.getString("CONTEXT"), applicationId);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Error when executing the SQL queries");
                throw new APIManagementException("Error when reading the application information from the persistence store.", (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
    }

    public void addAPI(API api) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "INSERT INTO AM_API (API_PROVIDER, API_NAME, API_VERSION, CONTEXT) VALUES (?,?,?,?)";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, api.getId().getProviderName());
            prepStmt.setString(2, api.getId().getApiName());
            prepStmt.setString(3, api.getId().getVersion());
            prepStmt.setString(4, api.getContext());
            prepStmt.execute();
            connection.commit();
            this.recordAPILifeCycleEvent(api.getId(), null, APIStatus.CREATED, api.getId().getProviderName());
        }
        catch (SQLException e) {
            String msg = "Error while adding the API: " + api.getId() + " to the database";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
    }

    public void updateAPI(API api) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "UPDATE AM_API SET CONTEXT = ? WHERE API_PROVIDER = ? AND API_NAME = ? AND API_VERSION = ? ";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, api.getContext());
            prepStmt.setString(2, api.getId().getProviderName());
            prepStmt.setString(3, api.getId().getApiName());
            prepStmt.setString(4, api.getId().getVersion());
            prepStmt.execute();
            connection.commit();
        }
        catch (SQLException e) {
            String msg = "Error while updating the API: " + api.getId() + " in the database";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
    }

    public void deleteAPI(APIIdentifier apiId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int id = -1;
        String getAPIQuery = "SELECT API.API_ID FROM AM_API API WHERE API.API_PROVIDER = ?AND API.API_NAME = ?AND API.API_VERSION = ?";
        String deleteLCEventQuery = "DELETE FROM AM_API_LC_EVENT WHERE API_ID=? ";
        String deleteSubscriptionQuery = "DELETE FROM AM_SUBSCRIPTION WHERE API_ID=?";
        String deleteAPIQuery = "DELETE FROM AM_API WHERE API_PROVIDER=? AND API_NAME=? AND API_VERSION=? ";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(getAPIQuery);
            prepStmt.setString(1, apiId.getProviderName());
            prepStmt.setString(2, apiId.getApiName());
            prepStmt.setString(3, apiId.getVersion());
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                id = rs.getInt("API_ID");
            }
            rs.close();
            prepStmt.close();
            if (id == -1) {
                throw new APIManagementException("Unable to find the API: " + apiId);
            }
            prepStmt = connection.prepareStatement(deleteSubscriptionQuery);
            prepStmt.setInt(1, id);
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteLCEventQuery);
            prepStmt.setInt(1, id);
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteAPIQuery);
            prepStmt.setString(1, apiId.getProviderName());
            prepStmt.setString(2, apiId.getApiName());
            prepStmt.setString(3, apiId.getVersion());
            prepStmt.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Error while removing the API: " + apiId + " from the database";
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
    }

    private static class SubscriptionInfo {
        private int subscriptionId;
        private String tierId;
        private String context;
        private int applicationId;
        private String accessToken;
        private String tokenType;

        private SubscriptionInfo() {
        }
    }
}

