/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DuplicateAPIException;
import org.wso2.carbon.apimgt.impl.APIProviderImpl;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class UserAwareAPIProvider
extends APIProviderImpl {
    private String username;

    UserAwareAPIProvider(String username) throws APIManagementException {
        super(username);
        this.username = username;
    }

    @Override
    public void addAPI(API api) throws APIManagementException {
        this.checkCreatePermission();
        super.addAPI(api);
    }

    @Override
    public void createNewAPIVersion(API api, String newVersion) throws DuplicateAPIException, APIManagementException {
        this.checkCreatePermission();
        super.createNewAPIVersion(api, newVersion);
    }

    @Override
    public void updateAPI(API api) throws APIManagementException {
        this.checkCreatePermission();
        super.updateAPI(api);
    }

    @Override
    public void deleteAPI(APIIdentifier identifier) throws APIManagementException {
        this.checkCreatePermission();
        super.deleteAPI(identifier);
    }

    @Override
    public void changeAPIStatus(API api, APIStatus status, String userId, boolean updateGatewayConfig) throws APIManagementException {
        this.checkPublishPermission();
        super.changeAPIStatus(api, status, userId, updateGatewayConfig);
    }

    @Override
    public void addDocumentation(APIIdentifier apiId, Documentation documentation) throws APIManagementException {
        this.checkCreatePermission();
        super.addDocumentation(apiId, documentation);
    }

    @Override
    public void removeDocumentation(APIIdentifier apiId, String docName, String docType) throws APIManagementException {
        this.checkCreatePermission();
        super.removeDocumentation(apiId, docName, docType);
    }

    @Override
    public void updateDocumentation(APIIdentifier apiId, Documentation documentation) throws APIManagementException {
        this.checkCreatePermission();
        super.updateDocumentation(apiId, documentation);
    }

    @Override
    public void addDocumentationContent(APIIdentifier identifier, String documentationName, String text) throws APIManagementException {
        this.checkCreatePermission();
        super.addDocumentationContent(identifier, documentationName, text);
    }

    @Override
    public void copyAllDocumentation(APIIdentifier apiId, String toVersion) throws APIManagementException {
        this.checkCreatePermission();
        super.copyAllDocumentation(apiId, toVersion);
    }

    public void checkCreatePermission() throws APIManagementException {
        APIUtil.checkPermission(this.username, "/permission/admin/manage/api/create");
    }

    public void checkPublishPermission() throws APIManagementException {
        APIUtil.checkPermission(this.username, "/permission/admin/manage/api/publish");
    }
}

