/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.impl.APIConsumerImpl;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class UserAwareAPIConsumer
extends APIConsumerImpl {
    private String username;

    UserAwareAPIConsumer() throws APIManagementException {
    }

    UserAwareAPIConsumer(String username) throws APIManagementException {
        super(username);
        this.username = username;
    }

    @Override
    public void addSubscription(APIIdentifier identifier, String userId, int applicationId) throws APIManagementException {
        this.checkSubscribePermission();
        super.addSubscription(identifier, userId, applicationId);
    }

    @Override
    public void removeSubscription(APIIdentifier identifier, String userId, int applicationId) throws APIManagementException {
        this.checkSubscribePermission();
        super.removeSubscription(identifier, userId, applicationId);
    }

    @Override
    public void addApplication(Application application, String userId) throws APIManagementException {
        this.checkSubscribePermission();
        super.addApplication(application, userId);
    }

    @Override
    public void updateApplication(Application application) throws APIManagementException {
        this.checkSubscribePermission();
        super.updateApplication(application);
    }

    @Override
    public void removeApplication(Application application) throws APIManagementException {
        this.checkSubscribePermission();
        super.removeApplication(application);
    }

    @Override
    public void addComment(APIIdentifier identifier, String s, String user) throws APIManagementException {
        this.checkSubscribePermission();
        super.addComment(identifier, s, user);
    }

    public void checkSubscribePermission() throws APIManagementException {
        APIUtil.checkPermission(this.username, "/permission/admin/manage/api/subscribe");
    }
}

