/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIManager;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationType;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APINameComparator;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;

public abstract class AbstractAPIManager
implements APIManager {
    protected Log log = LogFactory.getLog(this.getClass());
    protected Registry registry;
    protected ApiMgtDAO apiMgtDAO = new ApiMgtDAO();

    public AbstractAPIManager() throws APIManagementException {
        try {
            this.registry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceSystemRegistry();
        }
        catch (RegistryException e) {
            this.handleException("Error while obtaining registry objects", (Exception)((Object)e));
        }
    }

    public AbstractAPIManager(String username) throws APIManagementException {
        try {
            this.registry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceUserRegistry(username);
        }
        catch (RegistryException e) {
            this.handleException("Error while obtaining registry objects", (Exception)((Object)e));
        }
    }

    public void cleanup() {
    }

    public List<API> getAllAPIs() throws APIManagementException {
        ArrayList<API> apiSortedList = new ArrayList<API>();
        try {
            GenericArtifact[] artifacts;
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            for (GenericArtifact artifact : artifacts = artifactManager.getAllGenericArtifacts()) {
                apiSortedList.add(APIUtil.getAPI((GovernanceArtifact)artifact, this.registry));
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get APIs from the registry", (Exception)((Object)e));
        }
        Collections.sort(apiSortedList, new APINameComparator());
        return apiSortedList;
    }

    public API getAPI(APIIdentifier identifier) throws APIManagementException {
        String apiPath = APIUtil.getAPIPath(identifier);
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            Resource apiResource = this.registry.get(apiPath);
            String artifactId = apiResource.getUUID();
            if (artifactId == null) {
                throw new APIManagementException("artifact id is null for : " + apiPath);
            }
            GenericArtifact apiArtifact = artifactManager.getGenericArtifact(artifactId);
            return APIUtil.getAPI((GovernanceArtifact)apiArtifact, this.registry);
        }
        catch (RegistryException e) {
            this.handleException("Failed to get API from : " + apiPath, (Exception)((Object)e));
            return null;
        }
    }

    public boolean isAPIAvailable(APIIdentifier identifier) throws APIManagementException {
        String path = "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getApiName() + "/" + identifier.getVersion();
        try {
            return this.registry.resourceExists(path);
        }
        catch (RegistryException e) {
            this.handleException("Failed to check availability of api :" + path, (Exception)((Object)e));
            return false;
        }
    }

    public Set<String> getAPIVersions(String providerName, String apiName) throws APIManagementException {
        HashSet<String> versionSet;
        block5: {
            versionSet = new HashSet<String>();
            String apiPath = "/apimgt/applicationdata/provider/" + providerName + "/" + apiName;
            try {
                Resource resource = this.registry.get(apiPath);
                if (resource instanceof Collection) {
                    Collection collection = (Collection)resource;
                    String[] versionPaths = collection.getChildren();
                    if (versionPaths == null || versionPaths.length == 0) {
                        return versionSet;
                    }
                    for (String path : versionPaths) {
                        path = path.substring(apiPath.length() + 1);
                        versionSet.add(path);
                    }
                    break block5;
                }
                throw new APIManagementException("API version must be a collection " + apiName);
            }
            catch (RegistryException e) {
                this.handleException("Failed to get versions for API: " + apiName, (Exception)((Object)e));
            }
        }
        return versionSet;
    }

    public String addIcon(APIIdentifier identifier, InputStream in, String contentType) throws APIManagementException {
        try {
            Resource thumb = this.registry.newResource();
            thumb.setContentStream(in);
            thumb.setMediaType(contentType);
            String artifactPath = "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getApiName() + "/" + identifier.getVersion();
            String thumbPath = artifactPath + "/" + "icon";
            AuthorizationManager accessControlAdmin = ServiceReferenceHolder.getInstance().getRegistryService().getUserRealm(IdentityUtil.getTenantIdOFUser((String)identifier.getProviderName())).getAuthorizationManager();
            this.registry.put(thumbPath, thumb);
            if (!accessControlAdmin.isRoleAuthorized("wso2.anonymous.role", "/_system/governance" + thumbPath, "http://www.wso2.org/projects/registry/actions/get")) {
                accessControlAdmin.authorizeRole("wso2.anonymous.role", "/_system/governance" + thumbPath, "http://www.wso2.org/projects/registry/actions/get");
            }
            return "/registry/resource/_system/governance" + thumbPath;
        }
        catch (RegistryException e) {
            this.handleException("Error while adding the icon image to the registry", (Exception)((Object)e));
        }
        catch (UserStoreException e) {
            this.handleException("Error while obtaining the authorization manager", (Exception)((Object)e));
        }
        catch (IdentityException e) {
            this.handleException("Error while checking user permissions", (Exception)((Object)e));
        }
        return null;
    }

    public List<Documentation> getAllDocumentation(APIIdentifier apiId) throws APIManagementException {
        ArrayList<Documentation> documentationList = new ArrayList<Documentation>();
        String apiResourcePath = APIUtil.getAPIPath(apiId);
        try {
            Association[] docAssociations;
            for (Association association : docAssociations = this.registry.getAssociations(apiResourcePath, "document")) {
                String docPath = association.getDestinationPath();
                Resource docResource = this.registry.get(docPath);
                GenericArtifactManager artifactManager = new GenericArtifactManager(this.registry, "document");
                GenericArtifact docArtifact = artifactManager.getGenericArtifact(docResource.getUUID());
                Documentation doc = APIUtil.getDocumentation(docArtifact);
                doc.setLastUpdated(docResource.getLastModified());
                documentationList.add(doc);
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get documentations for api ", (Exception)((Object)e));
        }
        return documentationList;
    }

    public Documentation getDocumentation(APIIdentifier apiId, DocumentationType docType, String docName) throws APIManagementException {
        Documentation documentation = null;
        String docPath = APIUtil.getAPIDocPath(apiId) + docName;
        GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "document");
        try {
            Association[] associations;
            for (Association association : associations = this.registry.getAssociations(docPath, docType.getType())) {
                Resource docResource = this.registry.get(association.getSourcePath());
                GenericArtifact artifact = artifactManager.getGenericArtifact(docResource.getId());
                documentation = APIUtil.getDocumentation(artifact);
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get documentation details", (Exception)((Object)e));
        }
        return documentation;
    }

    public String getDocumentationContent(APIIdentifier identifier, String documentationName) throws APIManagementException {
        String contentPath = APIUtil.getAPIDocPath(identifier) + "contents" + "/" + documentationName;
        try {
            Resource docContent = this.registry.get(contentPath);
            return new String((byte[])docContent.getContent());
        }
        catch (RegistryException e) {
            String msg = "No document content found for documentation: " + documentationName + " of API: " + identifier.getApiName();
            this.handleException(msg, (Exception)((Object)e));
            return null;
        }
    }

    public Subscriber getSubscriberById(String accessToken) throws APIManagementException {
        return this.apiMgtDAO.getSubscriberById(accessToken);
    }

    public boolean isContextExist(String context) throws APIManagementException {
        try {
            GenericArtifact[] artifacts;
            GenericArtifactManager artifactManager = new GenericArtifactManager(this.registry, "api");
            for (GenericArtifact artifact : artifacts = artifactManager.getAllGenericArtifacts()) {
                String artifactContext = artifact.getAttribute("overview_context");
                if (!artifactContext.equals(context)) continue;
                return true;
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to check context availability : " + context, (Exception)((Object)e));
        }
        return false;
    }

    public void addSubscriber(Subscriber subscriber) throws APIManagementException {
        this.apiMgtDAO.addSubscriber(subscriber);
    }

    public void updateSubscriber(Subscriber subscriber) throws APIManagementException {
        this.apiMgtDAO.updateSubscriber(subscriber);
    }

    public Subscriber getSubscriber(int subscriberId) throws APIManagementException {
        return this.apiMgtDAO.getSubscriber(subscriberId);
    }

    public InputStream getIcon(APIIdentifier identifier) throws APIManagementException {
        String artifactPath = "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getApiName() + "/" + identifier.getVersion();
        String thumbPath = artifactPath + "/" + "icon";
        try {
            if (this.registry.resourceExists(thumbPath)) {
                Resource res = this.registry.get(thumbPath);
                return res.getContentStream();
            }
        }
        catch (RegistryException e) {
            this.handleException("Error while loading API icon from the registry", (Exception)((Object)e));
        }
        return null;
    }

    public Set<API> getSubscriberAPIs(Subscriber subscriber) throws APIManagementException {
        TreeSet<API> apiSortedSet = new TreeSet<API>(new APINameComparator());
        Set<SubscribedAPI> subscribedAPIs = this.apiMgtDAO.getSubscribedAPIs(subscriber);
        for (SubscribedAPI subscribedAPI : subscribedAPIs) {
            String apiPath = APIUtil.getAPIPath(subscribedAPI.getApiId());
            try {
                Resource resource = this.registry.get(apiPath);
                GenericArtifactManager artifactManager = new GenericArtifactManager(this.registry, "api");
                GenericArtifact artifact = artifactManager.getGenericArtifact(resource.getUUID());
                API api = APIUtil.getAPI((GovernanceArtifact)artifact, this.registry);
                apiSortedSet.add(api);
            }
            catch (RegistryException e) {
                this.handleException("Failed to get APIs for subscriber: " + subscriber.getName(), (Exception)((Object)e));
            }
        }
        return apiSortedSet;
    }

    protected void handleException(String msg, Exception e) throws APIManagementException {
        this.log.error((Object)msg, (Throwable)e);
        throw new APIManagementException(msg, (Throwable)e);
    }
}

