/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.dto.UserApplicationAPIUsage;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DuplicateAPIException;
import org.wso2.carbon.apimgt.api.model.LifeCycleEvent;
import org.wso2.carbon.apimgt.api.model.Provider;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.api.model.Usage;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.AbstractAPIManager;
import org.wso2.carbon.apimgt.impl.template.APITemplateBuilder;
import org.wso2.carbon.apimgt.impl.template.BasicTemplateBuilder;
import org.wso2.carbon.apimgt.impl.utils.APINameComparator;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.APIVersionComparator;
import org.wso2.carbon.apimgt.impl.utils.RESTAPIAdminClient;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

class APIProviderImpl
extends AbstractAPIManager
implements APIProvider {
    public APIProviderImpl(String username) throws APIManagementException {
        super(username);
    }

    public Set<Provider> getAllProviders() throws APIManagementException {
        HashSet<Provider> providerSet = new HashSet<Provider>();
        GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "provider");
        try {
            GenericArtifact[] genericArtifact = artifactManager.getAllGenericArtifacts();
            if (genericArtifact == null || genericArtifact.length == 0) {
                return providerSet;
            }
            for (GenericArtifact artifact : genericArtifact) {
                Provider provider = new Provider(artifact.getAttribute("overview_name"));
                provider.setDescription("overview_description");
                provider.setEmail("overview_email");
                providerSet.add(provider);
            }
        }
        catch (GovernanceException e) {
            this.handleException("Failed to get all providers", (Exception)((Object)e));
        }
        return providerSet;
    }

    public List<API> getAPIsByProvider(String providerId) throws APIManagementException {
        ArrayList<API> apiSortedList = new ArrayList<API>();
        try {
            Association[] associations;
            String providerPath = "/apimgt/applicationdata/provider/" + providerId;
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            for (Association association : associations = this.registry.getAssociations(providerPath, "provides")) {
                String apiPath = association.getDestinationPath();
                Resource resource = this.registry.get(apiPath);
                String apiArtifactId = resource.getUUID();
                if (apiArtifactId == null) {
                    throw new GovernanceException("artifact id is null of " + apiPath);
                }
                GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiArtifactId);
                apiSortedList.add(APIUtil.getAPI((GovernanceArtifact)apiArtifact, this.registry));
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get APIs for provider : " + providerId, (Exception)((Object)e));
        }
        Collections.sort(apiSortedList, new APINameComparator());
        return apiSortedList;
    }

    public Set<Subscriber> getSubscribersOfProvider(String providerId) throws APIManagementException {
        Set<Subscriber> subscriberSet = null;
        try {
            subscriberSet = this.apiMgtDAO.getSubscribersOfProvider(providerId);
        }
        catch (APIManagementException e) {
            this.handleException("Failed to get Subscribers for : " + providerId, (Exception)((Object)e));
        }
        return subscriberSet;
    }

    public Provider getProvider(String providerName) throws APIManagementException {
        Provider provider = null;
        String providerPath = "/_system/governance/providers/" + providerName;
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "provider");
            Resource providerResource = this.registry.get(providerPath);
            String artifactId = providerResource.getUUID();
            if (artifactId == null) {
                throw new APIManagementException("artifact it is null");
            }
            GenericArtifact providerArtifact = artifactManager.getGenericArtifact(artifactId);
            provider = APIUtil.getProvider(providerArtifact);
        }
        catch (RegistryException e) {
            this.handleException("Failed to get Provider form : " + providerName, (Exception)((Object)e));
        }
        return provider;
    }

    public Usage getUsageByAPI(APIIdentifier apiIdentifier) {
        return null;
    }

    public Usage getAPIUsageByUsers(String providerId, String apiName) {
        return null;
    }

    public UserApplicationAPIUsage[] getAllAPIUsageByProvider(String providerName) throws APIManagementException {
        return this.apiMgtDAO.getAllAPIUsageByProvider(providerName);
    }

    public Usage getAPIUsageBySubscriber(APIIdentifier apiIdentifier, String consumerEmail) {
        return null;
    }

    public Set<Subscriber> getSubscribersOfAPI(APIIdentifier identifier) throws APIManagementException {
        Set<Subscriber> subscriberSet = null;
        try {
            subscriberSet = this.apiMgtDAO.getSubscribersOfAPI(identifier);
        }
        catch (APIManagementException e) {
            this.handleException("Failed to get subscribers for API : " + identifier.getApiName(), (Exception)((Object)e));
        }
        return subscriberSet;
    }

    public long getAPISubscriptionCountByAPI(APIIdentifier identifier) throws APIManagementException {
        long count = 0L;
        try {
            count = this.apiMgtDAO.getAPISubscriptionCountByAPI(identifier);
        }
        catch (APIManagementException e) {
            this.handleException("Failed to get APISubscriptionCount for: " + identifier.getApiName(), (Exception)((Object)e));
        }
        return count;
    }

    public Set<Tier> getTiers() throws APIManagementException {
        TreeSet<Tier> tiers = new TreeSet<Tier>(new Comparator<Tier>(){

            @Override
            public int compare(Tier o1, Tier o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Map<String, Tier> tierMap = APIUtil.getTiers();
        tiers.addAll(tierMap.values());
        return tiers;
    }

    public void addTier(Tier tier) throws APIManagementException {
        this.addOrUpdateTier(tier, false);
    }

    public void updateTier(Tier tier) throws APIManagementException {
        this.addOrUpdateTier(tier, true);
    }

    private void addOrUpdateTier(Tier tier, boolean update) throws APIManagementException {
        if ("Unlimited".equals(tier.getName())) {
            throw new APIManagementException("Changes on the 'Unlimited' tier are not allowed");
        }
        Set<Tier> tiers = this.getTiers();
        if (update && !tiers.contains(tier)) {
            throw new APIManagementException("No tier exists by the name: " + tier.getName());
        }
        HashSet<Tier> finalTiers = new HashSet<Tier>();
        for (Tier t : tiers) {
            if (t.getName().equals(tier.getName())) continue;
            finalTiers.add(t);
        }
        finalTiers.add(tier);
        this.saveTiers(finalTiers);
    }

    private void saveTiers(Collection<Tier> tiers) throws APIManagementException {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement root = fac.createOMElement(APIConstants.POLICY_ELEMENT);
        OMElement assertion = fac.createOMElement(APIConstants.ASSERTION_ELEMENT);
        try {
            Resource resource = this.registry.newResource();
            for (Tier tier : tiers) {
                String policy = new String(tier.getPolicyContent());
                assertion.addChild((OMNode)AXIOMUtil.stringToOM((String)policy));
                if (tier.getDescription() == null || "".equals(tier.getDescription())) continue;
                resource.setProperty("tier.desc." + tier.getName(), tier.getDescription());
            }
            resource.setProperty("tier.desc.Unlimited", "Allows unlimited requests");
            root.addChild((OMNode)assertion);
            resource.setContent((Object)root.toString());
            this.registry.put("/apimgt/applicationdata/tiers.xml", resource);
        }
        catch (XMLStreamException e) {
            this.handleException("Error while constructing tier policy file", e);
        }
        catch (RegistryException e) {
            this.handleException("Error while saving tier configurations to the registry", (Exception)((Object)e));
        }
    }

    public void removeTier(Tier tier) throws APIManagementException {
        if ("Unlimited".equals(tier.getName())) {
            throw new APIManagementException("Changes on the 'Unlimited' tier are not allowed");
        }
        Set<Tier> tiers = this.getTiers();
        if (!tiers.remove(tier)) {
            throw new APIManagementException("No tier exists by the name: " + tier.getName());
        }
        this.saveTiers(tiers);
    }

    public void addAPI(API api) throws APIManagementException {
        try {
            this.registry.beginTransaction();
            this.createAPI(api);
            this.apiMgtDAO.addAPI(api);
            this.registry.commitTransaction();
        }
        catch (RegistryException e) {
            try {
                this.registry.rollbackTransaction();
            }
            catch (RegistryException regE) {
                throw new APIManagementException("Error occurred while rollback the transaction for API" + api.getId().getApiName(), (Throwable)regE);
            }
            throw new APIManagementException("Error occurred while committing the transaction for the API" + api.getId().getApiName(), (Throwable)e);
        }
    }

    public void updateAPI(API api) throws APIManagementException {
        API oldApi = this.getAPI(api.getId());
        if (oldApi.getStatus().equals((Object)api.getStatus())) {
            this.updateApiArtifact(api, true);
            if (!oldApi.getContext().equals(api.getContext())) {
                this.apiMgtDAO.updateAPI(api);
            }
            if (this.isAPIPublished(api)) {
                this.publishToGateway(api);
            }
        } else {
            throw new APIManagementException("Invalid API update operation involving API status changes");
        }
    }

    private void updateApiArtifact(API api, boolean updateMetadata) throws APIManagementException {
        try {
            Set tagSet;
            String apiArtifactId = this.registry.get(APIUtil.getAPIPath(api.getId())).getUUID();
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact artifact = artifactManager.getGenericArtifact(apiArtifactId);
            GenericArtifact updateApiArtifact = APIUtil.createAPIArtifactContent(artifact, api);
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)this.registry, (String)updateApiArtifact.getId());
            Tag[] oldTags = this.registry.getTags(artifactPath);
            if (oldTags != null) {
                for (Tag tag : oldTags) {
                    this.registry.removeTag(artifactPath, tag.getTagName());
                }
            }
            if ((tagSet = api.getTags()) != null) {
                for (String tag : tagSet) {
                    this.registry.applyTag(artifactPath, tag);
                }
            }
            artifactManager.updateGenericArtifact(updateApiArtifact);
            if (updateMetadata) {
                String path;
                if (api.getWsdlUrl() != null && !"".equals(api.getWsdlUrl()) && (path = APIUtil.createWSDL(api.getWsdlUrl(), this.registry)) != null) {
                    this.registry.addAssociation(artifactPath, path, "depends");
                }
                if (api.getUrl() != null && !"".equals(api.getUrl()) && (path = APIUtil.createEndpoint(api.getUrl(), this.registry)) != null) {
                    this.registry.addAssociation(artifactPath, path, "depends");
                }
            }
        }
        catch (RegistryException e) {
            throw new APIManagementException("Failed to obtain id of the API artifact ", (Throwable)e);
        }
    }

    public void changeAPIStatus(API api, APIStatus status, String userId, boolean updateGatewayConfig) throws APIManagementException {
        APIStatus currentStatus = api.getStatus();
        if (!currentStatus.equals((Object)status)) {
            api.setStatus(status);
            this.updateApiArtifact(api, false);
            if (updateGatewayConfig) {
                if (status.equals((Object)APIStatus.PUBLISHED) || status.equals((Object)APIStatus.DEPRECATED) || status.equals((Object)APIStatus.BLOCKED)) {
                    this.publishToGateway(api);
                } else {
                    this.removeFromGateway(api);
                }
            }
            this.apiMgtDAO.recordAPILifeCycleEvent(api.getId(), currentStatus, status, userId);
        }
    }

    public void makeAPIKeysForwardCompatible(API api) throws APIManagementException {
        String provider = api.getId().getProviderName();
        String apiName = api.getId().getApiName();
        Set<String> versions = this.getAPIVersions(provider, apiName);
        APIVersionComparator comparator = new APIVersionComparator();
        for (String version : versions) {
            API otherApi = this.getAPI(new APIIdentifier(provider, apiName, version));
            if (comparator.compare(otherApi, api) >= 0 || !otherApi.getStatus().equals((Object)APIStatus.PUBLISHED)) continue;
            this.apiMgtDAO.makeKeysForwardCompatible(provider, apiName, version, api.getId().getVersion(), api.getContext());
        }
    }

    private void publishToGateway(API api) throws APIManagementException {
        try {
            APITemplateBuilder builder;
            RESTAPIAdminClient client = new RESTAPIAdminClient(api.getId());
            if (api.getStatus().equals((Object)APIStatus.BLOCKED)) {
                HashMap<String, String> testAPIMappings = new HashMap<String, String>();
                testAPIMappings.put("key_for_api_name", api.getId().getProviderName() + "--" + api.getId().getApiName());
                testAPIMappings.put("key_for_api_context", api.getContext());
                testAPIMappings.put("key_for_api_version", api.getId().getVersion());
                builder = new BasicTemplateBuilder(testAPIMappings);
            } else {
                builder = this.getTemplateBuilder(api);
            }
            if (client.getApi() != null) {
                client.updateApi(builder);
            } else {
                client.addApi(builder);
            }
        }
        catch (AxisFault axisFault) {
            this.handleException("Error while creating new API in gateway", (Exception)((Object)axisFault));
        }
    }

    private void removeFromGateway(API api) throws APIManagementException {
        try {
            RESTAPIAdminClient client = new RESTAPIAdminClient(api.getId());
            if (client.getApi() != null) {
                client.deleteApi();
            }
        }
        catch (AxisFault axisFault) {
            this.handleException("Error while creating new API in gateway", (Exception)((Object)axisFault));
        }
    }

    private boolean isAPIPublished(API api) throws APIManagementException {
        try {
            RESTAPIAdminClient client = new RESTAPIAdminClient(api.getId());
            return client.getApi() != null;
        }
        catch (AxisFault axisFault) {
            this.handleException("Error while checking API status", (Exception)((Object)axisFault));
            return false;
        }
    }

    private APITemplateBuilder getTemplateBuilder(API api) {
        HashMap<String, String> testAPIMappings = new HashMap<String, String>();
        testAPIMappings.put("key_for_api_name", api.getId().getProviderName() + "--" + api.getId().getApiName());
        testAPIMappings.put("key_for_api_context", api.getContext());
        testAPIMappings.put("key_for_api_version", api.getId().getVersion());
        Iterator it = api.getUriTemplates().iterator();
        ArrayList<Map<String, String>> resourceMappings = new ArrayList<Map<String, String>>();
        while (it.hasNext()) {
            HashMap<String, String> uriTemplateMap = new HashMap<String, String>();
            URITemplate temp = (URITemplate)it.next();
            uriTemplateMap.put("key_for_resource_uri_template", temp.getUriTemplate());
            uriTemplateMap.put("key_for_resource_methods", temp.getMethodsAsString());
            uriTemplateMap.put("key_for_resource_uri", temp.getResourceURI());
            uriTemplateMap.put("key_for_resource_sandbox_uri", temp.getResourceSandboxURI());
            resourceMappings.add(uriTemplateMap);
        }
        HashMap<String, String> testHandlerMappings_1 = new HashMap<String, String>();
        testHandlerMappings_1.put("key_for_handler_class", "org.wso2.carbon.apimgt.handlers.security.APIAuthenticationHandler");
        HashMap<String, String> testHandlerMappings_2 = new HashMap<String, String>();
        testHandlerMappings_2.put("key_for_handler_class", "org.wso2.carbon.apimgt.usage.publisher.APIMgtUsageHandler");
        HashMap<String, String> testHandlerMappings_3 = new HashMap<String, String>();
        testHandlerMappings_3.put("key_for_handler_class", "org.wso2.carbon.apimgt.handlers.throttling.APIThrottleHandler");
        testHandlerMappings_3.put("key_for_handler_policy", "gov:/apimgt/applicationdata/tiers.xml");
        HashMap<String, String> testHandlerMappings_4 = new HashMap<String, String>();
        testHandlerMappings_4.put("key_for_handler_class", "org.wso2.carbon.apimgt.handlers.ext.APIManagerExtensionHandler");
        ArrayList<Map<String, String>> handlerMappings = new ArrayList<Map<String, String>>();
        handlerMappings.add(testHandlerMappings_1);
        handlerMappings.add(testHandlerMappings_2);
        handlerMappings.add(testHandlerMappings_3);
        handlerMappings.add(testHandlerMappings_4);
        return new BasicTemplateBuilder(testAPIMappings, resourceMappings, handlerMappings);
    }

    public void createNewAPIVersion(API api, String newVersion) throws DuplicateAPIException, APIManagementException {
        String apiSourcePath = APIUtil.getAPIPath(api.getId());
        String targetPath = "/apimgt/applicationdata/provider/" + api.getId().getProviderName() + "/" + api.getId().getApiName() + "/" + newVersion + "/api";
        try {
            String thumbUrl;
            if (this.registry.resourceExists(targetPath)) {
                throw new DuplicateAPIException("API version already exist with version :" + newVersion);
            }
            Resource apiSourceArtifact = this.registry.get(apiSourcePath);
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact artifact = artifactManager.getGenericArtifact(apiSourceArtifact.getUUID());
            artifact.setId(UUID.randomUUID().toString());
            artifact.setAttribute("overview_version", newVersion);
            String status = artifact.getAttribute("overview_status");
            if (!status.equals("CREATED")) {
                artifact.setAttribute("overview_status", "CREATED");
            }
            if (this.registry.resourceExists(thumbUrl = "/apimgt/applicationdata/provider/" + api.getId().getProviderName() + "/" + api.getId().getApiName() + "/" + api.getId().getVersion() + "/" + "icon")) {
                Resource oldImage = this.registry.get(thumbUrl);
                apiSourceArtifact.getContentStream();
                APIIdentifier newApiId = new APIIdentifier(api.getId().getProviderName(), api.getId().getApiName(), newVersion);
                artifact.setAttribute("overview_thumbnail", this.addIcon(newApiId, oldImage.getContentStream(), oldImage.getMediaType()));
            }
            artifactManager.addGenericArtifact(artifact);
            this.registry.addAssociation(APIUtil.getAPIProviderPath(api.getId()), targetPath, "provides");
            Tag[] tags = this.registry.getTags(apiSourcePath);
            if (tags != null) {
                for (Tag tag : tags) {
                    this.registry.applyTag(targetPath, tag.getTagName());
                }
            }
            List<Documentation> docs = this.getAllDocumentation(api.getId());
            APIIdentifier newId = new APIIdentifier(api.getId().getProviderName(), api.getId().getApiName(), newVersion);
            for (Documentation doc : docs) {
                this.addDocumentation(newId, doc);
            }
            GenericArtifact oldArtifact = artifactManager.getGenericArtifact(apiSourceArtifact.getUUID());
            oldArtifact.setAttribute("overview_isLatest", "false");
            artifactManager.updateGenericArtifact(oldArtifact);
            this.apiMgtDAO.addAPI(this.getAPI(newId));
        }
        catch (RegistryException e) {
            String msg = "Failed to create new version : " + newVersion + " of : " + api.getId().getApiName();
            this.handleException(msg, (Exception)((Object)e));
        }
    }

    public void removeDocumentation(APIIdentifier apiId, String docName, String docType) throws APIManagementException {
        String docPath = APIUtil.getAPIDocPath(apiId) + docName;
        try {
            Association[] associations;
            for (Association association : associations = this.registry.getAssociations(docPath, "document")) {
                this.registry.delete(association.getDestinationPath());
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to delete documentation", (Exception)((Object)e));
        }
    }

    public void addDocumentation(APIIdentifier apiId, Documentation documentation) throws APIManagementException {
        this.createDocumentation(apiId, documentation);
    }

    public void addDocumentationContent(APIIdentifier identifier, String documentationName, String text) throws APIManagementException {
        String documentationPath = APIUtil.getAPIDocPath(identifier) + documentationName;
        String contentPath = APIUtil.getAPIDocPath(identifier) + "contents" + "/" + documentationName;
        try {
            Resource docContent = this.registry.newResource();
            docContent.setContent((Object)text);
            this.registry.put(contentPath, docContent);
            this.registry.addAssociation(documentationPath, contentPath, "hasContent");
        }
        catch (RegistryException e) {
            String msg = "Failed to add the documentation content of : " + documentationName + " of API :" + identifier.getApiName();
            this.handleException(msg, (Exception)((Object)e));
        }
    }

    public void updateDocumentation(APIIdentifier apiId, Documentation documentation) throws APIManagementException {
        String docPath = "/apimgt/applicationdata/provider/" + apiId.getProviderName() + "/" + apiId.getApiName() + "/" + apiId.getVersion() + "/" + "documentation" + "/" + documentation.getName();
        try {
            String apiArtifactId = this.registry.get(docPath).getUUID();
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "document");
            GenericArtifact artifact = artifactManager.getGenericArtifact(apiArtifactId);
            GenericArtifact updateApiArtifact = APIUtil.createDocArtifactContent(artifact, apiId, documentation);
            artifactManager.updateGenericArtifact(updateApiArtifact);
        }
        catch (RegistryException e) {
            this.handleException("Failed to update documentation", (Exception)((Object)e));
        }
    }

    public void copyAllDocumentation(APIIdentifier apiId, String toVersion) throws APIManagementException {
        String oldVersion = APIUtil.getAPIDocPath(apiId);
        String newVersion = "/apimgt/applicationdata/provider/" + apiId.getProviderName() + "/" + apiId.getApiName() + "/" + toVersion + "/" + "documentation";
        try {
            Resource resource = this.registry.get(oldVersion);
            if (resource instanceof org.wso2.carbon.registry.core.Collection) {
                String[] docsPaths;
                for (String docPath : docsPaths = ((org.wso2.carbon.registry.core.Collection)resource).getChildren()) {
                    this.registry.copy(docPath, newVersion);
                }
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to copy docs to new version : " + newVersion, (Exception)((Object)e));
        }
    }

    private void createAPI(API api) throws APIManagementException {
        GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
        try {
            String path;
            GenericArtifact genericArtifact = artifactManager.newGovernanceArtifact(new QName(api.getId().getApiName()));
            GenericArtifact artifact = APIUtil.createAPIArtifactContent(genericArtifact, api);
            artifactManager.addGenericArtifact(artifact);
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)this.registry, (String)artifact.getId());
            String providerPath = APIUtil.getAPIProviderPath(api.getId());
            this.registry.addAssociation(providerPath, artifactPath, "provides");
            Set tagSet = api.getTags();
            if (tagSet != null && tagSet.size() > 0) {
                for (String tag : tagSet) {
                    this.registry.applyTag(artifactPath, tag);
                }
            }
            if (api.getWsdlUrl() != null && !"".equals(api.getWsdlUrl()) && (path = APIUtil.createWSDL(api.getWsdlUrl(), this.registry)) != null) {
                this.registry.addAssociation(artifactPath, path, "depends");
            }
            if (api.getUrl() != null && !"".equals(api.getUrl()) && (path = APIUtil.createEndpoint(api.getUrl(), this.registry)) != null) {
                this.registry.addAssociation(artifactPath, path, "depends");
            }
        }
        catch (RegistryException e) {
            this.handleException("Error while adding API", (Exception)((Object)e));
        }
    }

    private void createDocumentation(APIIdentifier apiId, Documentation documentation) throws APIManagementException {
        try {
            GenericArtifactManager artifactManager = new GenericArtifactManager(this.registry, "document");
            GenericArtifact artifact = artifactManager.newGovernanceArtifact(new QName(documentation.getName()));
            artifactManager.addGenericArtifact(APIUtil.createDocArtifactContent(artifact, apiId, documentation));
            String apiPath = APIUtil.getAPIPath(apiId);
            this.registry.addAssociation(apiPath, artifact.getPath(), "document");
        }
        catch (RegistryException e) {
            this.handleException("Failed to add documentation", (Exception)((Object)e));
        }
    }

    public List<LifeCycleEvent> getLifeCycleEvents(APIIdentifier apiId) throws APIManagementException {
        return this.apiMgtDAO.getLifeCycleEvents(apiId);
    }

    public void deleteAPI(APIIdentifier identifier) throws APIManagementException {
        String path = "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getApiName() + "/" + identifier.getVersion();
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            Resource apiResource = this.registry.get(path);
            String artifactId = apiResource.getUUID();
            if (artifactId == null) {
                throw new APIManagementException("artifact id is null for : " + path);
            }
            artifactManager.removeGenericArtifact(artifactId);
            API api = new API(identifier);
            if (this.isAPIPublished(api)) {
                this.removeFromGateway(api);
            }
            this.apiMgtDAO.deleteAPI(identifier);
        }
        catch (RegistryException e) {
            this.handleException("Failed to remove the API from : " + path, (Exception)((Object)e));
        }
    }
}

