/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIConsumer;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIManager;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.impl.UserAwareAPIConsumer;
import org.wso2.carbon.apimgt.impl.UserAwareAPIProvider;
import org.wso2.carbon.apimgt.impl.utils.LRUCache;

public class APIManagerFactory {
    private static final Log log = LogFactory.getLog(APIManagerFactory.class);
    private static final String ANONYMOUS_USER = "__wso2.am.anon__";
    private static final APIManagerFactory instance = new APIManagerFactory();
    private APIManagerCache<APIProvider> providers = new APIManagerCache(50);
    private APIManagerCache<APIConsumer> consumers = new APIManagerCache(500);

    private APIManagerFactory() {
    }

    public static APIManagerFactory getInstance() {
        return instance;
    }

    private APIProvider newProvider(String username) throws APIManagementException {
        return new UserAwareAPIProvider(username);
    }

    private APIConsumer newConsumer(String username) throws APIManagementException {
        if (username.equals(ANONYMOUS_USER)) {
            return new UserAwareAPIConsumer();
        }
        return new UserAwareAPIConsumer(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIProvider getAPIProvider(String username) throws APIManagementException {
        APIProvider provider = (APIProvider)this.providers.get(username);
        if (provider == null) {
            String string = username.intern();
            synchronized (string) {
                provider = (APIProvider)this.providers.get(username);
                if (provider != null) {
                    return provider;
                }
                provider = this.newProvider(username);
                this.providers.put(username, provider);
            }
        }
        return provider;
    }

    public APIConsumer getAPIConsumer() throws APIManagementException {
        return this.getAPIConsumer(ANONYMOUS_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIConsumer getAPIConsumer(String username) throws APIManagementException {
        APIConsumer consumer = (APIConsumer)this.consumers.get(username);
        if (consumer == null) {
            String string = username.intern();
            synchronized (string) {
                consumer = (APIConsumer)this.consumers.get(username);
                if (consumer != null) {
                    return consumer;
                }
                consumer = this.newConsumer(username);
                this.consumers.put(username, consumer);
            }
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        this.consumers.exclusiveLock();
        try {
            for (APIConsumer consumer : this.consumers.values()) {
                this.cleanupSilently((APIManager)consumer);
            }
            this.consumers.clear();
        }
        finally {
            this.consumers.release();
        }
        this.providers.exclusiveLock();
        try {
            for (APIProvider provider : this.providers.values()) {
                this.cleanupSilently((APIManager)provider);
            }
            this.providers.clear();
        }
        finally {
            this.providers.release();
        }
    }

    private void cleanupSilently(APIManager manager) {
        if (manager != null) {
            try {
                manager.cleanup();
            }
            catch (APIManagementException aPIManagementException) {
                // empty catch block
            }
        }
    }

    private class APIManagerCache<T>
    extends LRUCache<String, T> {
        public APIManagerCache(int maxEntries) {
            super(maxEntries);
        }

        @Override
        protected void handleRemovableEntry(Map.Entry<String, T> entry) {
            try {
                ((APIManager)entry.getValue()).cleanup();
            }
            catch (APIManagementException e) {
                log.warn((Object)"Error while cleaning up APIManager instance", (Throwable)e);
            }
        }
    }
}

