/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class APIManagerConfiguration {
    private Map<String, List<String>> configuration = new ConcurrentHashMap<String, List<String>>();
    private SecretResolver secretResolver;
    private boolean initialized;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(String filePath) throws APIManagementException {
        if (this.initialized) {
            return;
        }
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream((File)new File(filePath));
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)in);
            this.secretResolver = SecretResolverFactory.create((OMElement)builder.getDocumentElement(), (boolean)true);
            this.readChildElements(builder.getDocumentElement(), new Stack<String>());
            this.initialized = true;
        }
        catch (IOException e) {
            try {
                throw new APIManagementException("I/O error while reading the API manager configuration: " + filePath, (Throwable)e);
                catch (XMLStreamException e2) {
                    throw new APIManagementException("Error while parsing the API manager configuration: " + filePath, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public String getFirstProperty(String key) {
        List<String> value = this.configuration.get(key);
        if (value == null) {
            return null;
        }
        return value.get(0);
    }

    public void reloadSystemProperties() {
        for (Map.Entry<String, List<String>> entry : this.configuration.entrySet()) {
            List<String> list = entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                String text = list.remove(i);
                list.add(i, this.replaceSystemProperty(text));
            }
        }
    }

    private void readChildElements(OMElement serverConfig, Stack<String> nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            if (this.elementHasText(element)) {
                String key = this.getKey(nameStack);
                String value = element.getText();
                if (this.secretResolver.isInitialized() && this.secretResolver.isTokenProtected(key)) {
                    value = this.secretResolver.resolve(key);
                }
                this.addToConfiguration(key, this.replaceSystemProperty(value));
            }
            this.readChildElements(element, nameStack);
            nameStack.pop();
        }
    }

    private String getKey(Stack<String> nameStack) {
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    private void addToConfiguration(String key, String value) {
        List<String> list = this.configuration.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            list.add(value);
            this.configuration.put(key, list);
        } else if (!list.contains(value)) {
            list.add(value);
        }
    }

    private String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf(125)) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!sysProp.equals("carbon.home") || propValue == null || !propValue.equals(".")) continue;
            text = new File(".").getAbsolutePath() + File.separator + text;
        }
        return text;
    }
}

