/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.apimgt.api.APIConsumer;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIKey;
import org.wso2.carbon.apimgt.api.model.APIRating;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.Comment;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.handlers.security.stub.types.APIKeyMapping;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.AbstractAPIManager;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIAuthenticationAdminClient;
import org.wso2.carbon.apimgt.impl.utils.APINameComparator;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.APIVersionComparator;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

class APIConsumerImpl
extends AbstractAPIManager
implements APIConsumer {
    public APIConsumerImpl() throws APIManagementException {
    }

    public APIConsumerImpl(String username) throws APIManagementException {
        super(username);
    }

    public Subscriber getSubscriber(String subscriberId) throws APIManagementException {
        Subscriber subscriber = null;
        try {
            subscriber = this.apiMgtDAO.getSubscriber(subscriberId);
        }
        catch (APIManagementException e) {
            this.handleException("Failed to get Subscriber", (Exception)((Object)e));
        }
        return subscriber;
    }

    public Set<API> getAPIsWithTag(String tag) throws APIManagementException {
        HashSet<API> apiSet = new HashSet<API>();
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact[] genericArtifacts = artifactManager.getAllGenericArtifacts();
            if (genericArtifacts == null || genericArtifacts.length == 0) {
                return apiSet;
            }
            block2: for (GenericArtifact artifact : genericArtifacts) {
                String artifactPath;
                Tag[] tags;
                String status = artifact.getAttribute("overview_status");
                if (!status.equals("PUBLISHED") || (tags = this.registry.getTags(artifactPath = artifact.getPath())) == null || tags.length == 0) continue;
                for (Tag tag1 : tags) {
                    if (!tag.equals(tag1.getTagName())) continue;
                    apiSet.add(APIUtil.getAPI((GovernanceArtifact)artifact, this.registry));
                    continue block2;
                }
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get API for tag " + tag, (Exception)((Object)e));
        }
        return apiSet;
    }

    public Set<API> getAllPublishedAPIs() throws APIManagementException {
        TreeSet<API> apiSortedSet = new TreeSet<API>(new APINameComparator());
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact[] genericArtifacts = artifactManager.getAllGenericArtifacts();
            if (genericArtifacts == null || genericArtifacts.length == 0) {
                return apiSortedSet;
            }
            HashMap<String, API> latestPublishedAPIs = new HashMap<String, API>();
            APIVersionComparator versionComparator = new APIVersionComparator();
            for (GenericArtifact artifact : genericArtifacts) {
                String status = artifact.getAttribute("overview_status");
                if (!status.equals("PUBLISHED")) continue;
                API api = APIUtil.getAPI((GovernanceArtifact)artifact, this.registry);
                String key = api.getId().getProviderName() + ":" + api.getId().getApiName();
                API existingAPI = (API)latestPublishedAPIs.get(key);
                if (existingAPI != null) {
                    if (versionComparator.compare(api, existingAPI) <= 0) continue;
                    latestPublishedAPIs.put(key, api);
                    continue;
                }
                latestPublishedAPIs.put(key, api);
            }
            for (API api : latestPublishedAPIs.values()) {
                apiSortedSet.add(api);
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get all publishers", (Exception)((Object)e));
        }
        return apiSortedSet;
    }

    public Set<API> getTopRatedAPIs(int limit) throws APIManagementException {
        int returnLimit = 0;
        TreeSet<API> apiSortedSet = new TreeSet<API>(new APINameComparator());
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact[] genericArtifacts = artifactManager.getAllGenericArtifacts();
            if (genericArtifacts == null || genericArtifacts.length == 0) {
                return apiSortedSet;
            }
            for (GenericArtifact genericArtifact : genericArtifacts) {
                String artifactPath;
                float rating;
                String status = genericArtifact.getAttribute("overview_status");
                if (!status.equals("PUBLISHED") || !((rating = this.registry.getAverageRating(artifactPath = genericArtifact.getPath())) > 4.0f) || returnLimit >= limit) continue;
                ++returnLimit;
                apiSortedSet.add(APIUtil.getAPI((GovernanceArtifact)genericArtifact, this.registry));
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get top rated API", (Exception)((Object)e));
        }
        return apiSortedSet;
    }

    public Set<API> getRecentlyAddedAPIs(int limit) throws APIManagementException {
        int start = 0;
        TreeSet<API> apiSortedSet = new TreeSet<API>(new APINameComparator());
        HashMap<Date, GenericArtifact> apiMap = new HashMap<Date, GenericArtifact>();
        ArrayList<Date> dateList = new ArrayList<Date>();
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact[] genericArtifact = artifactManager.getAllGenericArtifacts();
            if (genericArtifact == null || genericArtifact.length == 0) {
                return apiSortedSet;
            }
            for (GenericArtifact artifact : genericArtifact) {
                String status = artifact.getAttribute("overview_status");
                if (!status.equals("PUBLISHED")) continue;
                String artifactPath = artifact.getPath();
                Resource resource = this.registry.get(artifactPath);
                Date createdDate = resource.getCreatedTime();
                apiMap.put(createdDate, artifact);
                dateList.add(createdDate);
            }
            Collections.sort(dateList);
            if (limit < dateList.size()) {
                start = dateList.size() - limit;
            }
            for (int i = dateList.size() - 1; i >= start; --i) {
                GenericArtifact genericArtifact1 = (GenericArtifact)apiMap.get(dateList.get(i));
                apiSortedSet.add(APIUtil.getAPI((GovernanceArtifact)genericArtifact1, this.registry));
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get recently added APIs", (Exception)((Object)e));
        }
        return apiSortedSet;
    }

    public Set<org.wso2.carbon.apimgt.api.model.Tag> getAllTags() throws APIManagementException {
        HashSet<org.wso2.carbon.apimgt.api.model.Tag> tagSet = new HashSet<org.wso2.carbon.apimgt.api.model.Tag>();
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact[] genericArtifact = artifactManager.getAllGenericArtifacts();
            if (genericArtifact == null || genericArtifact.length == 0) {
                return tagSet;
            }
            for (GenericArtifact artifact : genericArtifact) {
                String path = artifact.getPath();
                Tag[] regTags = this.registry.getTags(path);
                String status = artifact.getAttribute("overview_status");
                if (!status.equals("PUBLISHED") || regTags == null || regTags.length <= 0) continue;
                for (Tag regTag : regTags) {
                    tagSet.add(new org.wso2.carbon.apimgt.api.model.Tag(regTag.getTagName()));
                }
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get all the tags", (Exception)((Object)e));
        }
        return tagSet;
    }

    public void rateAPI(APIIdentifier apiId, APIRating rating, String user) throws APIManagementException {
        String path = APIUtil.getAPIPath(apiId);
        try {
            this.registry.rateResource(path, rating.getRating());
        }
        catch (RegistryException e) {
            this.handleException("Failed to rate API : " + path, (Exception)((Object)e));
        }
    }

    public int getUserRating(APIIdentifier apiId, String user) throws APIManagementException {
        int rating = -1;
        String path = APIUtil.getAPIPath(apiId);
        try {
            UserRegistry userRegistry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceUserRegistry(user);
            rating = userRegistry.getRating(path, user);
        }
        catch (RegistryException e) {
            this.handleException("Failed to get rating of user : " + user, (Exception)((Object)e));
        }
        return rating;
    }

    public Set<API> getPublishedAPIsByProvider(String providerId) throws APIManagementException {
        TreeSet<API> apiSortedSet = new TreeSet<API>(new APINameComparator());
        try {
            Association[] associations;
            String providerPath = "/apimgt/applicationdata/provider/" + providerId;
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            for (Association association : associations = this.registry.getAssociations(providerPath, "provides")) {
                String apiPath = association.getDestinationPath();
                Resource resource = this.registry.get(apiPath);
                String apiArtifactId = resource.getUUID();
                if (apiArtifactId != null) {
                    GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiArtifactId);
                    String status = apiArtifact.getAttribute("overview_status");
                    if (!status.equals("PUBLISHED")) continue;
                    apiSortedSet.add(APIUtil.getAPI((GovernanceArtifact)apiArtifact, this.registry));
                    continue;
                }
                throw new GovernanceException("artifact id is null of " + apiPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to get Published APIs for provider : " + providerId, (Exception)((Object)e));
        }
        return apiSortedSet;
    }

    public Set<API> searchAPI(String searchTerm) throws APIManagementException {
        HashSet<API> apiSet = new HashSet<API>();
        String regex = "(?i)[a-zA-Z0-9_.-|]*" + searchTerm + "(?i)[a-zA-Z0-9_.-|]*";
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact[] genericArtifacts = artifactManager.getAllGenericArtifacts();
            if (genericArtifacts == null || genericArtifacts.length == 0) {
                return apiSet;
            }
            for (GenericArtifact artifact : genericArtifacts) {
                String status = artifact.getAttribute("overview_status");
                String apiName = artifact.getAttribute("overview_name");
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(apiName);
                if (!matcher.matches() || !status.equals("PUBLISHED")) continue;
                apiSet.add(APIUtil.getAPI((GovernanceArtifact)artifact, this.registry));
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to Search APIs", (Exception)((Object)e));
        }
        return apiSet;
    }

    public Set<API> searchAPI(String searchTerm, String searchType) throws APIManagementException {
        HashSet<API> apiSet = new HashSet<API>();
        String regex = "[a-zA-Z0-9_.-|]*" + searchTerm + "[a-zA-Z0-9_.-|]*";
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
            GenericArtifact[] genericArtifacts = artifactManager.getAllGenericArtifacts();
            if (genericArtifacts == null || genericArtifacts.length == 0) {
                return apiSet;
            }
            for (GenericArtifact artifact : genericArtifacts) {
                Matcher matcher;
                String api;
                String status = artifact.getAttribute("overview_status");
                Pattern pattern = Pattern.compile(regex);
                if (searchType.equals("APIProvider")) {
                    api = artifact.getAttribute("overview_provider");
                    matcher = pattern.matcher(api);
                } else if (searchType.equals("APIVersion")) {
                    api = artifact.getAttribute("overview_version");
                    matcher = pattern.matcher(api);
                } else if (searchType.equals("APIContext")) {
                    api = artifact.getAttribute("overview_context");
                    matcher = pattern.matcher(api);
                } else {
                    String apiName = artifact.getAttribute("overview_name");
                    matcher = pattern.matcher(apiName);
                }
                if (!matcher.matches() || !status.equals("PUBLISHED")) continue;
                apiSet.add(APIUtil.getAPI((GovernanceArtifact)artifact, this.registry));
            }
        }
        catch (RegistryException e) {
            this.handleException("Failed to search APIs with type", (Exception)((Object)e));
        }
        return apiSet;
    }

    public Set<SubscribedAPI> getSubscribedAPIs(Subscriber subscriber) throws APIManagementException {
        Set<SubscribedAPI> subscribedAPIs = null;
        try {
            subscribedAPIs = this.apiMgtDAO.getSubscribedAPIs(subscriber);
        }
        catch (APIManagementException e) {
            this.handleException("Failed to get APIs of " + subscriber.getName(), (Exception)((Object)e));
        }
        return subscribedAPIs;
    }

    public Set<APIIdentifier> getAPIByConsumerKey(String accessToken) throws APIManagementException {
        try {
            return this.apiMgtDAO.getAPIByConsumerKey(accessToken);
        }
        catch (APIManagementException e) {
            this.handleException("Error while obtaining API from API key", (Exception)((Object)e));
            return null;
        }
    }

    public boolean isSubscribed(APIIdentifier apiIdentifier, String userId) throws APIManagementException {
        boolean isSubscribed;
        try {
            isSubscribed = this.apiMgtDAO.isSubscribed(apiIdentifier, userId);
        }
        catch (APIManagementException e) {
            String msg = "Failed to check if user(" + userId + ") has subscribed to " + apiIdentifier;
            this.log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return isSubscribed;
    }

    public void addSubscription(APIIdentifier identifier, String userId, int applicationId) throws APIManagementException {
        API api = this.getAPI(identifier);
        if (!api.getStatus().equals((Object)APIStatus.PUBLISHED)) {
            throw new APIManagementException("Subscriptions not allowed on APIs in the state: " + api.getStatus().getStatus());
        }
        this.apiMgtDAO.addSubscription(identifier, api.getContext(), applicationId);
    }

    public void removeSubscription(APIIdentifier identifier, String userId, int applicationId) throws APIManagementException {
        this.apiMgtDAO.removeSubscription(identifier, applicationId);
    }

    public void removeSubscriber(APIIdentifier identifier, String userId) throws APIManagementException {
        throw new UnsupportedOperationException("Unsubscribe operation is not yet implemented");
    }

    public void updateSubscriptions(APIIdentifier identifier, String userId, int applicationId) throws APIManagementException {
        API api = this.getAPI(identifier);
        this.apiMgtDAO.updateSubscriptions(identifier, api.getContext(), applicationId);
    }

    public void addComment(APIIdentifier identifier, String s, String user) throws APIManagementException {
        String apiPath = APIUtil.getAPIPath(identifier);
        org.wso2.carbon.registry.core.Comment comment = new org.wso2.carbon.registry.core.Comment(s);
        try {
            this.registry.addComment(apiPath, comment);
        }
        catch (RegistryException e) {
            this.handleException("Failed to add comment for api " + apiPath, (Exception)((Object)e));
        }
    }

    public Comment[] getComments(APIIdentifier identifier) throws APIManagementException {
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        String apiPath = APIUtil.getAPIPath(identifier);
        try {
            org.wso2.carbon.registry.core.Comment[] comments;
            for (org.wso2.carbon.registry.core.Comment comment : comments = this.registry.getComments(apiPath)) {
                Comment comment1 = new Comment();
                comment1.setText(comment.getText());
                comment1.setUser(comment.getUser());
                comment1.setCreatedTime(comment.getCreatedTime());
                commentList.add(comment1);
            }
            return commentList.toArray(new Comment[commentList.size()]);
        }
        catch (RegistryException e) {
            this.handleException("Failed to get comments for api " + apiPath, (Exception)((Object)e));
            return null;
        }
    }

    public void addApplication(Application application, String userId) throws APIManagementException {
        this.apiMgtDAO.addApplication(application, userId);
    }

    public void updateApplication(Application application) throws APIManagementException {
        this.apiMgtDAO.updateApplication(application);
    }

    public void removeApplication(Application application) throws APIManagementException {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        boolean gatewayExists = config.getFirstProperty("APIGateway.ServerURL") != null;
        Set<SubscribedAPI> apiSet = null;
        if (gatewayExists) {
            apiSet = this.getSubscribedAPIs(application.getSubscriber());
        }
        this.apiMgtDAO.deleteApplication(application);
        if (gatewayExists && apiSet != null && apiSet.size() > 0) {
            ArrayList<APIKeyMapping> mappings = new ArrayList<APIKeyMapping>();
            for (SubscribedAPI api : apiSet) {
                if (!api.getApplication().getName().equals(application.getName())) continue;
                List keys = api.getApplication().getKeys();
                for (APIKey key : keys) {
                    APIKeyMapping mapping = new APIKeyMapping();
                    API apiDefinition = this.getAPI(api.getApiId());
                    mapping.setApiVersion(api.getApiId().getVersion());
                    mapping.setContext(apiDefinition.getContext());
                    mapping.setKey(key.getKey());
                    mappings.add(mapping);
                }
            }
            if (mappings.size() > 0) {
                try {
                    APIAuthenticationAdminClient client = new APIAuthenticationAdminClient();
                    client.invalidateKeys(mappings);
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error while invalidating API keys at the gateway", (Exception)((Object)axisFault));
                }
            }
        }
    }

    public Application[] getApplications(Subscriber subscriber) throws APIManagementException {
        return this.apiMgtDAO.getApplications(subscriber);
    }

    public Set<SubscribedAPI> getSubscribedIdentifiers(Subscriber subscriber, APIIdentifier identifier) throws APIManagementException {
        HashSet<SubscribedAPI> subscribedAPISet = new HashSet<SubscribedAPI>();
        Set<SubscribedAPI> subscribedAPIs = this.getSubscribedAPIs(subscriber);
        for (SubscribedAPI api : subscribedAPIs) {
            if (!api.getApiId().equals((Object)identifier)) continue;
            subscribedAPISet.add(api);
        }
        return subscribedAPISet;
    }
}

