/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.wso2.carbon.apimgt.api.model.APIKey;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;

public class Application {
    private int id;
    private String name;
    private Subscriber subscriber;
    private Set<SubscribedAPI> subscribedAPIs = new LinkedHashSet<SubscribedAPI>();
    private List<APIKey> keys = new ArrayList<APIKey>();
    private String tier;

    public Application(String name, Subscriber subscriber) {
        this.name = name;
        this.subscriber = subscriber;
    }

    public String getName() {
        return this.name;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public Set<SubscribedAPI> getSubscribedAPIs() {
        return this.subscribedAPIs;
    }

    public void addSubscribedAPIs(Set<SubscribedAPI> subscribedAPIs) {
        for (SubscribedAPI subscribedAPI : subscribedAPIs) {
            subscribedAPI.setApplication(this);
        }
        this.subscribedAPIs.addAll(subscribedAPIs);
    }

    public void removeSubscribedAPIs(Set<SubscribedAPI> subscribedAPIs) {
        this.subscribedAPIs.removeAll(subscribedAPIs);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<APIKey> getKeys() {
        return this.keys;
    }

    public void addKey(APIKey key) {
        this.keys.add(key);
    }

    public String getTier() {
        return this.tier;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application that = (Application)o;
        return this.id == that.id && this.name.equals(that.name) && this.subscriber.equals(that.subscriber);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Integer.valueOf(this.id).hashCode();
        result = 31 * result + this.subscriber.hashCode();
        return result;
    }
}

