/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import org.wso2.carbon.apimgt.api.APIManagementException;

public class APIIdentifier {
    private final String providerName;
    private final String apiName;
    private final String version;
    private String tier;
    private String applicationId;

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTier() {
        return this.tier;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public APIIdentifier(String providerName, String apiName, String version) {
        this.providerName = providerName;
        this.apiName = apiName;
        this.version = version;
    }

    public APIIdentifier(String apiId) throws APIManagementException {
        String[] split = apiId.split("_");
        if (split.length != 3) {
            throw new APIManagementException("Invalid API ID : " + apiId);
        }
        this.providerName = split[0];
        this.apiName = split[1];
        this.version = split[2];
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIIdentifier that = (APIIdentifier)o;
        return this.apiName.equals(that.apiName) && this.providerName.equals(that.providerName) && this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.providerName.hashCode();
        result = 31 * result + this.apiName.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

