/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIKey;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;

public class SubscribedAPI {
    private Tier tier;
    private Subscriber subscriber;
    private APIIdentifier apiId;
    private Date lastAccessed;
    private Application application;
    private List<APIKey> keys = new ArrayList<APIKey>();
    private boolean isBlocked;

    public SubscribedAPI(Subscriber subscriber, APIIdentifier apiId) {
        this.subscriber = subscriber;
        this.apiId = apiId;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public APIIdentifier getApiId() {
        return this.apiId;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setTier(Tier tier) {
        this.tier = tier;
    }

    public List<APIKey> getKeys() {
        return this.keys;
    }

    public void addKey(APIKey key) {
        this.keys.add(key);
    }

    public Date getLastAccessed() {
        return new Date(this.lastAccessed.getTime());
    }

    public void setLastAccessed(Date lastAccessed) {
        if (lastAccessed != null) {
            this.lastAccessed = new Date(lastAccessed.getTime());
        }
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedAPI that = (SubscribedAPI)o;
        return this.apiId.equals(that.apiId) && this.application.equals(that.application) && this.subscriber.equals(that.subscriber);
    }

    public int hashCode() {
        int result = this.subscriber.hashCode();
        result = 31 * result + this.apiId.hashCode();
        result = 31 * result + this.application.hashCode();
        return result;
    }
}

