/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.virtualhost.plugins;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.server.configuration.plugins.ConfigurationPlugin;
import org.wso2.andes.server.configuration.plugins.SlowConsumerDetectionConfiguration;
import org.wso2.andes.server.configuration.plugins.SlowConsumerDetectionQueueConfiguration;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.server.virtualhost.plugins.ConfiguredQueueBindingListener;
import org.wso2.andes.server.virtualhost.plugins.VirtualHostHouseKeepingPlugin;
import org.wso2.andes.server.virtualhost.plugins.VirtualHostPluginFactory;
import org.wso2.andes.server.virtualhost.plugins.logging.SlowConsumerDetectionMessages;

public class SlowConsumerDetection
extends VirtualHostHouseKeepingPlugin {
    private SlowConsumerDetectionConfiguration _config;
    private ConfiguredQueueBindingListener _listener;

    public void configure(ConfigurationPlugin config) {
        this._config = (SlowConsumerDetectionConfiguration)config;
        this._listener = new ConfiguredQueueBindingListener(this.getVirtualHost().getName());
        for (AMQShortString exchangeName : this.getVirtualHost().getExchangeRegistry().getExchangeNames()) {
            this.getVirtualHost().getExchangeRegistry().getExchange(exchangeName).addBindingListener(this._listener);
        }
    }

    public SlowConsumerDetection(VirtualHost vhost) {
        super(vhost);
    }

    public void execute() {
        CurrentActor.get().message(SlowConsumerDetectionMessages.RUNNING());
        Set<AMQQueue> cache = this._listener.getQueueCache();
        for (AMQQueue q : cache) {
            CurrentActor.get().message(SlowConsumerDetectionMessages.CHECKING_QUEUE(q.getName()));
            try {
                SlowConsumerDetectionQueueConfiguration config = (SlowConsumerDetectionQueueConfiguration)q.getConfiguration().getConfiguration(SlowConsumerDetectionQueueConfiguration.class.getName());
                if (!this.checkQueueStatus(q, config)) continue;
                config.getPolicy().performPolicy(q);
            }
            catch (Exception e) {
                this._logger.error((Object)("Exception in SlowConsumersDetection for queue: " + q.getName()), (Throwable)e);
            }
        }
        CurrentActor.get().message(SlowConsumerDetectionMessages.COMPLETE());
    }

    public long getDelay() {
        return this._config.getDelay();
    }

    public TimeUnit getTimeUnit() {
        return this._config.getTimeUnit();
    }

    private boolean checkQueueStatus(AMQQueue q, SlowConsumerDetectionQueueConfiguration config) {
        if (config != null) {
            this._logger.info((Object)("Retrieved Queue(" + q.getName() + ") Config:" + config));
            int count = q.getMessageCount();
            if (config.getMessageCount() != 0L && (long)count >= config.getMessageCount() || config.getDepth() != 0L && q.getQueueDepth() >= config.getDepth() || config.getMessageAge() != 0L && count > 0 && q.getOldestMessageArrivalTime() >= config.getMessageAge()) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("Detected Slow Consumer on Queue(" + q.getName() + ")"));
                    this._logger.debug((Object)("Queue Count:" + q.getMessageCount() + ":" + config.getMessageCount()));
                    this._logger.debug((Object)("Queue Depth:" + q.getQueueDepth() + ":" + config.getDepth()));
                    this._logger.debug((Object)("Queue Arrival:" + q.getOldestMessageArrivalTime() + ":" + config.getMessageAge()));
                }
                return true;
            }
        }
        return false;
    }

    public static class SlowConsumerFactory
    implements VirtualHostPluginFactory {
        public SlowConsumerDetection newInstance(VirtualHost vhost) {
            SlowConsumerDetectionConfiguration config = (SlowConsumerDetectionConfiguration)vhost.getConfiguration().getConfiguration(SlowConsumerDetectionConfiguration.class.getName());
            if (config == null) {
                return null;
            }
            SlowConsumerDetection plugin = new SlowConsumerDetection(vhost);
            plugin.configure(config);
            return plugin;
        }
    }
}

