/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.store;

import java.nio.ByteBuffer;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.store.TransactionLog;

public class StoredMemoryMessage
implements StoredMessage {
    private final long _messageNumber;
    private final ByteBuffer _content;
    private final StorableMessageMetaData _metaData;

    public StoredMemoryMessage(long messageNumber, StorableMessageMetaData metaData) {
        this._messageNumber = messageNumber;
        this._metaData = metaData;
        this._content = ByteBuffer.allocate(metaData.getContentSize());
    }

    public long getMessageNumber() {
        return this._messageNumber;
    }

    public void addContent(int offsetInMessage, ByteBuffer src) {
        src = src.duplicate();
        ByteBuffer dst = this._content.duplicate();
        dst.position(offsetInMessage);
        dst.put(src);
    }

    public int getContent(int offset, ByteBuffer dst) {
        ByteBuffer src = this._content.duplicate();
        src.position(offset);
        src = src.slice();
        if (dst.remaining() < src.limit()) {
            src.limit(dst.remaining());
        }
        dst.put(src);
        return src.limit();
    }

    public TransactionLog.StoreFuture flushToStore() {
        return MessageStore.IMMEDIATE_FUTURE;
    }

    public StorableMessageMetaData getMetaData() {
        return this._metaData;
    }

    public void remove() {
    }
}

