/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQSecurityException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.pool.ReadWriteRunnable;
import org.wso2.andes.pool.ReferenceCountingExecutorService;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.cassandra.ClusteringEnabledSubscriptionManager;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.QueueConfigType;
import org.wso2.andes.server.configuration.QueueConfiguration;
import org.wso2.andes.server.configuration.SessionConfig;
import org.wso2.andes.server.configuration.plugins.ConfigurationPlugin;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.logging.LogActor;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.actors.QueueActor;
import org.wso2.andes.server.logging.messages.QueueMessages;
import org.wso2.andes.server.logging.subjects.QueueLogSubject;
import org.wso2.andes.server.management.ManagedObject;
import org.wso2.andes.server.message.EnqueableMessage;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.AMQQueueMBean;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.InboundMessageAdapter;
import org.wso2.andes.server.queue.NotificationCheck;
import org.wso2.andes.server.queue.PriorityQueueList;
import org.wso2.andes.server.queue.QueueContext;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.QueueEntryIterator;
import org.wso2.andes.server.queue.QueueEntryList;
import org.wso2.andes.server.queue.QueueEntryListFactory;
import org.wso2.andes.server.queue.QueueRunner;
import org.wso2.andes.server.queue.SimpleQueueEntryList;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.security.AuthorizationHolder;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionList;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.LocalTransaction;
import org.wso2.andes.server.txn.ServerTransaction;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAMQQueue
implements AMQQueue,
Subscription.StateListener {
    private static final Logger _logger = Logger.getLogger(SimpleAMQQueue.class);
    private final VirtualHost _virtualHost;
    private final AMQShortString _name;
    private final String _resourceName;
    private final AMQShortString _owner;
    private AuthorizationHolder _authorizationHolder;
    private boolean _exclusive = false;
    private AMQSessionModel _exclusiveOwner;
    private final boolean _durable;
    private final boolean _autoDelete;
    private Exchange _alternateExchange;
    protected final QueueEntryList _entries;
    protected final SubscriptionList _subscriptionList = new SubscriptionList(this);
    private final AtomicReference<SubscriptionList.SubscriptionNode> _lastSubscriptionNode = new AtomicReference<SubscriptionList.SubscriptionNode>(this._subscriptionList.getHead());
    private volatile Subscription _exclusiveSubscriber;
    private final AtomicInteger _atomicQueueCount = new AtomicInteger(0);
    private final AtomicLong _atomicQueueSize = new AtomicLong(0L);
    private final AtomicInteger _activeSubscriberCount = new AtomicInteger();
    private final AtomicLong _totalMessagesReceived = new AtomicLong();
    private final AtomicLong _dequeueCount = new AtomicLong();
    private final AtomicLong _dequeueSize = new AtomicLong();
    private final AtomicLong _enqueueSize = new AtomicLong();
    private final AtomicLong _persistentMessageEnqueueSize = new AtomicLong();
    private final AtomicLong _persistentMessageDequeueSize = new AtomicLong();
    private final AtomicLong _persistentMessageEnqueueCount = new AtomicLong();
    private final AtomicLong _persistentMessageDequeueCount = new AtomicLong();
    private final AtomicInteger _counsumerCountHigh = new AtomicInteger(0);
    private final AtomicLong _msgTxnEnqueues = new AtomicLong(0L);
    private final AtomicLong _byteTxnEnqueues = new AtomicLong(0L);
    private final AtomicLong _msgTxnDequeues = new AtomicLong(0L);
    private final AtomicLong _byteTxnDequeues = new AtomicLong(0L);
    private final AtomicLong _unackedMsgCount = new AtomicLong(0L);
    private final AtomicLong _unackedMsgCountHigh = new AtomicLong(0L);
    private final AtomicInteger _bindingCountHigh = new AtomicInteger();
    public long _maximumMessageSize = ApplicationRegistry.getInstance().getConfiguration().getMaximumMessageSize();
    public long _maximumMessageCount = ApplicationRegistry.getInstance().getConfiguration().getMaximumMessageCount();
    public long _maximumQueueDepth = ApplicationRegistry.getInstance().getConfiguration().getMaximumQueueDepth();
    public long _maximumMessageAge = ApplicationRegistry.getInstance().getConfiguration().getMaximumMessageAge();
    public long _minimumAlertRepeatGap = ApplicationRegistry.getInstance().getConfiguration().getMinimumAlertRepeatGap();
    private long _capacity = ApplicationRegistry.getInstance().getConfiguration().getCapacity();
    private long _flowResumeCapacity = ApplicationRegistry.getInstance().getConfiguration().getFlowResumeCapacity();
    private final Set<NotificationCheck> _notificationChecks = EnumSet.noneOf(NotificationCheck.class);
    static final int MAX_ASYNC_DELIVERIES = 10;
    private final AtomicLong _stateChangeCount = new AtomicLong(Long.MIN_VALUE);
    private AtomicReference<Runnable> _asynchronousRunner = new AtomicReference<Object>(null);
    private final Executor _asyncDelivery;
    private AtomicInteger _deliveredMessages = new AtomicInteger();
    private AtomicBoolean _stopped = new AtomicBoolean(false);
    private final ConcurrentMap<AMQChannel, Boolean> _blockedChannels = new ConcurrentHashMap<AMQChannel, Boolean>();
    private final AtomicBoolean _deleted = new AtomicBoolean(false);
    private final List<AMQQueue.Task> _deleteTaskList = new CopyOnWriteArrayList<AMQQueue.Task>();
    private LogSubject _logSubject;
    private LogActor _logActor;
    private AMQQueueMBean _managedObject;
    private static final String SUB_FLUSH_RUNNER = "SUB_FLUSH_RUNNER";
    private boolean _nolocal;
    private final AtomicBoolean _overfull = new AtomicBoolean(false);
    private boolean _deleteOnNoConsumers;
    private final CopyOnWriteArrayList<Binding> _bindings = new CopyOnWriteArrayList();
    private UUID _id;
    private final Map<String, Object> _arguments;
    private long _createTime = System.currentTimeMillis();
    private ConfigurationPlugin _queueConfiguration;

    protected SimpleAMQQueue(AMQShortString name, boolean durable, AMQShortString owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, Map<String, Object> arguments) {
        this(name, durable, owner, autoDelete, exclusive, virtualHost, (QueueEntryListFactory)new SimpleQueueEntryList.Factory(), arguments);
    }

    public SimpleAMQQueue(String queueName, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, Map<String, Object> arguments) {
        this(queueName, durable, owner, autoDelete, exclusive, virtualHost, (QueueEntryListFactory)new SimpleQueueEntryList.Factory(), arguments);
    }

    public SimpleAMQQueue(String queueName, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, QueueEntryListFactory entryListFactory, Map<String, Object> arguments) {
        this(queueName == null ? null : new AMQShortString(queueName), durable, owner == null ? null : new AMQShortString(owner), autoDelete, exclusive, virtualHost, entryListFactory, arguments);
    }

    protected SimpleAMQQueue(AMQShortString name, boolean durable, AMQShortString owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, QueueEntryListFactory entryListFactory, Map<String, Object> arguments) {
        if (name == null) {
            throw new IllegalArgumentException("Queue name must not be null");
        }
        if (virtualHost == null) {
            throw new IllegalArgumentException("Virtual Host must not be null");
        }
        this._name = name;
        this._resourceName = String.valueOf(name);
        this._durable = durable;
        this._owner = owner;
        this._autoDelete = autoDelete;
        this._exclusive = exclusive;
        this._virtualHost = virtualHost;
        this._entries = entryListFactory.createQueueEntryList(this);
        this._arguments = arguments;
        this._id = virtualHost.getConfigStore().createId();
        this._asyncDelivery = ReferenceCountingExecutorService.getInstance().acquireExecutorService();
        this._logSubject = new QueueLogSubject(this);
        this._logActor = new QueueActor(this, CurrentActor.get().getRootMessageLogger());
        int priorities = 0;
        if (entryListFactory instanceof PriorityQueueList.Factory) {
            priorities = ((PriorityQueueList)this._entries).getPriorities();
        }
        CurrentActor.get().message(this._logSubject, QueueMessages.CREATED(String.valueOf(this._owner), priorities, this._owner != null, autoDelete, durable, !durable, priorities > 0));
        this.getConfigStore().addConfiguredObject(this);
        try {
            this._managedObject = new AMQQueueMBean(this);
            this._managedObject.register();
        }
        catch (JMException e) {
            _logger.error((Object)"AMQQueue MBean creation has failed ", (Throwable)e);
        }
        this.resetNotifications();
    }

    public void resetNotifications() {
        this.setMaximumMessageAge(this._maximumMessageAge);
        this.setMaximumMessageCount(this._maximumMessageCount);
        this.setMaximumMessageSize(this._maximumMessageSize);
        this.setMaximumQueueDepth(this._maximumQueueDepth);
    }

    public void execute(ReadWriteRunnable runnable) {
        this._asyncDelivery.execute(runnable);
    }

    @Override
    public AMQShortString getNameShortString() {
        return this._name;
    }

    @Override
    public void setNoLocal(boolean nolocal) {
        this._nolocal = nolocal;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public QueueConfigType getConfigType() {
        return QueueConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    @Override
    public boolean isDurable() {
        return this._durable;
    }

    @Override
    public boolean isExclusive() {
        return this._exclusive;
    }

    @Override
    public void setExclusive(boolean exclusive) throws AMQException {
        this._exclusive = exclusive;
        if (this.isDurable()) {
            this.getVirtualHost().getDurableConfigurationStore().updateQueue(this);
        }
    }

    @Override
    public Exchange getAlternateExchange() {
        return this._alternateExchange;
    }

    @Override
    public void setAlternateExchange(Exchange exchange) {
        if (this._alternateExchange != null) {
            this._alternateExchange.removeReference(this);
        }
        if (exchange != null) {
            exchange.addReference(this);
        }
        this._alternateExchange = exchange;
    }

    @Override
    public Map<String, Object> getArguments() {
        return this._arguments;
    }

    @Override
    public boolean isAutoDelete() {
        return this._autoDelete;
    }

    @Override
    public AMQShortString getOwner() {
        return this._owner;
    }

    @Override
    public AuthorizationHolder getAuthorizationHolder() {
        return this._authorizationHolder;
    }

    @Override
    public void setAuthorizationHolder(AuthorizationHolder authorizationHolder) {
        this._authorizationHolder = authorizationHolder;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public String getName() {
        return this.getNameShortString().toString();
    }

    @Override
    public synchronized void registerSubscription(Subscription subscription, boolean exclusive) throws AMQSecurityException, AMQQueue.ExistingExclusiveSubscription, AMQQueue.ExistingSubscriptionPreventsExclusive {
        if (!this.getVirtualHost().getSecurityManager().authoriseConsume(this)) {
            throw new AMQSecurityException("Permission denied");
        }
        if (this.hasExclusiveSubscriber()) {
            throw new AMQQueue.ExistingExclusiveSubscription();
        }
        if (exclusive && !subscription.isTransient()) {
            if (this.getConsumerCount() != 0) {
                throw new AMQQueue.ExistingSubscriptionPreventsExclusive();
            }
            this._exclusiveSubscriber = subscription;
        }
        this._activeSubscriberCount.incrementAndGet();
        subscription.setStateListener(this);
        subscription.setQueueContext(new QueueContext(this._entries.getHead()));
        if (!this.isDeleted()) {
            subscription.setQueue(this, exclusive);
            if (this._nolocal) {
                subscription.setNoLocal(this._nolocal);
            }
            this._subscriptionList.add(subscription);
            if (this._counsumerCountHigh.get() < this.getConsumerCount()) {
                this._counsumerCountHigh.incrementAndGet();
            }
            if (this.isDeleted()) {
                subscription.queueDeleted(this);
            }
        }
        this.deliverAsync(subscription);
    }

    @Override
    public synchronized void unregisterSubscription(Subscription subscription) throws AMQException {
        if (subscription == null) {
            throw new NullPointerException("subscription argument is null");
        }
        boolean removed = this._subscriptionList.remove(subscription);
        if (removed) {
            subscription.close();
            this.setExclusiveSubscriber(null);
            subscription.setQueueContext(null);
            if (this._autoDelete && this.getDeleteOnNoConsumers() && !subscription.isTransient() && this.getConsumerCount() == 0) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Auto-deleteing queue:" + this));
                }
                this.delete();
                subscription.queueDeleted(this);
            }
        }
    }

    @Override
    public boolean getDeleteOnNoConsumers() {
        return this._deleteOnNoConsumers;
    }

    @Override
    public void setDeleteOnNoConsumers(boolean b) {
        this._deleteOnNoConsumers = b;
    }

    @Override
    public void addBinding(Binding binding) {
        int bindingCountHigh;
        this._bindings.add(binding);
        int bindingCount = this._bindings.size();
        while (bindingCount > (bindingCountHigh = this._bindingCountHigh.get()) && !this._bindingCountHigh.compareAndSet(bindingCountHigh, bindingCount)) {
        }
        this.reconfigure();
    }

    private void reconfigure() {
        ConfigurationPlugin config = this.getVirtualHost().getConfiguration().getQueueConfiguration(this);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Reconfiguring queue(" + this + ") with config:" + config + " was " + this._queueConfiguration));
        }
        if (config != null) {
            this.configure(config);
        }
    }

    @Override
    public int getBindingCountHigh() {
        return this._bindingCountHigh.get();
    }

    @Override
    public void removeBinding(Binding binding) {
        this._bindings.remove(binding);
        this.reconfigure();
    }

    @Override
    public List<Binding> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public int getBindingCount() {
        return this.getBindings().size();
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    @Override
    public void enqueue(ServerMessage message) throws AMQException {
        this.enqueue(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(ServerMessage message, BaseQueue.PostEnqueueAction action) throws AMQException {
        QueueEntry entry;
        this.incrementTxnEnqueueStats(message);
        this.incrementQueueCount();
        this.incrementQueueSize(message);
        this._totalMessagesReceived.incrementAndGet();
        Subscription exclusiveSub = this._exclusiveSubscriber;
        if (exclusiveSub != null) {
            exclusiveSub.getSendLock();
            try {
                entry = this._entries.add(message);
                for (Binding binding : this._virtualHost.getExchangeRegistry().getExchange("amq.topic").getBindings()) {
                    if (!binding.getQueue().getName().equalsIgnoreCase(entry.getQueue().getName())) continue;
                    this.deliverToSubscription(exclusiveSub, entry);
                }
            }
            finally {
                exclusiveSub.releaseSendLock();
            }
        } else {
            entry = this._entries.add(message);
            SubscriptionList.SubscriptionNode node = this._lastSubscriptionNode.get();
            SubscriptionList.SubscriptionNode nextNode = node.getNext();
            if (nextNode == null) {
                nextNode = this._subscriptionList.getHead().getNext();
            }
            while (nextNode != null && !this._lastSubscriptionNode.compareAndSet(node, nextNode)) {
                node = this._lastSubscriptionNode.get();
                nextNode = node.getNext();
                if (nextNode != null) continue;
                nextNode = this._subscriptionList.getHead().getNext();
            }
            int loops = 2;
            while (entry.isAvailable() && loops != 0) {
                if (nextNode == null) {
                    --loops;
                    nextNode = this._subscriptionList.getHead();
                }
                nextNode = nextNode.getNext();
            }
        }
        if (entry.isAvailable()) {
            this.checkSubscriptionsNotAheadOfDelivery(entry);
            this.deliverAsync();
        }
        if (this._managedObject != null) {
            this._managedObject.checkForNotification(entry.getMessage());
        }
        if (action != null) {
            action.onEnqueue(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverToSubscription(Subscription sub, QueueEntry entry) throws AMQException {
        sub.getSendLock();
        try {
            if (this.subscriptionReadyAndHasInterest(sub, entry) && !sub.isSuspended() && !sub.wouldSuspend(entry)) {
                if (sub.acquires() && !entry.acquire(sub)) {
                    sub.onDequeue(entry);
                } else {
                    this.deliverMessage(sub, entry);
                }
            }
        }
        finally {
            sub.releaseSendLock();
        }
    }

    protected void checkSubscriptionsNotAheadOfDelivery(QueueEntry entry) {
    }

    private void incrementQueueSize(ServerMessage message) {
        long size = message.getSize();
        this.getAtomicQueueSize().addAndGet(size);
        this._enqueueSize.addAndGet(size);
        if (message.isPersistent() && this.isDurable()) {
            this._persistentMessageEnqueueSize.addAndGet(size);
            this._persistentMessageEnqueueCount.incrementAndGet();
        }
    }

    private void incrementQueueCount() {
        this.getAtomicQueueCount().incrementAndGet();
    }

    private void incrementTxnEnqueueStats(ServerMessage message) {
        SessionConfig session = message.getSessionConfig();
        if (session != null && session.isTransactional()) {
            this._msgTxnEnqueues.incrementAndGet();
            this._byteTxnEnqueues.addAndGet(message.getSize());
        }
    }

    private void incrementTxnDequeueStats(QueueEntry entry) {
        this._msgTxnDequeues.incrementAndGet();
        this._byteTxnDequeues.addAndGet(entry.getSize());
    }

    private void deliverMessage(Subscription sub, QueueEntry entry) throws AMQException {
        this.setLastSeenEntry(sub, entry);
        this._deliveredMessages.incrementAndGet();
        this.incrementUnackedMsgCount();
        sub.send(entry);
    }

    private boolean subscriptionReadyAndHasInterest(Subscription sub, QueueEntry entry) throws AMQException {
        return sub.hasInterest(entry) && this.getNextAvailableEntry(sub) == entry;
    }

    private void setLastSeenEntry(Subscription sub, QueueEntry entry) {
        QueueContext subContext = (QueueContext)sub.getQueueContext();
        QueueEntry releasedEntry = subContext._releasedEntry;
        QueueContext._lastSeenUpdater.set(subContext, entry);
        if (releasedEntry == entry) {
            QueueContext._releasedUpdater.compareAndSet(subContext, releasedEntry, null);
        }
    }

    private void updateSubRequeueEntry(Subscription sub, QueueEntry entry) {
        block1: {
            QueueEntry oldEntry;
            QueueContext subContext = (QueueContext)sub.getQueueContext();
            if (subContext == null) break block1;
            while (!((oldEntry = subContext._releasedEntry) != null && oldEntry.compareTo(entry) <= 0 || QueueContext._releasedUpdater.compareAndSet(subContext, oldEntry, entry))) {
            }
        }
    }

    @Override
    public void requeue(QueueEntry entry) {
        SubscriptionList.SubscriptionNodeIterator subscriberIter = this._subscriptionList.iterator();
        while (subscriberIter.advance() && entry.isAvailable()) {
            Subscription sub = subscriberIter.getNode().getSubscription();
            if (!sub.seesRequeues()) continue;
            this.updateSubRequeueEntry(sub, entry);
        }
        this.deliverAsync();
    }

    @Override
    public void dequeue(QueueEntry entry, Subscription sub) {
        this.decrementQueueCount();
        this.decrementQueueSize(entry);
        if (entry.acquiredBySubscription()) {
            this._deliveredMessages.decrementAndGet();
        }
        if (sub != null && sub.isSessionTransactional()) {
            this.incrementTxnDequeueStats(entry);
        }
        this.checkCapacity();
    }

    private void decrementQueueSize(QueueEntry entry) {
        ServerMessage message = entry.getMessage();
        long size = message.getSize();
        this.getAtomicQueueSize().addAndGet(-size);
        this._dequeueSize.addAndGet(size);
        if (message.isPersistent() && this.isDurable()) {
            this._persistentMessageDequeueSize.addAndGet(size);
            this._persistentMessageDequeueCount.incrementAndGet();
        }
    }

    void decrementQueueCount() {
        this.getAtomicQueueCount().decrementAndGet();
        this._dequeueCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resend(QueueEntry entry, Subscription subscription) throws AMQException {
        subscription.getSendLock();
        try {
            if (!subscription.isClosed()) {
                this.deliverMessage(subscription, entry);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            subscription.releaseSendLock();
        }
    }

    @Override
    public int getConsumerCount() {
        return this._subscriptionList.size();
    }

    @Override
    public int getConsumerCountHigh() {
        return this._counsumerCountHigh.get();
    }

    @Override
    public int getActiveConsumerCount() {
        return this._activeSubscriberCount.get();
    }

    @Override
    public boolean isUnused() {
        return this.getConsumerCount() == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getMessageCount() == 0;
    }

    @Override
    public int getMessageCount() {
        return this.getAtomicQueueCount().get();
    }

    @Override
    public long getQueueDepth() {
        return this.getAtomicQueueSize().get();
    }

    @Override
    public int getUndeliveredMessageCount() {
        int count = this.getMessageCount() - this._deliveredMessages.get();
        if (count < 0) {
            return 0;
        }
        return count;
    }

    @Override
    public long getReceivedMessageCount() {
        return this._totalMessagesReceived.get();
    }

    @Override
    public long getOldestMessageArrivalTime() {
        QueueEntry entry = this.getOldestQueueEntry();
        return entry == null ? Long.MAX_VALUE : entry.getMessage().getArrivalTime();
    }

    protected QueueEntry getOldestQueueEntry() {
        return this._entries.next(this._entries.getHead());
    }

    @Override
    public boolean isDeleted() {
        return this._deleted.get();
    }

    @Override
    public List<QueueEntry> getMessagesOnTheQueue() {
        ArrayList<QueueEntry> entryList = new ArrayList<QueueEntry>();
        QueueEntryIterator queueListIterator = this._entries.iterator();
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (node == null || node.isDispensed()) continue;
            entryList.add(node);
        }
        return entryList;
    }

    @Override
    public void stateChange(Subscription sub, Subscription.State oldState, Subscription.State newState) {
        if (oldState == Subscription.State.ACTIVE && newState != Subscription.State.ACTIVE) {
            this._activeSubscriberCount.decrementAndGet();
            if (newState == Subscription.State.CLOSED) {
                ClusteringEnabledSubscriptionManager csm = ClusterResourceHolder.getInstance().getSubscriptionManager();
                csm.removeSubscription(this.getResourceName(), sub.getSubscriptionID() + "");
            }
        } else if (newState == Subscription.State.ACTIVE) {
            if (oldState != Subscription.State.ACTIVE) {
                this._activeSubscriberCount.incrementAndGet();
            }
            this.deliverAsync(sub);
        }
    }

    @Override
    public int compareTo(AMQQueue o) {
        return this._name.compareTo(o.getNameShortString());
    }

    public AtomicInteger getAtomicQueueCount() {
        return this._atomicQueueCount;
    }

    public AtomicLong getAtomicQueueSize() {
        return this._atomicQueueSize;
    }

    @Override
    public boolean hasExclusiveSubscriber() {
        return this._exclusiveSubscriber != null;
    }

    private void setExclusiveSubscriber(Subscription exclusiveSubscriber) {
        this._exclusiveSubscriber = exclusiveSubscriber;
    }

    @Override
    public List<QueueEntry> getMessagesOnTheQueue(final long fromMessageId, final long toMessageId) {
        return this.getMessagesOnTheQueue(new QueueEntryFilter(){

            public boolean accept(QueueEntry entry) {
                long messageId = entry.getMessage().getMessageNumber();
                return messageId >= fromMessageId && messageId <= toMessageId;
            }

            public boolean filterComplete() {
                return false;
            }
        });
    }

    @Override
    public QueueEntry getMessageOnTheQueue(final long messageId) {
        List<QueueEntry> entries = this.getMessagesOnTheQueue(new QueueEntryFilter(){
            private boolean _complete;

            public boolean accept(QueueEntry entry) {
                this._complete = entry.getMessage().getMessageNumber() == messageId;
                return this._complete;
            }

            public boolean filterComplete() {
                return this._complete;
            }
        });
        return entries.isEmpty() ? null : entries.get(0);
    }

    public List<QueueEntry> getMessagesOnTheQueue(QueueEntryFilter filter) {
        ArrayList<QueueEntry> entryList = new ArrayList<QueueEntry>();
        QueueEntryIterator queueListIterator = this._entries.iterator();
        while (queueListIterator.advance() && !filter.filterComplete()) {
            QueueEntry node = queueListIterator.getNode();
            if (node.isDispensed() || !filter.accept(node)) continue;
            entryList.add(node);
        }
        return entryList;
    }

    @Override
    public List<QueueEntry> getMessagesRangeOnTheQueue(final long fromPosition, final long toPosition) {
        return this.getMessagesOnTheQueue(new QueueEntryFilter(){
            private long position = 0L;

            public boolean accept(QueueEntry entry) {
                ++this.position;
                return this.position >= fromPosition && this.position <= toPosition;
            }

            public boolean filterComplete() {
                return this.position >= toPosition;
            }
        });
    }

    @Override
    public void moveMessagesToAnotherQueue(final long fromMessageId, final long toMessageId, String queueName, ServerTransaction txn) throws IllegalArgumentException {
        final AMQQueue toQueue = this.getVirtualHost().getQueueRegistry().getQueue(new AMQShortString(queueName));
        if (toQueue == null) {
            throw new IllegalArgumentException("Queue '" + queueName + "' is not registered with the virtualhost.");
        }
        if (toQueue == this) {
            throw new IllegalArgumentException("The destination queue cant be the same as the source queue");
        }
        List<QueueEntry> entries = this.getMessagesOnTheQueue(new QueueEntryFilter(){

            public boolean accept(QueueEntry entry) {
                long messageId = entry.getMessage().getMessageNumber();
                return messageId >= fromMessageId && messageId <= toMessageId && entry.acquire();
            }

            public boolean filterComplete() {
                return false;
            }
        });
        for (final QueueEntry entry : entries) {
            final ServerMessage message = entry.getMessage();
            txn.enqueue(toQueue, (EnqueableMessage)message, new ServerTransaction.Action(){

                public void postCommit() {
                    try {
                        toQueue.enqueue(message);
                    }
                    catch (AMQException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onRollback() {
                    entry.release();
                }
            });
            txn.dequeue(this, message, new ServerTransaction.Action(){

                public void postCommit() {
                    entry.discard();
                }

                public void onRollback() {
                }
            });
        }
    }

    @Override
    public void copyMessagesToAnotherQueue(final long fromMessageId, final long toMessageId, String queueName, ServerTransaction txn) throws IllegalArgumentException {
        final AMQQueue toQueue = this.getVirtualHost().getQueueRegistry().getQueue(new AMQShortString(queueName));
        if (toQueue == null) {
            throw new IllegalArgumentException("Queue '" + queueName + "' is not registered with the virtualhost.");
        }
        if (toQueue == this) {
            throw new IllegalArgumentException("The destination queue cant be the same as the source queue");
        }
        List<QueueEntry> entries = this.getMessagesOnTheQueue(new QueueEntryFilter(){

            public boolean accept(QueueEntry entry) {
                long messageId = entry.getMessage().getMessageNumber();
                return messageId >= fromMessageId && messageId <= toMessageId;
            }

            public boolean filterComplete() {
                return false;
            }
        });
        for (QueueEntry entry : entries) {
            final ServerMessage message = entry.getMessage();
            txn.enqueue(toQueue, (EnqueableMessage)message, new ServerTransaction.Action(){

                public void postCommit() {
                    try {
                        toQueue.enqueue(message);
                    }
                    catch (AMQException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onRollback() {
                }
            });
        }
    }

    @Override
    public void removeMessagesFromQueue(long fromMessageId, long toMessageId) {
        QueueEntryIterator queueListIterator = this._entries.iterator();
        while (queueListIterator.advance()) {
            long messageId;
            QueueEntry node = queueListIterator.getNode();
            ServerMessage message = node.getMessage();
            if (message == null || (messageId = message.getMessageNumber().longValue()) < fromMessageId || messageId > toMessageId || !node.acquire()) continue;
            this.dequeueEntry(node);
        }
    }

    @Override
    public void purge(long request) throws AMQException {
        this.clear(request);
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void deleteMessageFromTop() {
        QueueEntryIterator queueListIterator = this._entries.iterator();
        boolean noDeletes = true;
        while (noDeletes && queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (!node.acquire()) continue;
            this.dequeueEntry(node);
            noDeletes = false;
        }
    }

    @Override
    public long clearQueue() throws AMQException {
        return this.clear(0L);
    }

    private long clear(long request) throws AMQSecurityException {
        if (!this.getVirtualHost().getSecurityManager().authorisePurge(this)) {
            throw new AMQSecurityException("Permission denied: queue " + this.getName());
        }
        QueueEntryIterator queueListIterator = this._entries.iterator();
        long count = 0L;
        LocalTransaction txn = new LocalTransaction(this.getVirtualHost().getTransactionLog());
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (!node.acquire()) continue;
            this.dequeueEntry(node, txn);
            if (++count != request) continue;
            break;
        }
        txn.commit();
        return count;
    }

    private void dequeueEntry(QueueEntry node) {
        AutoCommitTransaction txn = new AutoCommitTransaction(this.getVirtualHost().getTransactionLog());
        this.dequeueEntry(node, txn);
    }

    private void dequeueEntry(final QueueEntry node, ServerTransaction txn) {
        txn.dequeue(this, node.getMessage(), new ServerTransaction.Action(){

            public void postCommit() {
                node.discard();
            }

            public void onRollback() {
            }
        });
    }

    @Override
    public void addQueueDeleteTask(AMQQueue.Task task) {
        this._deleteTaskList.add(task);
    }

    @Override
    public void removeQueueDeleteTask(AMQQueue.Task task) {
        this._deleteTaskList.remove(task);
    }

    @Override
    public int delete() throws AMQSecurityException, AMQException {
        if (!this._virtualHost.getSecurityManager().authoriseDelete(this)) {
            throw new AMQSecurityException("Permission denied: " + this.getName());
        }
        if (!this._deleted.getAndSet(true)) {
            for (Binding b : this.getBindings()) {
                this._virtualHost.getBindingFactory().removeBinding(b);
            }
            SubscriptionList.SubscriptionNodeIterator subscriptionIter = this._subscriptionList.iterator();
            while (subscriptionIter.advance()) {
                Subscription s = subscriptionIter.getNode().getSubscription();
                if (s == null) continue;
                s.queueDeleted(this);
            }
            this._virtualHost.getQueueRegistry().unregisterQueue(this._name);
            this.getConfigStore().removeConfiguredObject(this);
            List<QueueEntry> entries = this.getMessagesOnTheQueue(new QueueEntryFilter(){

                public boolean accept(QueueEntry entry) {
                    return entry.acquire();
                }

                public boolean filterComplete() {
                    return false;
                }
            });
            LocalTransaction txn = new LocalTransaction(this.getVirtualHost().getTransactionLog());
            if (this._alternateExchange != null) {
                InboundMessageAdapter adapter = new InboundMessageAdapter();
                for (final QueueEntry entry : entries) {
                    adapter.setEntry(entry);
                    final ArrayList<? extends BaseQueue> rerouteQueues = this._alternateExchange.route(adapter);
                    final ServerMessage message = entry.getMessage();
                    if (rerouteQueues == null || rerouteQueues.size() == 0) continue;
                    txn.enqueue(rerouteQueues, (EnqueableMessage)entry.getMessage(), new ServerTransaction.Action(){

                        public void postCommit() {
                            try {
                                for (BaseQueue queue : rerouteQueues) {
                                    queue.enqueue(message);
                                }
                            }
                            catch (AMQException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void onRollback() {
                        }
                    });
                    txn.dequeue(this, entry.getMessage(), new ServerTransaction.Action(){

                        public void postCommit() {
                            entry.discard();
                        }

                        public void onRollback() {
                        }
                    });
                }
                this._alternateExchange.removeReference(this);
            } else {
                for (final QueueEntry entry : entries) {
                    ServerMessage message = entry.getMessage();
                    if (message == null) continue;
                    txn.dequeue(this, message, new ServerTransaction.Action(){

                        public void postCommit() {
                            entry.discard();
                        }

                        public void onRollback() {
                        }
                    });
                }
            }
            txn.commit();
            if (this._managedObject != null) {
                this._managedObject.unregister();
            }
            for (AMQQueue.Task task : this._deleteTaskList) {
                task.doTask(this);
            }
            this._deleteTaskList.clear();
            this.stop();
            CurrentActor.get().message(this._logSubject, QueueMessages.DELETED());
        }
        return this.getMessageCount();
    }

    @Override
    public void stop() {
        if (!this._stopped.getAndSet(true)) {
            ReferenceCountingExecutorService.getInstance().releaseExecutorService();
        }
    }

    @Override
    public void checkCapacity(AMQChannel channel) {
        if (this._capacity != 0L && this._atomicQueueSize.get() > this._capacity) {
            this._overfull.set(true);
            this._logActor.message(this._logSubject, QueueMessages.OVERFULL(this._atomicQueueSize.get(), this._capacity));
            if (this._blockedChannels.putIfAbsent(channel, Boolean.TRUE) == null) {
                channel.block(this);
            }
            if (this._atomicQueueSize.get() <= this._flowResumeCapacity) {
                this._logActor.message(this._logSubject, QueueMessages.UNDERFULL(this._atomicQueueSize.get(), this._flowResumeCapacity));
                channel.unblock(this);
                this._blockedChannels.remove(channel);
            }
        }
    }

    private void checkCapacity() {
        if (this._capacity != 0L && this._overfull.get() && this._atomicQueueSize.get() <= this._flowResumeCapacity) {
            if (this._overfull.compareAndSet(true, false)) {
                this._logActor.message(this._logSubject, QueueMessages.UNDERFULL(this._atomicQueueSize.get(), this._flowResumeCapacity));
            }
            for (AMQChannel c : this._blockedChannels.keySet()) {
                c.unblock(this);
                this._blockedChannels.remove(c);
            }
        }
    }

    @Override
    public void deliverAsync() {
    }

    @Override
    public void deliverAsync(Subscription sub) {
    }

    @Override
    public void flushSubscription(Subscription sub) throws AMQException {
        if (!this.getVirtualHost().getSecurityManager().authoriseConsume(this)) {
            throw new AMQSecurityException("Permission denied: " + this.getName());
        }
        this.flushSubscription(sub, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushSubscription(Subscription sub, long iterations) throws AMQException {
        boolean atTail = false;
        while (!sub.isSuspended() && !atTail && iterations != 0L) {
            try {
                sub.getSendLock();
                atTail = this.attemptDelivery(sub);
                if (atTail && sub.isAutoClose()) {
                    this.unregisterSubscription(sub);
                    sub.confirmAutoClose();
                    continue;
                }
                if (atTail) continue;
                --iterations;
            }
            finally {
                sub.releaseSendLock();
            }
        }
        if (!this.hasExclusiveSubscriber()) {
            this.advanceAllSubscriptions();
        }
        return atTail;
    }

    private boolean attemptDelivery(Subscription sub) throws AMQException {
        boolean subActive;
        boolean atTail = false;
        boolean bl = subActive = sub.isActive() && !sub.isSuspended();
        if (subActive) {
            QueueEntry node = this.getNextAvailableEntry(sub);
            if (node != null && node.isAvailable() && sub.hasInterest(node)) {
                if (!sub.wouldSuspend(node)) {
                    if (sub.acquires() && !node.acquire(sub)) {
                        sub.onDequeue(node);
                    } else {
                        this.deliverMessage(sub, node);
                    }
                } else {
                    subActive = false;
                    node.addStateChangeListener(new QueueEntryListener(sub));
                }
            }
            atTail = node == null || this._entries.next(node) == null;
        }
        return atTail || !subActive;
    }

    protected void advanceAllSubscriptions() throws AMQException {
        SubscriptionList.SubscriptionNodeIterator subscriberIter = this._subscriptionList.iterator();
        while (subscriberIter.advance()) {
            SubscriptionList.SubscriptionNode subNode = subscriberIter.getNode();
            Subscription sub = subNode.getSubscription();
            if (!sub.acquires()) continue;
            this.getNextAvailableEntry(sub);
        }
    }

    private QueueEntry getNextAvailableEntry(Subscription sub) throws AMQException {
        QueueContext context = (QueueContext)sub.getQueueContext();
        if (context != null) {
            QueueEntry lastSeen = context._lastSeenEntry;
            QueueEntry releasedNode = context._releasedEntry;
            QueueEntry node = releasedNode != null && lastSeen.compareTo(releasedNode) >= 0 ? releasedNode : this._entries.next(lastSeen);
            boolean expired = false;
            while (!(node == null || node.isAvailable() && !(expired = node.expired()) && sub.hasInterest(node))) {
                if (expired) {
                    expired = false;
                    if (node.acquire()) {
                        this.dequeueEntry(node);
                    }
                }
                if (QueueContext._lastSeenUpdater.compareAndSet(context, lastSeen, node)) {
                    QueueContext._releasedUpdater.compareAndSet(context, releasedNode, null);
                }
                lastSeen = context._lastSeenEntry;
                releasedNode = context._releasedEntry;
                node = releasedNode != null && lastSeen.compareTo(releasedNode) > 0 ? releasedNode : this._entries.next(lastSeen);
            }
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue(QueueRunner runner) throws AMQException {
        long stateChangeCount;
        long previousStateChangeCount = Long.MIN_VALUE;
        boolean deliveryIncomplete = true;
        boolean lastLoop = false;
        int iterations = 10;
        this._asynchronousRunner.compareAndSet(runner, null);
        boolean attempt = false;
        while (iterations != 0 && (previousStateChangeCount != (stateChangeCount = this._stateChangeCount.get()) || deliveryIncomplete) && this._asynchronousRunner.compareAndSet(null, runner)) {
            if (previousStateChangeCount != stateChangeCount) {
                lastLoop = false;
            }
            previousStateChangeCount = stateChangeCount;
            boolean allSubscriptionsDone = true;
            SubscriptionList.SubscriptionNodeIterator subscriptionIter = this._subscriptionList.iterator();
            while (subscriptionIter.advance()) {
                Subscription sub = subscriptionIter.getNode().getSubscription();
                sub.getSendLock();
                try {
                    boolean subscriptionDone = false;
                    if (subscriptionDone) {
                        if (!lastLoop || !sub.isAutoClose()) continue;
                        this.unregisterSubscription(sub);
                        sub.confirmAutoClose();
                        continue;
                    }
                    allSubscriptionsDone = false;
                    lastLoop = false;
                    --iterations;
                }
                finally {
                    sub.releaseSendLock();
                }
            }
            if (allSubscriptionsDone && lastLoop) {
                deliveryIncomplete = false;
            } else if (allSubscriptionsDone) {
                deliveryIncomplete = this._subscriptionList.size() != 0;
                lastLoop = true;
            } else {
                lastLoop = false;
                deliveryIncomplete = true;
            }
            this._asynchronousRunner.set(null);
        }
        if (iterations == 0 && this._asynchronousRunner.compareAndSet(null, runner)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Rescheduling runner:" + runner));
            }
            this._asyncDelivery.execute(runner);
        }
    }

    @Override
    public void checkMessageStatus() throws AMQException {
        QueueEntryIterator queueListIterator = this._entries.iterator();
        while (queueListIterator.advance()) {
            ServerMessage msg;
            QueueEntry node = queueListIterator.getNode();
            if (node.isDispensed()) continue;
            if (node.expired() && node.acquire()) {
                this.dequeueEntry(node);
                continue;
            }
            if (this._managedObject == null || (msg = node.getMessage()) == null) continue;
            this._managedObject.checkForNotification(msg);
        }
    }

    @Override
    public long getMinimumAlertRepeatGap() {
        return this._minimumAlertRepeatGap;
    }

    @Override
    public void setMinimumAlertRepeatGap(long minimumAlertRepeatGap) {
        this._minimumAlertRepeatGap = minimumAlertRepeatGap;
    }

    @Override
    public long getMaximumMessageAge() {
        return this._maximumMessageAge;
    }

    @Override
    public void setMaximumMessageAge(long maximumMessageAge) {
        this._maximumMessageAge = maximumMessageAge;
        if (maximumMessageAge == 0L) {
            this._notificationChecks.remove((Object)NotificationCheck.MESSAGE_AGE_ALERT);
        } else {
            this._notificationChecks.add(NotificationCheck.MESSAGE_AGE_ALERT);
        }
    }

    @Override
    public long getMaximumMessageCount() {
        return this._maximumMessageCount;
    }

    @Override
    public void setMaximumMessageCount(long maximumMessageCount) {
        this._maximumMessageCount = maximumMessageCount;
        if (maximumMessageCount == 0L) {
            this._notificationChecks.remove((Object)NotificationCheck.MESSAGE_COUNT_ALERT);
        } else {
            this._notificationChecks.add(NotificationCheck.MESSAGE_COUNT_ALERT);
        }
    }

    @Override
    public long getMaximumQueueDepth() {
        return this._maximumQueueDepth;
    }

    @Override
    public void setMaximumQueueDepth(long maximumQueueDepth) {
        this._maximumQueueDepth = maximumQueueDepth;
        if (maximumQueueDepth == 0L) {
            this._notificationChecks.remove((Object)NotificationCheck.QUEUE_DEPTH_ALERT);
        } else {
            this._notificationChecks.add(NotificationCheck.QUEUE_DEPTH_ALERT);
        }
    }

    @Override
    public long getMaximumMessageSize() {
        return this._maximumMessageSize;
    }

    @Override
    public void setMaximumMessageSize(long maximumMessageSize) {
        this._maximumMessageSize = maximumMessageSize;
        if (maximumMessageSize == 0L) {
            this._notificationChecks.remove((Object)NotificationCheck.MESSAGE_SIZE_ALERT);
        } else {
            this._notificationChecks.add(NotificationCheck.MESSAGE_SIZE_ALERT);
        }
    }

    @Override
    public long getCapacity() {
        return this._capacity;
    }

    @Override
    public void setCapacity(long capacity) {
        this._capacity = capacity;
    }

    @Override
    public long getFlowResumeCapacity() {
        return this._flowResumeCapacity;
    }

    @Override
    public void setFlowResumeCapacity(long flowResumeCapacity) {
        this._flowResumeCapacity = flowResumeCapacity;
        this.checkCapacity();
    }

    @Override
    public boolean isOverfull() {
        return this._overfull.get();
    }

    @Override
    public Set<NotificationCheck> getNotificationChecks() {
        return this._notificationChecks;
    }

    @Override
    public ManagedObject getManagedObject() {
        return this._managedObject;
    }

    @Override
    public List<Long> getMessagesOnTheQueue(int num) {
        return this.getMessagesOnTheQueue(num, 0);
    }

    @Override
    public List<Long> getMessagesOnTheQueue(int num, int offset) {
        int i;
        ArrayList<Long> ids = new ArrayList<Long>(num);
        QueueEntryIterator it = this._entries.iterator();
        for (i = 0; i < offset; ++i) {
            it.advance();
        }
        for (i = 0; i < num && !it.atTail(); ++i) {
            it.advance();
            ids.add(it.getNode().getMessage().getMessageNumber());
        }
        return ids;
    }

    @Override
    public AMQSessionModel getExclusiveOwningSession() {
        return this._exclusiveOwner;
    }

    @Override
    public void setExclusiveOwningSession(AMQSessionModel exclusiveOwner) {
        this._exclusive = true;
        this._exclusiveOwner = exclusiveOwner;
    }

    @Override
    public void configure(ConfigurationPlugin config) {
        if (config != null) {
            if (config instanceof QueueConfiguration) {
                this.setMaximumMessageAge(((QueueConfiguration)config).getMaximumMessageAge());
                this.setMaximumQueueDepth(((QueueConfiguration)config).getMaximumQueueDepth());
                this.setMaximumMessageSize(((QueueConfiguration)config).getMaximumMessageSize());
                this.setMaximumMessageCount(((QueueConfiguration)config).getMaximumMessageCount());
                this.setMinimumAlertRepeatGap(((QueueConfiguration)config).getMinimumAlertRepeatGap());
                this._capacity = ((QueueConfiguration)config).getCapacity();
                this._flowResumeCapacity = ((QueueConfiguration)config).getFlowResumeCapacity();
            }
            this._queueConfiguration = config;
        }
    }

    @Override
    public ConfigurationPlugin getConfiguration() {
        return this._queueConfiguration;
    }

    @Override
    public String getResourceName() {
        return this._resourceName;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    @Override
    public long getMessageDequeueCount() {
        return this._dequeueCount.get();
    }

    @Override
    public long getTotalEnqueueSize() {
        return this._enqueueSize.get();
    }

    @Override
    public long getTotalDequeueSize() {
        return this._dequeueSize.get();
    }

    @Override
    public long getByteTxnEnqueues() {
        return this._byteTxnEnqueues.get();
    }

    @Override
    public long getByteTxnDequeues() {
        return this._byteTxnDequeues.get();
    }

    @Override
    public long getMsgTxnEnqueues() {
        return this._msgTxnEnqueues.get();
    }

    @Override
    public long getMsgTxnDequeues() {
        return this._msgTxnDequeues.get();
    }

    @Override
    public long getPersistentByteEnqueues() {
        return this._persistentMessageEnqueueSize.get();
    }

    @Override
    public long getPersistentByteDequeues() {
        return this._persistentMessageDequeueSize.get();
    }

    @Override
    public long getPersistentMsgEnqueues() {
        return this._persistentMessageEnqueueCount.get();
    }

    @Override
    public long getPersistentMsgDequeues() {
        return this._persistentMessageDequeueCount.get();
    }

    public String toString() {
        return String.valueOf(this.getNameShortString());
    }

    @Override
    public long getUnackedMessageCountHigh() {
        return this._unackedMsgCountHigh.get();
    }

    @Override
    public long getUnackedMessageCount() {
        return this._unackedMsgCount.get();
    }

    @Override
    public void decrementUnackedMsgCount() {
        this._unackedMsgCount.decrementAndGet();
    }

    private void incrementUnackedMsgCount() {
        long unackedMsgCountHigh;
        long unackedMsgCount = this._unackedMsgCount.incrementAndGet();
        while (unackedMsgCount > (unackedMsgCountHigh = this._unackedMsgCountHigh.get()) && !this._unackedMsgCountHigh.compareAndSet(unackedMsgCountHigh, unackedMsgCount)) {
        }
    }

    public LogActor getLogActor() {
        return this._logActor;
    }

    private final class QueueEntryListener
    implements QueueEntry.StateChangeListener {
        private final Subscription _sub;

        public QueueEntryListener(Subscription sub) {
            this._sub = sub;
        }

        public boolean equals(Object o) {
            assert (o != null);
            assert (o instanceof QueueEntryListener);
            return this._sub == ((QueueEntryListener)o)._sub;
        }

        public int hashCode() {
            return System.identityHashCode(this._sub);
        }

        public void stateChanged(QueueEntry entry, QueueEntry.State oldSate, QueueEntry.State newState) {
            entry.removeStateChangeListener(this);
            SimpleAMQQueue.this.deliverAsync(this._sub);
        }
    }

    public static interface QueueEntryFilter {
        public boolean accept(QueueEntry var1);

        public boolean filterComplete();
    }
}

