/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.protocol;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.log4j.Logger;
import org.wso2.andes.protocol.ProtocolEngine;
import org.wso2.andes.server.protocol.AMQProtocolEngine;
import org.wso2.andes.server.protocol.AmqpProtocolVersion;
import org.wso2.andes.server.protocol.ProtocolEngine_0_10;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.transport.ServerConnection;
import org.wso2.andes.server.transport.ServerConnectionDelegate;
import org.wso2.andes.transport.ConnectionDelegate;
import org.wso2.andes.transport.Sender;
import org.wso2.andes.transport.network.NetworkConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionProtocolEngine
implements ProtocolEngine {
    private static final Logger _logger = Logger.getLogger(MultiVersionProtocolEngine.class);
    private Set<AmqpProtocolVersion> _supported;
    private String _fqdn;
    private IApplicationRegistry _appRegistry;
    private NetworkConnection _network;
    private Sender<ByteBuffer> _sender;
    private volatile ProtocolEngine _delegate = new SelfDelegateProtocolEngine();
    private static final int MINIMUM_REQUIRED_HEADER_BYTES = 8;
    private static final byte[] AMQP_0_8_HEADER = new byte[]{65, 77, 81, 80, 1, 1, 8, 0};
    private static final byte[] AMQP_0_9_HEADER = new byte[]{65, 77, 81, 80, 1, 1, 0, 9};
    private static final byte[] AMQP_0_9_1_HEADER = new byte[]{65, 77, 81, 80, 0, 0, 9, 1};
    private static final byte[] AMQP_0_10_HEADER = new byte[]{65, 77, 81, 80, 1, 1, 0, 10};
    private DelegateCreator creator_0_8 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v0_8;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_0_8_HEADER;
        }

        public ProtocolEngine getProtocolEngine() {
            return new AMQProtocolEngine(MultiVersionProtocolEngine.this._appRegistry.getVirtualHostRegistry(), MultiVersionProtocolEngine.this._network);
        }
    };
    private DelegateCreator creator_0_9 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v0_9;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_0_9_HEADER;
        }

        public ProtocolEngine getProtocolEngine() {
            return new AMQProtocolEngine(MultiVersionProtocolEngine.this._appRegistry.getVirtualHostRegistry(), MultiVersionProtocolEngine.this._network);
        }
    };
    private DelegateCreator creator_0_9_1 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v0_9_1;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_0_9_1_HEADER;
        }

        public ProtocolEngine getProtocolEngine() {
            return new AMQProtocolEngine(MultiVersionProtocolEngine.this._appRegistry.getVirtualHostRegistry(), MultiVersionProtocolEngine.this._network);
        }
    };
    private DelegateCreator creator_0_10 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v0_10;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_0_10_HEADER;
        }

        public ProtocolEngine getProtocolEngine() {
            ServerConnectionDelegate connDelegate = new ServerConnectionDelegate(MultiVersionProtocolEngine.this._appRegistry, MultiVersionProtocolEngine.this._fqdn);
            ServerConnection conn = new ServerConnection();
            conn.setConnectionDelegate((ConnectionDelegate)connDelegate);
            return new ProtocolEngine_0_10(conn, MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._appRegistry);
        }
    };
    private final DelegateCreator[] _creators = new DelegateCreator[]{this.creator_0_8, this.creator_0_9, this.creator_0_9_1, this.creator_0_10};

    public MultiVersionProtocolEngine(IApplicationRegistry appRegistry, String fqdn, Set<AmqpProtocolVersion> supported, NetworkConnection network) {
        this._appRegistry = appRegistry;
        this._fqdn = fqdn;
        this._supported = supported;
        this._network = network;
        this._sender = this._network.getSender();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._delegate.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._delegate.getLocalAddress();
    }

    @Override
    public long getWrittenBytes() {
        return this._delegate.getWrittenBytes();
    }

    @Override
    public long getReadBytes() {
        return this._delegate.getReadBytes();
    }

    @Override
    public void closed() {
        this._delegate.closed();
    }

    @Override
    public void writerIdle() {
        this._delegate.writerIdle();
    }

    @Override
    public void readerIdle() {
        this._delegate.readerIdle();
    }

    @Override
    public void received(ByteBuffer msg) {
        this._delegate.received(msg);
    }

    @Override
    public void exception(Throwable t) {
        this._delegate.exception(t);
    }

    private class SelfDelegateProtocolEngine
    implements ProtocolEngine {
        private final ByteBuffer _header = ByteBuffer.allocate(8);

        private SelfDelegateProtocolEngine() {
        }

        public SocketAddress getRemoteAddress() {
            return MultiVersionProtocolEngine.this._network.getRemoteAddress();
        }

        public SocketAddress getLocalAddress() {
            return MultiVersionProtocolEngine.this._network.getLocalAddress();
        }

        public long getWrittenBytes() {
            return 0L;
        }

        public long getReadBytes() {
            return 0L;
        }

        public void received(ByteBuffer msg) {
            ByteBuffer msgheader = msg.duplicate();
            if (this._header.remaining() > msgheader.limit()) {
                msg.position(msg.limit());
            } else {
                msgheader.limit(this._header.remaining());
                msg.position(this._header.remaining());
            }
            this._header.put(msgheader);
            if (!this._header.hasRemaining()) {
                this._header.flip();
                byte[] headerBytes = new byte[8];
                this._header.get(headerBytes);
                ProtocolEngine newDelegate = null;
                byte[] newestSupported = null;
                for (int i = 0; newDelegate == null && i < MultiVersionProtocolEngine.this._creators.length; ++i) {
                    if (!MultiVersionProtocolEngine.this._supported.contains((Object)MultiVersionProtocolEngine.this._creators[i].getVersion())) continue;
                    newestSupported = MultiVersionProtocolEngine.this._creators[i].getHeaderIdentifier();
                    byte[] compareBytes = MultiVersionProtocolEngine.this._creators[i].getHeaderIdentifier();
                    boolean equal = true;
                    for (int j = 0; equal && j < compareBytes.length; ++j) {
                        equal = headerBytes[j] == compareBytes[j];
                    }
                    if (!equal) continue;
                    newDelegate = MultiVersionProtocolEngine.this._creators[i].getProtocolEngine();
                }
                if (newDelegate == null) {
                    MultiVersionProtocolEngine.this._sender.send(ByteBuffer.wrap(newestSupported));
                    MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                } else {
                    MultiVersionProtocolEngine.this._delegate = newDelegate;
                    this._header.flip();
                    MultiVersionProtocolEngine.this._delegate.received(this._header);
                    if (msg.hasRemaining()) {
                        MultiVersionProtocolEngine.this._delegate.received(msg);
                    }
                }
            }
        }

        public void exception(Throwable t) {
            _logger.error((Object)"Error establishing session", t);
        }

        public void closed() {
        }

        public void writerIdle() {
        }

        public void readerIdle() {
        }
    }

    private class ClosedDelegateProtocolEngine
    implements ProtocolEngine {
        private ClosedDelegateProtocolEngine() {
        }

        public SocketAddress getRemoteAddress() {
            return MultiVersionProtocolEngine.this._network.getRemoteAddress();
        }

        public SocketAddress getLocalAddress() {
            return MultiVersionProtocolEngine.this._network.getLocalAddress();
        }

        public long getWrittenBytes() {
            return 0L;
        }

        public long getReadBytes() {
            return 0L;
        }

        public void received(ByteBuffer msg) {
            _logger.error((Object)"Error processing incoming data, could not negotiate a common protocol");
        }

        public void exception(Throwable t) {
            _logger.error((Object)"Error establishing session", t);
        }

        public void closed() {
        }

        public void writerIdle() {
        }

        public void readerIdle() {
        }
    }

    private static interface DelegateCreator {
        public AmqpProtocolVersion getVersion();

        public byte[] getHeaderIdentifier();

        public ProtocolEngine getProtocolEngine();
    }
}

