/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.protocol;

import java.util.Date;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.monitor.MonitorNotification;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ConnectionCloseBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.management.common.mbeans.ManagedConnection;
import org.wso2.andes.management.common.mbeans.annotations.MBeanConstructor;
import org.wso2.andes.management.common.mbeans.annotations.MBeanDescription;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.actors.ManagementActor;
import org.wso2.andes.server.management.AMQManagedObject;
import org.wso2.andes.server.management.ManagedObject;
import org.wso2.andes.server.protocol.AMQProtocolSession;

@MBeanDescription(value="Management Bean for an AMQ Broker Connection")
public class AMQProtocolSessionMBean
extends AMQManagedObject
implements ManagedConnection {
    private AMQProtocolSession _protocolSession = null;
    private String _name = null;
    private static final OpenType[] _channelAttributeTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN};
    private static CompositeType _channelType = null;
    private static TabularType _channelsType = null;
    private static final AMQShortString BROKER_MANAGEMENT_CONSOLE_HAS_CLOSED_THE_CONNECTION = new AMQShortString("Broker Management Console has closed the connection.");

    @MBeanConstructor(value="Creates an MBean exposing an AMQ Broker Connection")
    public AMQProtocolSessionMBean(AMQProtocolSession amqProtocolSession) throws NotCompliantMBeanException, OpenDataException {
        super(ManagedConnection.class, "Connection");
        this._protocolSession = amqProtocolSession;
        String remote = this.getRemoteAddress();
        this._name = "anonymous".equals(remote) ? remote + this.hashCode() : remote;
        AMQProtocolSessionMBean.init();
    }

    private static void init() throws OpenDataException {
        _channelType = new CompositeType("Channel", "Channel Details", COMPOSITE_ITEM_NAMES_DESC.toArray(new String[COMPOSITE_ITEM_NAMES_DESC.size()]), COMPOSITE_ITEM_NAMES_DESC.toArray(new String[COMPOSITE_ITEM_NAMES_DESC.size()]), _channelAttributeTypes);
        _channelsType = new TabularType("Channels", "Channels", _channelType, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
    }

    public String getClientId() {
        return String.valueOf(this._protocolSession.getContextKey());
    }

    public String getAuthorizedId() {
        return this._protocolSession.getAuthorizedPrincipal() != null ? this._protocolSession.getAuthorizedPrincipal().getName() : null;
    }

    public String getVersion() {
        return this._protocolSession.getClientVersion() == null ? null : this._protocolSession.getClientVersion().toString();
    }

    public Date getLastIoTime() {
        return new Date(this._protocolSession.getLastIoTime());
    }

    public String getRemoteAddress() {
        return this._protocolSession.getRemoteAddress().toString();
    }

    public ManagedObject getParentObject() {
        return this._protocolSession.getVirtualHost().getManagedObject();
    }

    public Long getWrittenBytes() {
        return this._protocolSession.getWrittenBytes();
    }

    public Long getReadBytes() {
        return this._protocolSession.getWrittenBytes();
    }

    public Long getMaximumNumberOfChannels() {
        return this._protocolSession.getMaximumNumberOfChannels();
    }

    public void setMaximumNumberOfChannels(Long value) {
        this._protocolSession.setMaximumNumberOfChannels(value);
    }

    public String getObjectInstanceName() {
        return ObjectName.quote(this._name);
    }

    public void commitTransactions(int channelId) throws JMException {
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            AMQChannel channel = this._protocolSession.getChannel(channelId);
            if (channel == null) {
                throw new JMException("The channel (channel Id = " + channelId + ") does not exist");
            }
            this._protocolSession.commitTransactions(channel);
        }
        catch (AMQException ex) {
            throw new MBeanException(ex, ex.toString());
        }
        finally {
            CurrentActor.remove();
        }
    }

    public void rollbackTransactions(int channelId) throws JMException {
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            AMQChannel channel = this._protocolSession.getChannel(channelId);
            if (channel == null) {
                throw new JMException("The channel (channel Id = " + channelId + ") does not exist");
            }
            this._protocolSession.rollbackTransactions(channel);
        }
        catch (AMQException ex) {
            throw new MBeanException(ex, ex.toString());
        }
        finally {
            CurrentActor.remove();
        }
    }

    public TabularData channels() throws OpenDataException {
        TabularDataSupport channelsList = new TabularDataSupport(_channelsType);
        List<AMQChannel> list = this._protocolSession.getChannels();
        for (AMQChannel channel : list) {
            Object[] itemValues = new Object[]{channel.getChannelId(), channel.isTransactional(), channel.getDefaultQueue() != null ? channel.getDefaultQueue().getNameShortString().asString() : null, channel.getUnacknowledgedMessageMap().size(), channel.getBlocking()};
            CompositeDataSupport channelData = new CompositeDataSupport(_channelType, COMPOSITE_ITEM_NAMES_DESC.toArray(new String[COMPOSITE_ITEM_NAMES_DESC.size()]), itemValues);
            channelsList.put(channelData);
        }
        return channelsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws JMException {
        MethodRegistry methodRegistry = this._protocolSession.getMethodRegistry();
        ConnectionCloseBody responseBody = methodRegistry.createConnectionCloseBody(AMQConstant.REPLY_SUCCESS.getCode(), BROKER_MANAGEMENT_CONSOLE_HAS_CLOSED_THE_CONNECTION, 0, 0);
        boolean removeActor = false;
        if (CurrentActor.get() == null) {
            removeActor = true;
            CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        }
        try {
            this._protocolSession.writeFrame(responseBody.generateFrame(0));
            try {
                this._protocolSession.closeSession();
            }
            catch (AMQException ex) {
                throw new MBeanException(ex, ex.toString());
            }
        }
        finally {
            if (removeActor) {
                CurrentActor.remove();
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] notificationTypes = new String[]{"jmx.monitor.counter.threshold"};
        String name = MonitorNotification.class.getName();
        String description = "Channel count has reached threshold value";
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(notificationTypes, name, description);
        return new MBeanNotificationInfo[]{info1};
    }

    public void notifyClients(String notificationMsg) {
        Notification n = new Notification("jmx.monitor.counter.threshold", this, ++this._notificationSequenceNumber, System.currentTimeMillis(), notificationMsg);
        this._broadcaster.sendNotification(n);
    }

    public void resetStatistics() throws Exception {
        this._protocolSession.resetStatistics();
    }

    public double getPeakMessageDeliveryRate() {
        return this._protocolSession.getMessageDeliveryStatistics().getPeak();
    }

    public double getPeakDataDeliveryRate() {
        return this._protocolSession.getDataDeliveryStatistics().getPeak();
    }

    public double getMessageDeliveryRate() {
        return this._protocolSession.getMessageDeliveryStatistics().getRate();
    }

    public double getDataDeliveryRate() {
        return this._protocolSession.getDataDeliveryStatistics().getRate();
    }

    public long getTotalMessagesDelivered() {
        return this._protocolSession.getMessageDeliveryStatistics().getTotal();
    }

    public long getTotalDataDelivered() {
        return this._protocolSession.getDataDeliveryStatistics().getTotal();
    }

    public double getPeakMessageReceiptRate() {
        return this._protocolSession.getMessageReceiptStatistics().getPeak();
    }

    public double getPeakDataReceiptRate() {
        return this._protocolSession.getDataReceiptStatistics().getPeak();
    }

    public double getMessageReceiptRate() {
        return this._protocolSession.getMessageReceiptStatistics().getRate();
    }

    public double getDataReceiptRate() {
        return this._protocolSession.getDataReceiptStatistics().getRate();
    }

    public long getTotalMessagesReceived() {
        return this._protocolSession.getMessageReceiptStatistics().getTotal();
    }

    public long getTotalDataReceived() {
        return this._protocolSession.getDataReceiptStatistics().getTotal();
    }

    public boolean isStatisticsEnabled() {
        return this._protocolSession.isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean enabled) {
        this._protocolSession.setStatisticsEnabled(enabled);
    }

    static {
        try {
            AMQProtocolSessionMBean.init();
        }
        catch (JMException ex) {
            throw new RuntimeException("Got JMException in static initializer.", ex);
        }
    }
}

