/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.management;

import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.wso2.andes.server.management.ManagedObject;
import org.wso2.andes.server.management.ManagedObjectRegistry;
import org.wso2.andes.server.registry.ApplicationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultManagedObject
extends StandardMBean
implements ManagedObject {
    private static final Logger LOGGER = Logger.getLogger(ApplicationRegistry.class);
    private Class<?> _managementInterface;
    private String _typeName;
    private ManagedObjectRegistry _registry;

    protected DefaultManagedObject(Class<?> managementInterface, String typeName) throws NotCompliantMBeanException {
        super(managementInterface);
        this._managementInterface = managementInterface;
        this._typeName = typeName;
    }

    @Override
    public String getType() {
        return this._typeName;
    }

    @Override
    public Class<?> getManagementInterface() {
        return this._managementInterface;
    }

    @Override
    public ManagedObject getParentObject() {
        return null;
    }

    @Override
    public void register() throws JMException {
        this._registry = ApplicationRegistry.getInstance().getManagedObjectRegistry();
        this._registry.registerObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        try {
            if (this._registry != null) {
                this._registry.unregisterObject(this);
            }
        }
        catch (JMException e) {
            LOGGER.error((Object)("Error unregistering managed object: " + this + ": " + e), (Throwable)e);
        }
        finally {
            this._registry = null;
        }
    }

    public String toString() {
        return this.getObjectInstanceName() + "[" + this.getType() + "]";
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        String name = this.getObjectInstanceName();
        StringBuffer objectName = new StringBuffer("org.wso2.andes");
        objectName.append(":type=");
        objectName.append(this.getHierarchicalType(this));
        objectName.append(",");
        objectName.append(this.getHierarchicalName(this));
        objectName.append("name=").append(name);
        return new ObjectName(objectName.toString());
    }

    protected ObjectName getObjectNameForSingleInstanceMBean() throws MalformedObjectNameException {
        StringBuffer objectName = new StringBuffer("org.wso2.andes");
        objectName.append(":type=");
        objectName.append(this.getHierarchicalType(this));
        String hierarchyName = this.getHierarchicalName(this);
        if (hierarchyName != null) {
            objectName.append(",");
            objectName.append(hierarchyName.substring(0, hierarchyName.lastIndexOf(",")));
        }
        return new ObjectName(objectName.toString());
    }

    protected String getHierarchicalType(ManagedObject obj) {
        if (obj.getParentObject() != null) {
            String parentType = this.getHierarchicalType(obj.getParentObject()).toString();
            return parentType + "." + obj.getType();
        }
        return obj.getType();
    }

    protected String getHierarchicalName(ManagedObject obj) {
        if (obj.getParentObject() != null) {
            String parentName = obj.getParentObject().getType() + "=" + obj.getParentObject().getObjectInstanceName() + "," + this.getHierarchicalName(obj.getParentObject());
            return parentName;
        }
        return "";
    }
}

