/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.wso2.andes.server.configuration.ServerConfiguration;
import org.wso2.andes.server.logging.AbstractRootMessageLogger;
import org.wso2.andes.server.logging.LogActor;
import org.wso2.andes.server.logging.LogSubject;

public class Log4jMessageLogger
extends AbstractRootMessageLogger {
    public static final Level LEVEL = Level.toLevel((String)"INFO");

    public Log4jMessageLogger() {
    }

    public Log4jMessageLogger(ServerConfiguration config) {
        super(config);
    }

    public boolean isMessageEnabled(LogActor actor, LogSubject subject, String logHierarchy) {
        return this.isMessageEnabled(actor, logHierarchy);
    }

    public boolean isMessageEnabled(LogActor actor, String logHierarchy) {
        if (this.isEnabled()) {
            Logger logger = Logger.getLogger((String)logHierarchy);
            return logger.isEnabledFor((Priority)LEVEL);
        }
        return false;
    }

    public void rawMessage(String message, String logHierarchy) {
        this.rawMessage(message, null, logHierarchy);
    }

    public void rawMessage(String message, Throwable throwable, String logHierarchy) {
        Logger logger = Logger.getLogger((String)logHierarchy);
        logger.log((Priority)LEVEL, (Object)message, throwable);
    }
}

