/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.TxRollbackBody;
import org.wso2.andes.framing.TxRollbackOkBody;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxRollbackHandler
implements StateAwareMethodListener<TxRollbackBody> {
    private static TxRollbackHandler _instance = new TxRollbackHandler();

    public static TxRollbackHandler getInstance() {
        return _instance;
    }

    private TxRollbackHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, TxRollbackBody body, final int channelId) throws AMQException {
        final AMQProtocolSession session = stateManager.getProtocolSession();
        try {
            AMQChannel channel = session.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            MethodRegistry methodRegistry = session.getMethodRegistry();
            final TxRollbackOkBody responseBody = methodRegistry.createTxRollbackOkBody();
            Runnable task = new Runnable(){

                public void run() {
                    session.writeFrame(responseBody.generateFrame(channelId));
                }
            };
            channel.rollback(task);
        }
        catch (AMQException e) {
            throw body.getChannelException(e.getErrorCode(), "Failed to rollback: " + e.getMessage());
        }
    }
}

