/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.QueueDeleteBody;
import org.wso2.andes.framing.QueueDeleteOkBody;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.store.DurableConfigurationStore;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueDeleteHandler
implements StateAwareMethodListener<QueueDeleteBody> {
    private static final QueueDeleteHandler _instance = new QueueDeleteHandler();
    private final boolean _failIfNotFound;

    public static QueueDeleteHandler getInstance() {
        return _instance;
    }

    public QueueDeleteHandler() {
        this(true);
    }

    public QueueDeleteHandler(boolean failIfNotFound) {
        this._failIfNotFound = failIfNotFound;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueDeleteBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost virtualHost = protocolConnection.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        DurableConfigurationStore store = virtualHost.getDurableConfigurationStore();
        if (body.getQueue() == null) {
            AMQChannel channel = protocolConnection.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
        } else {
            queue = queueRegistry.getQueue(body.getQueue());
        }
        if (queue == null) {
            if (this._failIfNotFound) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
            }
        } else {
            if (body.getIfEmpty() && !queue.isEmpty()) {
                throw body.getChannelException(AMQConstant.IN_USE, "Queue: " + body.getQueue() + " is not empty.");
            }
            if (body.getIfUnused() && !queue.isUnused()) {
                throw body.getChannelException(AMQConstant.IN_USE, "Queue: " + body.getQueue() + " is still used.");
            }
            AMQSessionModel session = queue.getExclusiveOwningSession();
            if (queue.isExclusive() && !queue.isDurable() && (session == null || session.getConnectionModel() != protocolConnection)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getNameShortString() + " is exclusive, but not created on this Connection.");
            }
            int purged = queue.delete();
            if (queue.isDurable()) {
                store.removeQueue(queue);
            }
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            QueueDeleteOkBody responseBody = methodRegistry.createQueueDeleteOkBody(purged);
            protocolConnection.writeFrame(responseBody.generateFrame(channelId));
        }
    }
}

