/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ConnectionOpenBody;
import org.wso2.andes.framing.ConnectionOpenOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQState;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionOpenMethodHandler
implements StateAwareMethodListener<ConnectionOpenBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionOpenMethodHandler.class);
    private static ConnectionOpenMethodHandler _instance = new ConnectionOpenMethodHandler();

    public static ConnectionOpenMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionOpenMethodHandler() {
    }

    private static AMQShortString generateClientID() {
        return new AMQShortString(Long.toString(System.currentTimeMillis()));
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionOpenBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        String virtualHostName = body.getVirtualHost() != null && body.getVirtualHost().charAt(0) == '/' ? new StringBuilder(body.getVirtualHost().subSequence(1, body.getVirtualHost().length())).toString() : (body.getVirtualHost() == null ? null : String.valueOf(body.getVirtualHost()));
        VirtualHost virtualHost = stateManager.getVirtualHostRegistry().getVirtualHost(virtualHostName);
        if (virtualHost == null) {
            throw body.getConnectionException(AMQConstant.NOT_FOUND, "Unknown virtual host: '" + virtualHostName + "'");
        }
        if (!virtualHost.getSecurityManager().accessVirtualhost(virtualHostName, session.getRemoteAddress())) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Permission denied: '" + virtualHost.getName() + "'");
        }
        session.setVirtualHost(virtualHost);
        if (session.getContextKey() == null) {
            session.setContextKey(ConnectionOpenMethodHandler.generateClientID());
        }
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ConnectionOpenOkBody responseBody = methodRegistry.createConnectionOpenOkBody(body.getVirtualHost());
        stateManager.changeState(AMQState.CONNECTION_OPEN);
        session.writeFrame(responseBody.generateFrame(channelId));
    }
}

