/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQInvalidArgumentException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicConsumeBody;
import org.wso2.andes.framing.BasicConsumeOkBody;
import org.wso2.andes.framing.ChannelCloseBody;
import org.wso2.andes.framing.ConnectionCloseBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicConsumeMethodHandler
implements StateAwareMethodListener<BasicConsumeBody> {
    private static final Logger _logger = Logger.getLogger(BasicConsumeMethodHandler.class);
    private static final BasicConsumeMethodHandler _instance = new BasicConsumeMethodHandler();

    public static BasicConsumeMethodHandler getInstance() {
        return _instance;
    }

    private BasicConsumeMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicConsumeBody body, int channelId) throws AMQException {
        AMQSessionModel session;
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        VirtualHost vHost = protocolConnection.getVirtualHost();
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("BasicConsume: from '" + body.getQueue() + "' for:" + body.getConsumerTag() + " nowait:" + body.getNowait() + " args:" + body.getArguments()));
        }
        AMQQueue aMQQueue = queue = body.getQueue() == null ? channel.getDefaultQueue() : vHost.getQueueRegistry().getQueue(body.getQueue().intern());
        if (queue == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("No queue for '" + body.getQueue() + "'"));
            }
            if (body.getQueue() != null) {
                String msg = "No such queue, '" + body.getQueue() + "'";
                throw body.getChannelException(AMQConstant.NOT_FOUND, msg);
            }
            String msg = "No queue name provided, no default queue defined.";
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, msg);
        }
        if (queue.isExclusive() && !queue.isDurable() && ((session = queue.getExclusiveOwningSession()) == null || session.getConnectionModel() != protocolConnection)) {
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getNameShortString() + " is exclusive, but not created on this Connection.");
        }
        AMQShortString consumerTagName = body.getConsumerTag() != null ? body.getConsumerTag().intern() : null;
        try {
            if (consumerTagName == null || channel.getSubscription(consumerTagName) == null) {
                AMQShortString consumerTag = channel.subscribeToQueue(consumerTagName, queue, !body.getNoAck(), body.getArguments(), body.getNoLocal(), body.getExclusive());
                if (!body.getNowait()) {
                    MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
                    BasicConsumeOkBody responseBody = methodRegistry.createBasicConsumeOkBody(consumerTag);
                    protocolConnection.writeFrame(responseBody.generateFrame(channelId));
                }
            } else {
                AMQShortString msg = new AMQShortString("Non-unique consumer tag, '" + body.getConsumerTag() + "'");
                MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
                ConnectionCloseBody responseBody = methodRegistry.createConnectionCloseBody(AMQConstant.NOT_ALLOWED.getCode(), msg, body.getClazz(), body.getMethod());
                protocolConnection.writeFrame(responseBody.generateFrame(0));
            }
        }
        catch (AMQInvalidArgumentException ise) {
            _logger.debug((Object)"Closing connection due to invalid selector");
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            ChannelCloseBody responseBody = methodRegistry.createChannelCloseBody(AMQConstant.INVALID_ARGUMENT.getCode(), new AMQShortString(ise.getMessage()), body.getClazz(), body.getMethod());
            protocolConnection.writeFrame(responseBody.generateFrame(channelId));
        }
        catch (AMQQueue.ExistingExclusiveSubscription e) {
            throw body.getChannelException(AMQConstant.ACCESS_REFUSED, "Cannot subscribe to queue " + queue.getNameShortString() + " as it already has an existing exclusive consumer");
        }
        catch (AMQQueue.ExistingSubscriptionPreventsExclusive e) {
            throw body.getChannelException(AMQConstant.ACCESS_REFUSED, "Cannot subscribe to queue " + queue.getNameShortString() + " exclusively as it already has a consumer");
        }
    }
}

