/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.flow;

import org.wso2.andes.server.flow.AbstractFlowCreditManager;
import org.wso2.andes.server.flow.FlowCreditManager_0_10;
import org.wso2.andes.server.message.ServerMessage;

public class CreditCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager_0_10 {
    private volatile long _bytesCredit;
    private volatile long _messageCredit;

    public CreditCreditManager() {
        this(0L, 0L);
    }

    public CreditCreditManager(long bytesCredit, long messageCredit) {
        this._bytesCredit = bytesCredit;
        this._messageCredit = messageCredit;
        this.setSuspended(!this.hasCredit());
    }

    public synchronized void setCreditLimits(long bytesCredit, long messageCredit) {
        this._bytesCredit = bytesCredit;
        this._messageCredit = messageCredit;
        this.setSuspended(!this.hasCredit());
    }

    public long getMessageCredit() {
        return this._messageCredit == -1L ? Long.MAX_VALUE : this._messageCredit;
    }

    public long getBytesCredit() {
        return this._bytesCredit == -1L ? Long.MAX_VALUE : this._bytesCredit;
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
    }

    public synchronized void addCredit(long messageCredit, long bytesCredit) {
        boolean notifyIncrease = true;
        if (this._messageCredit >= 0L && messageCredit > 0L) {
            notifyIncrease = this._messageCredit != 0L;
            this._messageCredit += messageCredit;
        }
        if (this._bytesCredit >= 0L && bytesCredit > 0L) {
            notifyIncrease = notifyIncrease && bytesCredit > 0L;
            this._bytesCredit += bytesCredit;
            if (notifyIncrease) {
                this.notifyIncreaseBytesCredit();
            }
        }
        this.setSuspended(!this.hasCredit());
    }

    public void clearCredit() {
        this._bytesCredit = 0L;
        this._messageCredit = 0L;
        this.setSuspended(true);
    }

    public synchronized boolean hasCredit() {
        return this._bytesCredit != 0L && this._messageCredit != 0L;
    }

    public synchronized boolean useCreditForMessage(ServerMessage msg) {
        if (this._messageCredit >= 0L) {
            if (this._messageCredit > 0L) {
                if (this._bytesCredit < 0L) {
                    --this._messageCredit;
                    return true;
                }
                if (msg.getSize() <= this._bytesCredit) {
                    --this._messageCredit;
                    this._bytesCredit -= msg.getSize();
                    return true;
                }
                return false;
            }
            this.setSuspended(true);
            return false;
        }
        if (this._bytesCredit >= 0L) {
            if (msg.getSize() <= this._bytesCredit) {
                this._bytesCredit -= msg.getSize();
                return true;
            }
            return false;
        }
        return true;
    }

    public synchronized void stop() {
        if (this._bytesCredit > 0L) {
            this._bytesCredit = 0L;
        }
        if (this._messageCredit > 0L) {
            this._messageCredit = 0L;
        }
    }
}

