/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.filter;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQInvalidArgumentException;
import org.wso2.andes.server.filter.BooleanExpression;
import org.wso2.andes.server.filter.MessageFilter;
import org.wso2.andes.server.filter.jms.selector.SelectorParser;
import org.wso2.andes.server.queue.Filterable;

public class JMSSelectorFilter
implements MessageFilter {
    private static final Logger _logger = Logger.getLogger(JMSSelectorFilter.class);
    private String _selector;
    private BooleanExpression _matcher;

    public JMSSelectorFilter(String selector) throws AMQInvalidArgumentException {
        this._selector = selector;
        this._matcher = new SelectorParser().parse(selector);
    }

    public boolean matches(Filterable message) {
        boolean match = this._matcher.matches(message);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(message + " match(" + match + ") selector(" + System.identityHashCode(this._selector) + "):" + this._selector));
        }
        return match;
    }

    public String getSelector() {
        return this._selector;
    }

    public String toString() {
        return "JMSSelector(" + this._selector + ")";
    }
}

