/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.common.Closeable;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.connection.IConnectionRegistry;
import org.wso2.andes.server.protocol.AMQConnectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionRegistry
implements IConnectionRegistry,
Closeable {
    private List<AMQConnectionModel> _registry = new CopyOnWriteArrayList<AMQConnectionModel>();
    private Logger _logger = Logger.getLogger(ConnectionRegistry.class);

    @Override
    public void initialise() {
    }

    @Override
    public void close() {
        while (!this._registry.isEmpty()) {
            AMQConnectionModel connection = this._registry.get(0);
            this.closeConnection(connection, AMQConstant.INTERNAL_ERROR, "Broker is shutting down");
        }
    }

    @Override
    public void closeConnection(AMQConnectionModel connection, AMQConstant cause, String message) {
        try {
            connection.close(cause, message);
        }
        catch (AMQException e) {
            this._logger.warn((Object)("Error closing connection:" + e.getMessage()));
        }
    }

    @Override
    public void registerConnection(AMQConnectionModel connnection) {
        this._registry.add(connnection);
    }

    @Override
    public void deregisterConnection(AMQConnectionModel connnection) {
        this._registry.remove(connnection);
    }

    @Override
    public List<AMQConnectionModel> getConnections() {
        return new ArrayList<AMQConnectionModel>(this._registry);
    }
}

