/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.ClusterNode;
import org.wso2.andes.server.cluster.GlobalQueueManager;
import org.wso2.andes.server.cluster.coordination.CoordinationConstants;
import org.wso2.andes.server.cluster.coordination.CoordinationException;
import org.wso2.andes.server.cluster.coordination.ZooKeeperAgent;
import org.wso2.andes.server.configuration.ClusterConfiguration;
import org.wso2.andes.server.store.CassandraMessageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterManager {
    private Log log = LogFactory.getLog(ClusterManager.class);
    private int nodeId;
    private String zkNode;
    private GlobalQueueManager globalQueueManager;
    private Map<Integer, ClusterNode> nodeMap = new ConcurrentHashMap<Integer, ClusterNode>();
    private Map<String, String> leaderBackUpList = new ConcurrentHashMap<String, String>();
    private ZooKeeperAgent zkAgent;
    private HashMap<Integer, String[]> queueNodeMap = new HashMap();
    private List<String> workerAssignedQueues = new ArrayList<String>();
    private int leaderBackNodeGroupSize = 3;
    private String connectionString;

    public ClusterManager(CassandraMessageStore messageStore, String zkConnectionString) {
        this.globalQueueManager = new GlobalQueueManager(messageStore);
        this.connectionString = zkConnectionString;
    }

    public ClusterManager(CassandraMessageStore messageStore) {
        this.globalQueueManager = new GlobalQueueManager(messageStore);
        this.nodeId = 1;
    }

    public void handleQueueAddition(String queueName) throws CoordinationException {
        ClusterConfiguration config = ClusterResourceHolder.getInstance().getClusterConfiguration();
        if (config.isOnceInOrderSupportEnabled()) {
            return;
        }
        if (!config.isClusteringEnabled().booleanValue()) {
            String[] queues = this.queueNodeMap.get(this.nodeId);
            if (queues == null || queues.length == 0) {
                queues = new String[]{queueName};
                this.queueNodeMap.put(this.nodeId, queues);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                for (String q : queues) {
                    list.add(q);
                }
                if (!list.contains(queueName)) {
                    list.add(queueName);
                }
                queues = list.toArray(new String[list.size()]);
                this.queueNodeMap.put(this.nodeId, queues);
            }
            this.globalQueueManager.addGlobalQueue(queueName);
            return;
        }
        if (this.workerAssignedQueues.contains(queueName)) {
            return;
        }
        try {
            String replacePart;
            this.log.debug((Object)("Adding Queue : " + queueName + " to the cluster "));
            ClusterNode myNode = this.nodeMap.get(this.nodeId);
            if (myNode != null && myNode.getGlobalQueueWokers().contains(queueName)) {
                return;
            }
            List nodeList = this.zkAgent.getZooKeeper().getChildren(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, false);
            int currentMinQueueCountPerNode = Integer.MAX_VALUE;
            String currentCandidateNode = this.zkNode;
            String currentCandidateNodeData = "" + this.nodeId + ":";
            for (String node : nodeList) {
                String path = CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + node;
                byte[] data = this.zkAgent.getZooKeeper().getData(path, false, null);
                String dataStr = new String(data);
                if (dataStr.contains(queueName)) {
                    return;
                }
                String[] parts = dataStr.split(":");
                if (parts.length < 1) continue;
                if (parts.length != 1 && parts[1].length() > 0) {
                    String[] queues = parts[1].split(",");
                    this.queueNodeMap.put(Integer.parseInt(parts[0]), queues);
                    if (queues.length >= currentMinQueueCountPerNode) continue;
                    currentMinQueueCountPerNode = queues.length;
                    currentCandidateNode = node;
                    currentCandidateNodeData = dataStr;
                    continue;
                }
                if (0 >= currentMinQueueCountPerNode) continue;
                currentMinQueueCountPerNode = 0;
                currentCandidateNode = node;
                currentCandidateNodeData = dataStr;
            }
            this.log.debug((Object)("Current Candidiate znode : " + currentCandidateNode + " znode data : " + currentCandidateNodeData));
            this.log.debug((Object)("Node selected  to add queue worker node : " + currentCandidateNode + " for queue : " + queueName));
            String[] candidateNodeDataParts = currentCandidateNodeData.split(":");
            String newData = candidateNodeDataParts.length > 1 ? ((replacePart = candidateNodeDataParts[1]).length() == 0 ? currentCandidateNodeData.replace(":" + replacePart + ":", ":" + replacePart + queueName + "," + ":") : currentCandidateNodeData.replace(replacePart, replacePart + queueName + ",")) : candidateNodeDataParts[0] + ":" + queueName + ",";
            String leaderPath = CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + currentCandidateNode;
            this.log.debug((Object)("Adding new queue data to znode to add new queue workers  : " + newData));
            this.zkAgent.getZooKeeper().setData(leaderPath, newData.getBytes(), -1);
            this.selectPMCForQueue(queueName, currentCandidateNode, nodeList);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Error while handling Queue worker Addition";
            this.log.error((Object)msg, (Throwable)e);
            throw new CoordinationException(msg, e);
        }
    }

    public void handleQueueRemoval(String queueName) throws CoordinationException {
        ClusterConfiguration config = ClusterResourceHolder.getInstance().getClusterConfiguration();
        if (config.isOnceInOrderSupportEnabled()) {
            return;
        }
        if (!config.isClusteringEnabled().booleanValue()) {
            this.globalQueueManager.removeWorker(queueName);
            return;
        }
        try {
            this.log.debug((Object)("Removing Queue " + queueName + " From the cluster"));
            List nodeList = this.zkAgent.getZooKeeper().getChildren(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, false);
            block9: for (String node : nodeList) {
                String path = CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + node;
                byte[] data = this.zkAgent.getZooKeeper().getData(path, false, null);
                String dataStr = new String(data);
                if (!dataStr.contains(queueName)) continue;
                String[] dataParts = dataStr.split(":");
                String newDataString = null;
                switch (dataParts.length) {
                    case 2: {
                        newDataString = dataStr.replace(queueName + ",", "");
                        this.zkAgent.getZooKeeper().setData(path, newDataString.getBytes(), -1);
                        continue block9;
                    }
                    case 3: {
                        String newDp1 = dataParts[1];
                        if (dataParts[1].contains(queueName)) {
                            newDp1 = dataParts[1].replace(queueName + ",", "");
                        }
                        String newDp2 = dataParts[2];
                        if (dataParts[2].contains(queueName)) {
                            String[] pmcParts = dataParts[2].split(",");
                            ArrayList<String> newPmcParts = new ArrayList<String>();
                            for (int i = 0; i < pmcParts.length; ++i) {
                                if (pmcParts[i].contains(queueName)) continue;
                                newPmcParts.add(pmcParts[i]);
                            }
                            newDp2 = "";
                            for (String newPart : newPmcParts) {
                                newDp2 = newDp2 + newPart + ",";
                            }
                        }
                        newDataString = dataParts[0] + ":" + newDp1 + ":" + newDp2;
                        this.zkAgent.getZooKeeper().setData(path, newDataString.getBytes(), -1);
                        continue block9;
                    }
                }
                newDataString = dataStr;
            }
        }
        catch (KeeperException e) {
            throw new CoordinationException("Error while removing Queue ", (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            throw new CoordinationException("Error while removing Queue ", e);
        }
    }

    private void selectPMCForQueue(String queue, String electedLeader, List<String> nodeList) throws InterruptedException, KeeperException {
        if (nodeList != null && nodeList.size() > 1) {
            int i;
            ArrayList<String> pmc = new ArrayList<String>();
            nodeList.remove(electedLeader);
            Random rand = new Random();
            if (nodeList.size() < this.leaderBackNodeGroupSize) {
                i = rand.nextInt(nodeList.size());
                pmc.add(nodeList.get(i));
            } else {
                while (true) {
                    if (pmc.contains(nodeList.get(i = rand.nextInt(nodeList.size())))) {
                        continue;
                    }
                    pmc.add(nodeList.get(i));
                    if (pmc.size() >= this.leaderBackNodeGroupSize) break;
                }
            }
            for (String member : pmc) {
                byte[] mdata = this.zkAgent.getZooKeeper().getData(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + member, false, null);
                String dataStr = new String(mdata);
                String[] parts = dataStr.split(":");
                String newDataStr = null;
                String newPart = electedLeader + "=" + queue;
                switch (parts.length) {
                    case 1: 
                    case 2: {
                        newDataStr = dataStr + ":" + newPart;
                        break;
                    }
                    case 3: {
                        newDataStr = dataStr + "," + newPart;
                    }
                }
                if (parts.length == 2) {
                    newDataStr = dataStr + ":" + newPart;
                } else if (parts.length == 3) {
                    newDataStr = dataStr + "," + newPart;
                } else if (parts.length == 1) {
                    // empty if block
                }
                if (newDataStr == null) continue;
                this.zkAgent.getZooKeeper().setData(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + member, newDataStr.getBytes(), -1);
            }
        }
    }

    public void init() throws CoordinationException {
        final ClusterConfiguration config = ClusterResourceHolder.getInstance().getClusterConfiguration();
        final CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        if (!config.isClusteringEnabled().booleanValue()) {
            List<String> nodeList = messageStore.storedNodeDetails();
            for (String node : nodeList) {
                messageStore.deleteNodeData(node);
            }
            this.queueNodeMap.put(new Integer(this.nodeId), new String[0]);
            messageStore.addNodeDetails("" + this.nodeId, config.getBindIpAddress());
            return;
        }
        try {
            this.zkAgent = new ZooKeeperAgent(this.connectionString);
            this.zkAgent.initQueueWorkerCoordination();
            final String nodeName = CoordinationConstants.QUEUE_WORKER_NODE + UUID.randomUUID().toString().replace("-", "_");
            String path = CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + nodeName;
            this.zkAgent.getZooKeeper().getChildren(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, new Watcher(){

                public void process(WatchedEvent watchedEvent) {
                    if (Watcher.Event.EventType.NodeChildrenChanged == watchedEvent.getType()) {
                        try {
                            List nodeList = ClusterManager.this.zkAgent.getZooKeeper().getChildren(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, false);
                            for (String node : nodeList) {
                                String id = node.substring(nodeName.length());
                                if (!(CoordinationConstants.NODE_SEPARATOR + node).contains(nodeName)) continue;
                                ClusterManager.this.zkNode = node;
                                ClusterManager.this.nodeId = Integer.parseInt(id);
                                ClusterManager.this.log.info((Object)("Initializing Cluster Manager , Selected Node id : " + ClusterManager.this.nodeId));
                                messageStore.addNodeDetails("" + ClusterManager.this.nodeId, config.getBindIpAddress());
                                List zkNodes = ClusterManager.this.zkAgent.getZooKeeper().getChildren(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT, false);
                                ArrayList<String> zkNodeIds = new ArrayList<String>();
                                for (String zNode : zkNodes) {
                                    zkNodeIds.add("" + ClusterManager.getNoideIdFromZkNode(zNode));
                                }
                                List<String> storedNodes = messageStore.storedNodeDetails();
                                for (String storedNode : storedNodes) {
                                    if (zkNodeIds.contains(storedNode)) continue;
                                    messageStore.deleteNodeData(storedNode);
                                }
                                String data = "" + ClusterManager.this.nodeId + ":";
                                ClusterManager.this.zkAgent.getZooKeeper().setData(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + node, data.getBytes(), -1);
                                ClusterManager.this.zkAgent.getZooKeeper().getData(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + node, (Watcher)new NodeDataChangeListener(), null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ClusterManager.this.log.error((Object)e);
                        }
                    }
                }
            });
            this.zkAgent.getZooKeeper().create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Error while initializing the zookeeper coordination ";
            this.log.error((Object)"Error while initializing the zookeeper coordination ", (Throwable)e);
            throw new CoordinationException(msg, e);
        }
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getZkConnectionString() {
        return this.connectionString;
    }

    public String getNodeAddress(int nodeId) {
        return ClusterResourceHolder.getInstance().getCassandraMessageStore().getNodeData("" + nodeId);
    }

    public List<Integer> getZkNodes() {
        return new ArrayList<Integer>(this.queueNodeMap.keySet());
    }

    public String[] getQueues(int nodeId) {
        return this.queueNodeMap.get(nodeId);
    }

    public int numberOfMessagesInQueue(String queue) {
        return this.globalQueueManager.getMessageCount(queue);
    }

    public List<String> getTopics() throws Exception {
        return this.globalQueueManager.getTopics();
    }

    public List<String> getSubscribers(String topic) throws Exception {
        return this.globalQueueManager.getSubscribers(topic);
    }

    public int getSubscriberCount(String topic) throws Exception {
        return this.globalQueueManager.getSubscribers(topic).size();
    }

    private static int getNoideIdFromZkNode(String node) {
        return Integer.parseInt(node.substring(node.length() - 5));
    }

    private class NodeExistenceListener
    implements Watcher {
        private String watchZNode = null;

        public NodeExistenceListener(String zNode) {
            this.watchZNode = zNode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void process(WatchedEvent watchedEvent) {
            if (Watcher.Event.EventType.NodeDeleted == watchedEvent.getType()) {
                String path = watchedEvent.getPath();
                String[] parts = path.split(CoordinationConstants.NODE_SEPARATOR);
                String deletedNode = parts[parts.length - 1];
                try {
                    int deletedNodeId = ClusterManager.getNoideIdFromZkNode(deletedNode);
                    ClusterResourceHolder.getInstance().getCassandraMessageStore().deleteNodeData("" + deletedNodeId);
                }
                catch (Exception e) {
                    ClusterManager.this.log.error((Object)"Error while removing node details");
                }
                try {
                    if (!ClusterManager.this.leaderBackUpList.containsKey(deletedNode)) return;
                    String queueData = (String)ClusterManager.this.leaderBackUpList.get(deletedNode);
                    String[] queues = queueData.split(":");
                    ClusterManager.this.leaderBackUpList.remove(deletedNode);
                    for (String queue : queues) {
                        this.removeFromQLeaderFromZnode(deletedNode, queue);
                        if (this.isLeaderToHandleTheFailOver(queue)) {
                            ClusterManager.this.log.debug((Object)(" Running Leader election again for queue : " + queue + " from node :" + ClusterManager.this.nodeId));
                            ClusterManager.this.handleQueueAddition(queue);
                            continue;
                        }
                        ClusterManager.this.log.debug((Object)("Node :" + ClusterManager.this.nodeId + " is not handling the Fail over for" + " queue : " + queue));
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ClusterManager.this.log.error((Object)e);
                    return;
                }
            }
            try {
                ClusterManager.this.zkAgent.getZooKeeper().exists(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + this.watchZNode, (Watcher)this);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                ClusterManager.this.log.error((Object)("Error while registering a watch for loader node : " + this.watchZNode), (Throwable)e);
            }
        }

        private void removeFromQLeaderFromZnode(String node, String queue) throws InterruptedException, KeeperException {
            String zkDataElement = node + "=" + queue;
            byte[] data = ClusterManager.this.zkAgent.getZooKeeper().getData(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + ClusterManager.this.zkNode, false, null);
            String zkNodeData = new String(data);
            if (zkDataElement.contains(zkDataElement)) {
                String newData = zkNodeData.replace(zkDataElement, "");
                ClusterManager.this.zkAgent.getZooKeeper().setData(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + ClusterManager.this.zkNode, newData.getBytes(), -1);
            }
        }

        private boolean isLeaderToHandleTheFailOver(String queue) throws CoordinationException {
            boolean returnValue;
            try {
                ZooKeeperAgent zooKeeperAgent = new ZooKeeperAgent(ClusterManager.this.connectionString);
                zooKeeperAgent.initQueueFailOverMCProcess(queue);
                ZooKeeper localZk = zooKeeperAgent.getZooKeeper();
                String guid = UUID.randomUUID().toString();
                String nodeName = CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_NODE + guid.replace("-", "_");
                String path = CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue + nodeName;
                localZk.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
                List strList = localZk.getChildren(CoordinationConstants.QUEUE_FAIL_OVER_HANDLING_PARENT + "_" + queue, false);
                String selectedNode = null;
                int currentMin = Integer.MAX_VALUE;
                for (String child : strList) {
                    String id = child.substring(nodeName.length());
                    int seqNumber = Integer.parseInt(id);
                    if (seqNumber >= currentMin) continue;
                    selectedNode = child;
                    currentMin = seqNumber;
                }
                returnValue = selectedNode.contains(guid.replace("-", "_"));
                localZk.close();
            }
            catch (Exception e) {
                String msg = "Error while selecting node to handle the node deletion";
                throw new CoordinationException(msg, e);
            }
            return returnValue;
        }
    }

    private class NodeDataChangeListener
    implements Watcher {
        private NodeDataChangeListener() {
        }

        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.NodeDataChanged == event.getType()) {
                try {
                    byte[] data = ClusterManager.this.zkAgent.getZooKeeper().getData(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + ClusterManager.this.zkNode, (Watcher)this, null);
                    String dataStr = new String(data);
                    String[] parts = dataStr.split(":");
                    if (parts.length > 1 && parts[1].length() > 0) {
                        String[] queues = parts[1].split(",");
                        ClusterManager.this.queueNodeMap.put(Integer.parseInt(parts[0]), queues);
                        if (queues.length > 0) {
                            String[] queuesToBeRemoved;
                            String[] queuesToBescheduled;
                            int nId = Integer.parseInt(parts[0]);
                            ClusterNode node = (ClusterNode)ClusterManager.this.nodeMap.get(nId);
                            if (node == null) {
                                node = new ClusterNode(nId);
                                ClusterManager.this.nodeMap.put(nId, node);
                            }
                            for (String q : queuesToBescheduled = this.getQueueWorkersToBeScheduled(node, queues)) {
                                ClusterManager.this.log.debug((Object)("Adding Queue worker for queue : " + q + " from node :" + ClusterManager.this.nodeId));
                                node.addGlobalQueueWorker(q);
                                ClusterManager.this.globalQueueManager.addGlobalQueue(q);
                            }
                            for (String q : queuesToBeRemoved = this.getQueueWorkersToBeRemoved(node, queues)) {
                                ClusterManager.this.log.debug((Object)("Removing Queue Worker for queue : " + q + " from node :" + ClusterManager.this.nodeId));
                                node.removeGlobalQueueWorker(q);
                                ClusterManager.this.globalQueueManager.removeWorker(q);
                            }
                        }
                    } else {
                        int nId = Integer.parseInt(parts[0]);
                        ClusterNode node = (ClusterNode)ClusterManager.this.nodeMap.get(nId);
                        if (node != null) {
                            for (String q : node.getGlobalQueueWokers()) {
                                ClusterManager.this.globalQueueManager.removeWorker(q);
                                node.removeGlobalQueueWorker(q);
                            }
                        }
                        ClusterManager.this.leaderBackUpList.clear();
                    }
                    if (parts.length == 3) {
                        String[] leaderNodes = parts[2].split(",");
                        if (leaderNodes.length > 0) {
                            for (String lNode : leaderNodes) {
                                String[] details = lNode.split("=");
                                if (!ClusterManager.this.leaderBackUpList.containsKey(details[0])) {
                                    String leaderNode = details[0];
                                    ClusterManager.this.leaderBackUpList.put(leaderNode, details[1]);
                                    ClusterManager.this.zkAgent.getZooKeeper().exists(CoordinationConstants.QUEUE_WORKER_COORDINATION_PARENT + CoordinationConstants.NODE_SEPARATOR + leaderNode, (Watcher)new NodeExistenceListener(leaderNode));
                                    continue;
                                }
                                String d = (String)ClusterManager.this.leaderBackUpList.get(details[0]);
                                if (d.contains(details[1])) continue;
                                d = d + ":" + details[1];
                                ClusterManager.this.leaderBackUpList.put(details[0], d);
                            }
                            this.syncLeaderBackUpList(leaderNodes);
                        } else {
                            ClusterManager.this.leaderBackUpList.clear();
                        }
                    }
                }
                catch (Exception e) {
                    ClusterManager.this.log.fatal((Object)"Error processing the Node data change : This might cause serious issues in distributed queue management", (Throwable)e);
                }
            }
        }

        private String[] getQueueWorkersToBeScheduled(ClusterNode node, String[] queues) {
            ArrayList<String> queueList = new ArrayList<String>();
            for (String q : queues) {
                if (node.getGlobalQueueWokers().contains(q)) continue;
                queueList.add(q);
                node.addGlobalQueueWorker(q);
            }
            return queueList.toArray(new String[queueList.size()]);
        }

        private String[] getQueueWorkersToBeRemoved(ClusterNode node, String[] queues) {
            ArrayList<String> queueList = new ArrayList<String>();
            List<String> qs = Arrays.asList(queues);
            for (String q : node.getGlobalQueueWokers()) {
                if (qs.contains(q)) continue;
                queueList.add(q);
            }
            return queueList.toArray(new String[queueList.size()]);
        }

        private void syncLeaderBackUpList(String[] pmcData) {
            ArrayList<String> nodesToRemove = new ArrayList<String>();
            for (String node : ClusterManager.this.leaderBackUpList.keySet()) {
                boolean contains = false;
                ArrayList<String> queuesToRemove = new ArrayList<String>();
                for (String pmcElm : pmcData) {
                    if (!pmcElm.contains(node)) continue;
                    contains = true;
                    String[] parts = pmcElm.split("=");
                    String q = parts[1].trim();
                    if (((String)ClusterManager.this.leaderBackUpList.get(node)).contains(q)) continue;
                    queuesToRemove.add(q);
                }
                String nodeData = (String)ClusterManager.this.leaderBackUpList.get(node);
                for (String q : queuesToRemove) {
                    if (nodeData.contains(q + ":")) {
                        nodeData.replace(q + ":", "");
                        continue;
                    }
                    nodeData.replace(q, "");
                }
                if (contains) continue;
                nodesToRemove.add(node);
            }
        }
    }
}

