/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.List;
import java.util.Random;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.InOrderMessageFlusher;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.cluster.coordination.CoordinationException;
import org.wso2.andes.server.cluster.coordination.lock.QueueResourceLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraReliableMessageCoordinator
extends Thread {
    private String queueName;
    private List<InOrderMessageFlusher> flusherList;
    private boolean working = false;
    private boolean markedForRemoval;
    private String zkServer = "127.0.0.1:2181";
    private QueueResourceLock queueResourceLock;

    public CassandraReliableMessageCoordinator(String queueName, List<InOrderMessageFlusher> flushers) {
        this.queueName = queueName;
        this.flusherList = flushers;
        ClusterManager clusterManagerInstance = ClusterResourceHolder.getInstance().getClusterManager();
        if (clusterManagerInstance != null) {
            this.zkServer = clusterManagerInstance.getZkConnectionString();
            this.queueResourceLock = ClusterResourceHolder.getInstance().getClusterConfiguration().isClusteringEnabled() != false ? new QueueResourceLock(this.zkServer, queueName) : new QueueResourceLock(queueName);
        }
    }

    public void addFlusher(InOrderMessageFlusher flusher) {
        this.flusherList.add(flusher);
    }

    @Override
    public void run() {
        try {
            this.working = true;
            this.queueResourceLock.acquire();
            int random = new Random().nextInt(this.flusherList.size());
            InOrderMessageFlusher flusher = this.flusherList.get(random);
            flusher.send();
            this.queueResourceLock.release();
            this.working = false;
        }
        catch (CoordinationException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        this.working = working;
    }

    public void setMarkedForRemoval(boolean markedForRemoval) {
        this.markedForRemoval = markedForRemoval;
        try {
            this.queueResourceLock.destroy();
        }
        catch (CoordinationException e) {
            e.printStackTrace();
        }
    }

    public boolean isMarkedForRemoval() {
        return this.markedForRemoval;
    }

    public int removeSubscription(String subscriptionId) {
        int index = -1;
        for (int i = 0; i < this.flusherList.size(); ++i) {
            if (!this.flusherList.get(i).getSubscriptionId().equals(subscriptionId)) continue;
            index = i;
            break;
        }
        this.flusherList.remove(index);
        return this.flusherList.size();
    }
}

