/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.MessageRejectBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;

public class MessageRejectBodyImpl
extends AMQMethodBody_0_9
implements MessageRejectBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new MessageRejectBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 520;
    private final int _code;
    private final AMQShortString _text;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageRejectBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._code = this.readUnsignedShort(buffer);
        this._text = this.readAMQShortString(buffer);
    }

    public MessageRejectBodyImpl(int code, AMQShortString text) {
        this._code = code;
        this._text = text;
    }

    public int getClazz() {
        return 120;
    }

    public int getMethod() {
        return 520;
    }

    public final int getCode() {
        return this._code;
    }

    public final AMQShortString getText() {
        return this._text;
    }

    protected int getBodySize() {
        int size = 2;
        return size += this.getSizeOf(this._text);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._code);
        this.writeAMQShortString(buffer, this._text);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageReject(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageRejectBodyImpl: ");
        buf.append("code=");
        buf.append(this.getCode());
        buf.append(", ");
        buf.append("text=");
        buf.append(this.getText());
        buf.append("]");
        return buf.toString();
    }
}

