/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.framing.AMQDataBlock;
import org.wso2.andes.framing.AMQFrame;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBodyFactory;
import org.wso2.andes.framing.AMQProtocolVersionException;
import org.wso2.andes.framing.BodyFactory;
import org.wso2.andes.framing.ContentBodyFactory;
import org.wso2.andes.framing.ContentHeaderBodyFactory;
import org.wso2.andes.framing.HeartbeatBodyFactory;
import org.wso2.andes.protocol.AMQVersionAwareProtocolSession;

public class AMQDataBlockDecoder {
    private static final String SESSION_METHOD_BODY_FACTORY = "QPID_SESSION_METHOD_BODY_FACTORY";
    private static final BodyFactory[] _bodiesSupported = new BodyFactory[127];
    Logger _logger = LoggerFactory.getLogger(AMQDataBlockDecoder.class);

    public boolean decodable(java.nio.ByteBuffer in) throws AMQFrameDecodingException {
        int remainingAfterAttributes = in.remaining() - 8;
        if (remainingAfterAttributes < 0) {
            return false;
        }
        in.position(in.position() + 1 + 2);
        long bodySize = (long)in.getInt() & 0xFFFFFFFFL;
        return (long)remainingAfterAttributes >= bodySize;
    }

    public AMQFrame createAndPopulateFrame(AMQMethodBodyFactory methodBodyFactory, ByteBuffer in) throws AMQFrameDecodingException, AMQProtocolVersionException {
        byte type = in.get();
        BodyFactory bodyFactory = type == 1 ? methodBodyFactory : _bodiesSupported[type];
        if (bodyFactory == null) {
            throw new AMQFrameDecodingException(null, "Unsupported frame type: " + type, null);
        }
        int channel = in.getUnsignedShort();
        long bodySize = in.getUnsignedInt();
        if (channel < 0 || bodySize < 0L) {
            throw new AMQFrameDecodingException(null, "Undecodable frame: type = " + type + " channel = " + channel + " bodySize = " + bodySize, null);
        }
        AMQFrame frame = new AMQFrame(in, channel, bodySize, bodyFactory);
        byte marker = in.get();
        if ((marker & 0xFF) != 206) {
            throw new AMQFrameDecodingException(null, "End of frame marker not found. Read " + marker + " length=" + bodySize + " type=" + type, null);
        }
        return frame;
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        AMQMethodBodyFactory bodyFactory = (AMQMethodBodyFactory)session.getAttribute(SESSION_METHOD_BODY_FACTORY);
        if (bodyFactory == null) {
            AMQVersionAwareProtocolSession protocolSession = (AMQVersionAwareProtocolSession)session.getAttachment();
            bodyFactory = new AMQMethodBodyFactory(protocolSession);
            session.setAttribute(SESSION_METHOD_BODY_FACTORY, bodyFactory);
        }
        out.write(this.createAndPopulateFrame(bodyFactory, in));
    }

    public boolean decodable(ByteBuffer msg) throws AMQFrameDecodingException {
        return this.decodable(msg.buf());
    }

    public AMQDataBlock createAndPopulateFrame(AMQMethodBodyFactory factory, java.nio.ByteBuffer msg) throws AMQProtocolVersionException, AMQFrameDecodingException {
        return this.createAndPopulateFrame(factory, ByteBuffer.wrap(msg));
    }

    static {
        AMQDataBlockDecoder._bodiesSupported[2] = ContentHeaderBodyFactory.getInstance();
        AMQDataBlockDecoder._bodiesSupported[3] = ContentBodyFactory.getInstance();
        AMQDataBlockDecoder._bodiesSupported[8] = new HeartbeatBodyFactory();
    }
}

