/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.commons.registry;

import java.util.Calendar;
import java.util.Date;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.commons.CommonsUtil;
import org.wso2.carbon.andes.commons.QueueDetails;
import org.wso2.carbon.andes.commons.SubscriptionDetails;
import org.wso2.carbon.andes.commons.internal.CommonsDataHolder;
import org.wso2.carbon.andes.commons.registry.RegistryClientException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryClient {
    private static final Log log = LogFactory.getLog(RegistryClient.class);
    private static final String OWNER = "Owner";
    private static final String NAME = "Name";
    private static final String CREATED_TIME = "createdTime";
    private static final String UPDATED_TIME = "updatedTime";
    private static final String CREATED_FROM = "createdFrom";
    private static final String CREATED_FROM_AMQP = "amqp";
    private static final String USER_COUNT = "userCount";

    public static void createQueue(String queueName, String owner) throws RegistryClientException {
        try {
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            UserRegistry registry = registryService.getGovernanceSystemRegistry(CarbonContext.getCurrentContext().getTenantId() <= 0 ? -1234 : CarbonContext.getCurrentContext().getTenantId());
            Collection queue = null;
            String queueID = CommonsUtil.getQueueID(queueName);
            if (!registry.resourceExists(queueID)) {
                queue = registry.newCollection();
                queue.setProperty(OWNER, owner);
                queue.setProperty(NAME, queueName);
                queue.setProperty(CREATED_TIME, ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                queue.setProperty(UPDATED_TIME, ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                queue.setProperty(CREATED_FROM, CREATED_FROM_AMQP);
                queue.setProperty(USER_COUNT, "1");
            } else {
                queue = (Collection)registry.get(queueID);
                queue.setProperty(UPDATED_TIME, ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                String userCount = queue.getProperty(USER_COUNT);
                if (null != userCount) {
                    int count = Integer.parseInt(userCount);
                    queue.setProperty(USER_COUNT, Integer.toString(++count));
                }
            }
            registry.put(queueID, (Resource)queue);
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static void deleteQueue(String queueName) throws RegistryClientException {
        try {
            Collection queue;
            String userCount;
            String createdFrom;
            String queueID;
            UserRegistry registry;
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            if (registryService != null && (registry = registryService.getGovernanceSystemRegistry()).resourceExists(queueID = CommonsUtil.getQueueID(queueName)) && null != (createdFrom = registry.get(queueID).getProperty(CREATED_FROM)) && CREATED_FROM_AMQP.equals(createdFrom) && null != (userCount = (queue = (Collection)registry.get(queueID)).getProperty(USER_COUNT))) {
                int count = Integer.parseInt(userCount);
                if (count > 1) {
                    queue.setProperty(USER_COUNT, Integer.toString(--count));
                    registry.put(queueID, (Resource)queue);
                } else {
                    registry.delete(queueID);
                }
            }
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static QueueDetails[] getQueues() throws RegistryClientException {
        try {
            QueueDetails[] queueDetailsArray = new QueueDetails[]{};
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            UserRegistry registry = registryService.getGovernanceSystemRegistry(CarbonContext.getCurrentContext().getTenantId() <= 0 ? -1234 : CarbonContext.getCurrentContext().getTenantId());
            String queuesID = CommonsUtil.getQueuesID();
            if (registry.resourceExists(queuesID)) {
                Collection queueCollection = (Collection)registry.get(queuesID);
                queueDetailsArray = new QueueDetails[queueCollection.getChildCount()];
                int index = 0;
                for (String queueId : queueCollection.getChildren()) {
                    Collection queue = (Collection)registry.get(queueId);
                    QueueDetails queueDetails = new QueueDetails();
                    queueDetails.setName(queue.getProperty(NAME));
                    queueDetails.setOwner(queue.getProperty(OWNER));
                    queueDetails.setCreatedTime(queue.getProperty(CREATED_TIME));
                    queueDetailsArray[index++] = queueDetails;
                }
            }
            return queueDetailsArray;
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static void createSubscription(String topic, String subscriptionName, String owner) throws RegistryClientException {
        try {
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            UserRegistry registry = registryService.getGovernanceSystemRegistry(CarbonContext.getCurrentContext().getTenantId() <= 0 ? -1234 : CarbonContext.getCurrentContext().getTenantId());
            Collection subscription = null;
            String subscriptionID = CommonsUtil.getSubscriptionID(topic, subscriptionName);
            subscription = !registry.resourceExists(subscriptionID) ? registry.newCollection() : (Collection)registry.get(subscriptionID);
            subscription.setProperty(OWNER, owner);
            subscription.setProperty(NAME, subscriptionName);
            subscription.setProperty(CREATED_TIME, ConverterUtil.convertToString((Date)new Date()));
            registry.put(subscriptionID, (Resource)subscription);
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static void deleteSubscription(String topic, String subscriptionName) throws RegistryClientException {
        try {
            String subscriptionID;
            UserRegistry registry;
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            if (registryService != null && (registry = registryService.getGovernanceSystemRegistry(CarbonContext.getCurrentContext().getTenantId() <= 0 ? -1234 : CarbonContext.getCurrentContext().getTenantId())).resourceExists(subscriptionID = CommonsUtil.getSubscriptionID(topic, subscriptionName))) {
                registry.delete(subscriptionID);
            }
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static SubscriptionDetails[] getSubscriptions(String topic) throws RegistryClientException {
        try {
            SubscriptionDetails[] subscriptionDetailsArray = new SubscriptionDetails[]{};
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            UserRegistry registry = registryService.getGovernanceSystemRegistry(CarbonContext.getCurrentContext().getTenantId() <= 0 ? -1234 : CarbonContext.getCurrentContext().getTenantId());
            String subscriptionsID = CommonsUtil.getSubscriptonsID(topic);
            if (registry.resourceExists(subscriptionsID)) {
                Collection subscriptionCollection = (Collection)registry.get(subscriptionsID);
                subscriptionDetailsArray = new SubscriptionDetails[subscriptionCollection.getChildCount()];
                int index = 0;
                for (String subs : subscriptionCollection.getChildren()) {
                    Collection subscription = (Collection)registry.get(subs);
                    SubscriptionDetails subscriptionDetails = new SubscriptionDetails();
                    subscriptionDetails.setName(subscription.getProperty(NAME));
                    subscriptionDetails.setOwner(subscription.getProperty(OWNER));
                    subscriptionDetails.setCreatedTime(subscription.getProperty(CREATED_TIME));
                    subscriptionDetailsArray[index++] = subscriptionDetails;
                }
            }
            return subscriptionDetailsArray;
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }
}

