/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.core.internal.registry;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.wso2.carbon.andes.core.QueueManagerException;
import org.wso2.carbon.andes.core.types.Queue;

public class QueueManagementBeans {
    public static QueueManagementBeans self;
    public static final String DIRECT_EXCHANGE = "amq.direct";

    public static QueueManagementBeans getInstance() {
        if (self == null) {
            self = new QueueManagementBeans();
        }
        return self;
    }

    public void createQueue(String queueName, String userName) throws QueueManagerException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=VirtualHost.VirtualHostManager,VirtualHost=\"carbon\"");
            String operationName = "createNewQueue";
            Object[] parameters = new Object[]{queueName, userName, true};
            String[] signature = new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName()};
            mBeanServer.invoke(objectName, operationName, parameters, signature);
            ObjectName bindingMBeanObjectName = new ObjectName("org.wso2.andes:type=VirtualHost.Exchange,VirtualHost=\"carbon\",name=\"amq.direct\",ExchangeType=direct");
            String bindingOperationName = "createNewBinding";
            Object[] bindingParams = new Object[]{queueName, queueName};
            String[] bpSignatures = new String[]{String.class.getName(), String.class.getName()};
            mBeanServer.invoke(bindingMBeanObjectName, bindingOperationName, bindingParams, bpSignatures);
        }
        catch (Exception e) {
            throw new QueueManagerException("Cannot create Queue : " + queueName, e);
        }
    }

    public ArrayList<Queue> getAllQueues() throws QueueManagerException {
        ArrayList<Queue> queueDetailsList = new ArrayList<Queue>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "AllQueueNames");
            if (result != null) {
                String[] queueNamesList;
                for (String queueName : queueNamesList = (String[])result) {
                    Queue queue = new Queue();
                    queue.setQueueName(queueName);
                    queue.setMessageCount(this.getMessageCount(queueName));
                    queueDetailsList.add(queue);
                }
            }
            return queueDetailsList;
        }
        catch (MalformedObjectNameException e) {
            throw new QueueManagerException("Cannot access topic subscriber information", e);
        }
        catch (ReflectionException e) {
            throw new QueueManagerException("Cannot access topic subscriber information", e);
        }
        catch (MBeanException e) {
            throw new QueueManagerException("Cannot access topic subscriber information", e);
        }
        catch (InstanceNotFoundException e) {
            throw new QueueManagerException("Cannot access topic subscriber information for node", e);
        }
        catch (AttributeNotFoundException e) {
            throw new QueueManagerException("Attribute not found", e);
        }
    }

    public int getMessageCount(String queueName) throws QueueManagerException {
        int messageCount = 0;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            String operationName = "getMessageCount";
            Object[] parameters = new Object[]{queueName};
            String[] signature = new String[]{String.class.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                messageCount = (Integer)result;
            }
            return messageCount;
        }
        catch (MalformedObjectNameException e) {
            throw new QueueManagerException("Cannot access topic subscriber information");
        }
        catch (ReflectionException e) {
            throw new QueueManagerException("Cannot access topic subscriber information");
        }
        catch (MBeanException e) {
            throw new QueueManagerException("Cannot access topic subscriber information");
        }
        catch (InstanceNotFoundException e) {
            throw new QueueManagerException("Cannot access topic subscriber information for node");
        }
    }

    public void deleteQueue(String queueName) throws QueueManagerException {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName bindingMBeanObjectName = new ObjectName("org.wso2.andes:type=VirtualHost.Exchange,VirtualHost=\"carbon\",name=\"amq.direct\",ExchangeType=direct");
            String bindingOperationName = "removeBinding";
            Object[] bindingParams = new Object[]{queueName, queueName};
            String[] bpSignatures = new String[]{String.class.getName(), String.class.getName()};
            mBeanServer.invoke(bindingMBeanObjectName, bindingOperationName, bindingParams, bpSignatures);
            ObjectName objectName = new ObjectName("org.wso2.andes:type=VirtualHost.VirtualHostManager,VirtualHost=\"carbon\"");
            String operationName = "deleteQueue";
            Object[] parameters = new Object[]{queueName};
            String[] signature = new String[]{String.class.getName()};
            mBeanServer.invoke(objectName, operationName, parameters, signature);
        }
        catch (MalformedObjectNameException e) {
            throw new QueueManagerException("Cannot delete Queue : " + queueName, e);
        }
        catch (InstanceNotFoundException e) {
            throw new QueueManagerException("Cannot delete Queue : " + queueName, e);
        }
        catch (MBeanException e) {
            throw new QueueManagerException("Cannot delete Queue : " + queueName, e);
        }
        catch (JMException e) {
            throw new QueueManagerException("Cannot delete Queue : " + queueName, e);
        }
    }

    public static boolean queueExists(String queueName) throws QueueManagerException {
        try {
            boolean status = false;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "isQueueExists";
            Object[] parameters = new Object[]{queueName};
            String[] signature = new String[]{String.class.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                status = (Boolean)result;
            }
            return status;
        }
        catch (MalformedObjectNameException e) {
            throw new QueueManagerException(e);
        }
        catch (JMException e) {
            throw new QueueManagerException(e);
        }
    }
}

