/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.tools.messagestore.commands;

import java.util.List;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.tools.messagestore.MessageStoreTool;
import org.wso2.andes.tools.messagestore.commands.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Purge
extends Move {
    public Purge(MessageStoreTool tool) {
        super(tool);
    }

    @Override
    public String help() {
        return "Purge messages from a queue.\nThe currently selected message set will be purged from the specifed queue.\nAlternatively the values can be provided on the command line.";
    }

    @Override
    public String usage() {
        return "purge from=<queue> [msgids=<msgids eg, 1,2,4-10>]";
    }

    @Override
    public String getCommand() {
        return "purge";
    }

    @Override
    protected boolean checkRequirements(AMQQueue fromQueue, AMQQueue toQueue, List<Long> msgids) {
        if (fromQueue == null) {
            this._console.println("Source queue not specifed.");
            this._console.println(this.usage());
            return false;
        }
        return true;
    }

    @Override
    protected void doCommand(AMQQueue fromQueue, long start, long end, AMQQueue toQueue) {
        fromQueue.removeMessagesFromQueue(start, end);
    }
}

