/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.virtualhost.plugins.policies;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.policies.SlowConsumerPolicyPlugin;
import org.wso2.andes.policies.SlowConsumerPolicyPluginFactory;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.configuration.plugins.ConfigurationPlugin;
import org.wso2.andes.server.exchange.TopicExchange;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.virtualhost.plugins.logging.TopicDeletePolicyMessages;
import org.wso2.andes.server.virtualhost.plugins.policies.TopicDeletePolicyConfiguration;

public class TopicDeletePolicy
implements SlowConsumerPolicyPlugin {
    Logger _logger = Logger.getLogger(TopicDeletePolicy.class);
    private TopicDeletePolicyConfiguration _configuration;

    public void performPolicy(AMQQueue q) {
        if (q == null) {
            return;
        }
        AMQSessionModel owner = q.getExclusiveOwningSession();
        if (owner == null) {
            return;
        }
        if (!this.validateQueueIsATopic(q)) {
            return;
        }
        try {
            CurrentActor.get().message(owner.getLogSubject(), TopicDeletePolicyMessages.DISCONNECTING());
            owner.getConnectionModel().closeSession(owner, AMQConstant.RESOURCE_ERROR, "Consuming to slow.");
            if (!q.isAutoDelete() && this._configuration != null && this._configuration.deletePersistent()) {
                CurrentActor.get().message(q.getLogSubject(), TopicDeletePolicyMessages.DELETING_QUEUE());
                q.delete();
            }
        }
        catch (AMQException e) {
            this._logger.warn((Object)("Unable to close consumer:" + owner + ", on queue:" + q.getName()));
        }
    }

    private boolean validateQueueIsATopic(AMQQueue q) {
        for (Binding binding : q.getBindings()) {
            if (!(binding.getExchange() instanceof TopicExchange)) continue;
            return true;
        }
        return false;
    }

    public void configure(ConfigurationPlugin config) {
        this._configuration = (TopicDeletePolicyConfiguration)config;
    }

    public String toString() {
        return "TopicDelete" + (this._configuration == null ? "" : "[" + this._configuration + "]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopicDeletePolicyFactory
    implements SlowConsumerPolicyPluginFactory {
        @Override
        public TopicDeletePolicy newInstance(ConfigurationPlugin configuration) throws ConfigurationException {
            TopicDeletePolicyConfiguration config = (TopicDeletePolicyConfiguration)configuration.getConfiguration(TopicDeletePolicyConfiguration.class.getName());
            TopicDeletePolicy policy = new TopicDeletePolicy();
            policy.configure(config);
            return policy;
        }

        @Override
        public String getPluginName() {
            return "topicdelete";
        }

        @Override
        public Class<TopicDeletePolicy> getPluginClass() {
            return TopicDeletePolicy.class;
        }
    }
}

