/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.virtualhost;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.binding.BindingFactory;
import org.wso2.andes.server.cluster.coordination.SubscriptionListener;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.AMQQueueFactory;
import org.wso2.andes.server.store.ConfigurationRecoveryHandler;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class VirtualHostConfigSynchronizer
implements ConfigurationRecoveryHandler.QueueRecoveryHandler,
ConfigurationRecoveryHandler.ExchangeRecoveryHandler,
ConfigurationRecoveryHandler.BindingRecoveryHandler,
SubscriptionListener {
    private final VirtualHost _virtualHost;
    private static final Logger _logger = Logger.getLogger(VirtualHostConfigSynchronizer.class);
    private int _syncInterval;
    private boolean running = false;
    private static Log log = LogFactory.getLog(VirtualHostConfigSynchronizer.class);

    public VirtualHostConfigSynchronizer(VirtualHost _virtualHost, int synchInterval) {
        this._virtualHost = _virtualHost;
        this._syncInterval = synchInterval;
    }

    public void binding(String exchangeName, String queueName, String bindingKey, java.nio.ByteBuffer buf) {
        try {
            Exchange exchange = this._virtualHost.getExchangeRegistry().getExchange(exchangeName);
            if (exchange == null) {
                _logger.error((Object)("Unknown exchange: " + exchangeName + ", cannot bind queue : " + queueName));
                return;
            }
            AMQQueue queue = this._virtualHost.getQueueRegistry().getQueue(new AMQShortString(queueName));
            if (queue == null) {
                _logger.error((Object)("Unknown queue: " + queueName + ", cannot be bound to exchange: " + exchangeName));
            } else {
                Map<String, Object> argumentMap;
                BindingFactory bf;
                FieldTable argumentsFT = null;
                if (buf != null) {
                    argumentsFT = new FieldTable(ByteBuffer.wrap(buf), buf.limit());
                }
                if ((bf = this._virtualHost.getBindingFactory()).getBinding(bindingKey, queue, exchange, argumentMap = FieldTable.convertToMap(argumentsFT)) == null) {
                    _logger.info((Object)("Restoring binding: (Exchange: " + exchange.getNameShortString() + ", Queue: " + queueName + ", Routing Key: " + bindingKey + ", Arguments: " + argumentsFT + ")"));
                    bf.restoreBinding(bindingKey, queue, exchange, argumentMap);
                }
            }
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    public void completeBindingRecovery() {
    }

    public void exchange(String exchangeName, String type, boolean autoDelete) {
        try {
            AMQShortString exchangeNameSS = new AMQShortString(exchangeName);
            Exchange exchange = this._virtualHost.getExchangeRegistry().getExchange(exchangeNameSS);
            if (exchange == null) {
                exchange = this._virtualHost.getExchangeFactory().createExchange(exchangeNameSS, new AMQShortString(type), true, autoDelete, 0);
                this._virtualHost.getExchangeRegistry().registerExchange(exchange);
            }
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationRecoveryHandler.BindingRecoveryHandler completeExchangeRecovery() {
        return null;
    }

    public void queue(String queueName, String owner, boolean exclusive, FieldTable arguments) {
        try {
            AMQShortString queueNameShortString = new AMQShortString(queueName);
            AMQQueue q = this._virtualHost.getQueueRegistry().getQueue(queueNameShortString);
            if (q == null) {
                q = AMQQueueFactory.createAMQQueueImpl(queueNameShortString, true, owner == null ? null : new AMQShortString(owner), false, exclusive, this._virtualHost, arguments);
                this._virtualHost.getQueueRegistry().registerQueue(q);
            }
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationRecoveryHandler.ExchangeRecoveryHandler completeQueueRecovery() {
        return null;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            Thread t = new Thread(new VirtualHostConfigSynchronizingTask(this));
            t.setName(this.getClass().getSimpleName());
            t.start();
        }
    }

    public void subscriptionsChanged() {
        if (ClusterResourceHolder.getInstance().getCassandraMessageStore() != null && ClusterResourceHolder.getInstance().getCassandraMessageStore().isConfigured()) {
            try {
                ClusterResourceHolder.getInstance().getCassandraMessageStore().synchExchanges(this);
                ClusterResourceHolder.getInstance().getCassandraMessageStore().synchQueues(this);
                ClusterResourceHolder.getInstance().getCassandraMessageStore().synchBindings(this);
            }
            catch (Exception e) {
                log.error((Object)"Error while syncing Virtual host details ");
            }
        }
    }

    private class VirtualHostConfigSynchronizingTask
    implements Runnable {
        private VirtualHostConfigSynchronizer syc;

        public VirtualHostConfigSynchronizingTask(VirtualHostConfigSynchronizer synchronizer) {
            this.syc = synchronizer;
        }

        public void run() {
            while (VirtualHostConfigSynchronizer.this.running) {
                try {
                    if (ClusterResourceHolder.getInstance().getCassandraMessageStore() != null && ClusterResourceHolder.getInstance().getCassandraMessageStore().isConfigured()) {
                        ClusterResourceHolder.getInstance().getCassandraMessageStore().synchExchanges(this.syc);
                        ClusterResourceHolder.getInstance().getCassandraMessageStore().synchQueues(this.syc);
                        ClusterResourceHolder.getInstance().getCassandraMessageStore().synchBindings(this.syc);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while syncing Virtual host details ");
                }
                try {
                    Thread.sleep(VirtualHostConfigSynchronizer.this._syncInterval * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

