/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.txn;

import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.server.message.EnqueableMessage;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.store.TransactionLog;
import org.wso2.andes.server.txn.ServerTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCommitTransaction
implements ServerTransaction {
    protected static final Logger _logger = Logger.getLogger(AutoCommitTransaction.class);
    private final TransactionLog _transactionLog;

    public AutoCommitTransaction(TransactionLog transactionLog) {
        this._transactionLog = transactionLog;
    }

    @Override
    public long getTransactionStartTime() {
        return 0L;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action immediateAction) {
        immediateAction.postCommit();
    }

    @Override
    public void dequeue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        TransactionLog.Transaction txn = null;
        try {
            if (message.isPersistent() && queue.isDurable()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString()));
                }
                txn = this._transactionLog.newTransaction();
                txn.dequeueMessage(queue, message.getMessageNumber());
                txn.commitTran();
                txn = null;
            }
            postTransactionAction.postCommit();
            postTransactionAction = null;
        }
        catch (AMQException e) {
            _logger.error((Object)"Error during message dequeue", (Throwable)e);
            throw new RuntimeException("Error during message dequeue", e);
        }
        finally {
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
    }

    @Override
    public void dequeue(Collection<QueueEntry> queueEntries, ServerTransaction.Action postTransactionAction) {
        TransactionLog.Transaction txn = null;
        try {
            for (QueueEntry entry : queueEntries) {
                ServerMessage message = entry.getMessage();
                AMQQueue queue = entry.getQueue();
                if (!message.isPersistent() || !queue.isDurable()) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString()));
                }
                if (txn == null) {
                    txn = this._transactionLog.newTransaction();
                }
                txn.dequeueMessage(queue, message.getMessageNumber());
            }
            if (txn != null) {
                txn.commitTran();
                txn = null;
            }
            postTransactionAction.postCommit();
            postTransactionAction = null;
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
        catch (AMQException e) {
            try {
                _logger.error((Object)"Error during message dequeues", (Throwable)e);
                throw new RuntimeException("Error during message dequeues", e);
            }
            catch (Throwable throwable) {
                this.rollbackIfNecessary(postTransactionAction, txn);
                throw throwable;
            }
        }
    }

    @Override
    public void enqueue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        TransactionLog.Transaction txn = null;
        try {
            if (message.isPersistent() && queue.isDurable()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + queue.getNameShortString()));
                }
                txn = this._transactionLog.newTransaction();
                txn.enqueueMessage(queue, message.getMessageNumber());
                txn.commitTran();
                txn = null;
            }
            postTransactionAction.postCommit();
            postTransactionAction = null;
        }
        catch (AMQException e) {
            _logger.error((Object)"Error during message enqueue", (Throwable)e);
            throw new RuntimeException("Error during message enqueue", e);
        }
        finally {
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
    }

    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        TransactionLog.Transaction txn = null;
        try {
            if (message.isPersistent()) {
                Long id = message.getMessageNumber();
                for (BaseQueue baseQueue : queues) {
                    if (!baseQueue.isDurable()) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + baseQueue.getNameShortString()));
                    }
                    if (txn == null) {
                        txn = this._transactionLog.newTransaction();
                    }
                    txn.enqueueMessage(baseQueue, id);
                }
                if (txn != null) {
                    txn.commitTran();
                    txn = null;
                }
            }
            postTransactionAction.postCommit();
            postTransactionAction = null;
        }
        catch (AMQException e) {
            _logger.error((Object)"Error during message enqueues", (Throwable)e);
            throw new RuntimeException("Error during message enqueues", e);
        }
        finally {
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    private void rollbackIfNecessary(ServerTransaction.Action postTransactionAction, TransactionLog.Transaction txn) {
        if (txn != null) {
            try {
                txn.abortTran();
            }
            catch (AMQStoreException e) {
                _logger.error((Object)"Abort transaction failed", (Throwable)e);
            }
        }
        if (postTransactionAction != null) {
            postTransactionAction.onRollback();
        }
    }
}

