/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.subscription;

import org.apache.log4j.Logger;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.subscription.Subscription_0_10;
import org.wso2.andes.server.transport.ServerSession;

class ImplicitAcceptDispositionChangeListener
implements ServerSession.MessageDispositionChangeListener {
    private static final Logger _logger = Logger.getLogger(ImplicitAcceptDispositionChangeListener.class);
    private final QueueEntry _entry;
    private Subscription_0_10 _sub;

    public ImplicitAcceptDispositionChangeListener(QueueEntry entry, Subscription_0_10 subscription_0_10) {
        this._entry = entry;
        this._sub = subscription_0_10;
    }

    public void onAccept() {
        _logger.warn((Object)"MessageAccept received for message which is using NONE as the accept mode (likely client error)");
    }

    public void onRelease() {
        if (this._entry.isAcquiredBy(this._sub)) {
            this.getSubscription().release(this._entry);
        } else {
            _logger.warn((Object)"MessageRelease received for message which has not been acquired (likely client error)");
        }
    }

    public void onReject() {
        if (this._entry.isAcquiredBy(this._sub)) {
            this.getSubscription().reject(this._entry);
        } else {
            _logger.warn((Object)"MessageReject received for message which has not been acquired (likely client error)");
        }
    }

    public boolean acquire() {
        boolean acquired = this._entry.acquire(this.getSubscription());
        return acquired;
    }

    public Subscription_0_10 getSubscription() {
        return this._sub;
    }
}

