/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.registry;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.andes.common.QpidProperties;
import org.wso2.andes.server.configuration.BrokerConfig;
import org.wso2.andes.server.configuration.BrokerConfigType;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.SystemConfig;
import org.wso2.andes.server.configuration.VirtualHostConfig;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class BrokerConfigAdapter
implements BrokerConfig {
    private final IApplicationRegistry _instance;
    private SystemConfig _system;
    private final Map<UUID, VirtualHostConfig> _vhosts = new ConcurrentHashMap<UUID, VirtualHostConfig>();
    private final long _createTime = System.currentTimeMillis();
    private UUID _id;
    private String _federationTag;

    public BrokerConfigAdapter(IApplicationRegistry instance) {
        this._instance = instance;
        this._id = instance.getConfigStore().createId();
        this._federationTag = UUID.randomUUID().toString();
    }

    public void setSystem(SystemConfig system) {
        this._system = system;
    }

    public SystemConfig getSystem() {
        return this._system;
    }

    public Integer getPort() {
        List ports = this._instance.getConfiguration().getPorts();
        if (ports.size() > 0) {
            return Integer.valueOf(ports.get(0).toString());
        }
        return 0;
    }

    public Integer getWorkerThreads() {
        return this._instance.getConfiguration().getConnectorProcessors();
    }

    public Integer getMaxConnections() {
        return 0;
    }

    public Integer getConnectionBacklogLimit() {
        return 0;
    }

    public Long getStagingThreshold() {
        return 0L;
    }

    public Integer getManagementPublishInterval() {
        return 10000;
    }

    public String getVersion() {
        return QpidProperties.getReleaseVersion() + " [Build: " + QpidProperties.getBuildVersion() + "]";
    }

    public String getDataDirectory() {
        return this._instance.getConfiguration().getQpidWork();
    }

    public void addVirtualHost(VirtualHostConfig virtualHost) {
        virtualHost.setBroker(this);
        this._vhosts.put(virtualHost.getId(), virtualHost);
        this.getConfigStore().addConfiguredObject(virtualHost);
    }

    private ConfigStore getConfigStore() {
        return this._instance.getConfigStore();
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public void createBrokerConnection(String transport, String host, int port, boolean durable, String authMechanism, String username, String password) {
        VirtualHost vhost = this._instance.getVirtualHostRegistry().getDefaultVirtualHost();
        vhost.createBrokerConnection(transport, host, port, "", durable, authMechanism, username, password);
    }

    public UUID getId() {
        return this._id;
    }

    public BrokerConfigType getConfigType() {
        return BrokerConfigType.getInstance();
    }

    public ConfiguredObject getParent() {
        return this._system;
    }

    public boolean isDurable() {
        return false;
    }

    public String getFederationTag() {
        return this._federationTag;
    }
}

