/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.QueueEntryImpl;
import org.wso2.andes.server.queue.QueueEntryIterator;
import org.wso2.andes.server.queue.QueueEntryList;
import org.wso2.andes.server.queue.QueueEntryListFactory;

public class SimpleQueueEntryList
implements QueueEntryList {
    private final QueueEntryImpl _head;
    private volatile QueueEntryImpl _tail;
    static final AtomicReferenceFieldUpdater<SimpleQueueEntryList, QueueEntryImpl> _tailUpdater = AtomicReferenceFieldUpdater.newUpdater(SimpleQueueEntryList.class, QueueEntryImpl.class, "_tail");
    private final AMQQueue _queue;
    static final AtomicReferenceFieldUpdater<QueueEntryImpl, QueueEntryImpl> _nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, QueueEntryImpl.class, "_next");
    private AtomicLong _scavenges = new AtomicLong(0L);
    private final long _scavengeCount = Integer.getInteger("qpid.queue.scavenge_count", 50).intValue();

    public SimpleQueueEntryList(AMQQueue queue) {
        this._queue = queue;
        this._tail = this._head = new QueueEntryImpl(this);
    }

    void advanceHead() {
        QueueEntryImpl newNext;
        QueueEntryImpl next = this._head.nextNode();
        if (next == (newNext = this._head.getNext()) && this._scavenges.incrementAndGet() > this._scavengeCount) {
            this._scavenges.set(0L);
            this.scavenge();
        }
    }

    void scavenge() {
        for (QueueEntryImpl next = this._head.getNext(); next != null; next = next.getNext()) {
        }
    }

    public AMQQueue getQueue() {
        return this._queue;
    }

    public QueueEntry add(ServerMessage message) {
        QueueEntryImpl node = this.createQueueEntry(message);
        while (true) {
            QueueEntryImpl tail = this._tail;
            QueueEntryImpl next = tail.nextNode();
            if (tail != this._tail) continue;
            if (next == null) {
                node.setEntryId(tail.getEntryId() + 1L);
                if (!_nextUpdater.compareAndSet(tail, null, node)) continue;
                _tailUpdater.compareAndSet(this, tail, node);
                return node;
            }
            _tailUpdater.compareAndSet(this, tail, next);
        }
    }

    protected QueueEntryImpl createQueueEntry(ServerMessage message) {
        return new QueueEntryImpl(this, message);
    }

    public QueueEntry next(QueueEntry node) {
        return ((QueueEntryImpl)node).getNext();
    }

    public QueueEntryIterator iterator() {
        return new QueueEntryIteratorImpl(this._head);
    }

    public QueueEntry getHead() {
        return this._head;
    }

    static class Factory
    implements QueueEntryListFactory {
        Factory() {
        }

        public QueueEntryList createQueueEntryList(AMQQueue queue) {
            return new SimpleQueueEntryList(queue);
        }
    }

    public static class QueueEntryIteratorImpl
    implements QueueEntryIterator {
        private QueueEntryImpl _lastNode;

        QueueEntryIteratorImpl(QueueEntryImpl startNode) {
            this._lastNode = startNode;
        }

        public boolean atTail() {
            return this._lastNode.nextNode() == null;
        }

        public QueueEntry getNode() {
            return this._lastNode;
        }

        public boolean advance() {
            if (!this.atTail()) {
                QueueEntryImpl nextNode = this._lastNode.nextNode();
                while (nextNode.isDispensed() && nextNode.nextNode() != null) {
                    nextNode = nextNode.nextNode();
                }
                this._lastNode = nextNode;
                return true;
            }
            return false;
        }
    }
}

