/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.util.Map;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.server.queue.PriorityQueueList;
import org.wso2.andes.server.queue.QueueContext;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.QueueEntryListFactory;
import org.wso2.andes.server.queue.SimpleAMQQueue;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionList;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQPriorityQueue
extends SimpleAMQQueue {
    protected AMQPriorityQueue(AMQShortString name, boolean durable, AMQShortString owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, int priorities, Map<String, Object> arguments) {
        super(name, durable, owner, autoDelete, exclusive, virtualHost, (QueueEntryListFactory)new PriorityQueueList.Factory(priorities), arguments);
    }

    public AMQPriorityQueue(String queueName, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, int priorities, Map<String, Object> arguments) {
        this(queueName == null ? null : new AMQShortString(queueName), durable, owner == null ? null : new AMQShortString(owner), autoDelete, exclusive, virtualHost, priorities, arguments);
    }

    public int getPriorities() {
        return ((PriorityQueueList)this._entries).getPriorities();
    }

    @Override
    protected void checkSubscriptionsNotAheadOfDelivery(QueueEntry entry) {
        SubscriptionList.SubscriptionNodeIterator subIter = this._subscriptionList.iterator();
        while (subIter.advance() && entry.isAvailable()) {
            QueueContext context;
            Subscription subscription = subIter.getNode().getSubscription();
            if (subscription.isClosed() || (context = (QueueContext)subscription.getQueueContext()) == null) continue;
            QueueEntry subnode = context._lastSeenEntry;
            QueueEntry released = context._releasedEntry;
            while (subnode != null && entry.compareTo(subnode) < 0 && entry.isAvailable() && (released == null || released.compareTo(entry) < 0) && !QueueContext._releasedUpdater.compareAndSet(context, released, entry)) {
                subnode = context._lastSeenEntry;
                released = context._releasedEntry;
            }
        }
    }
}

