/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.protocol;

import java.util.EnumSet;
import java.util.Set;
import org.wso2.andes.protocol.ProtocolEngine;
import org.wso2.andes.protocol.ProtocolEngineFactory;
import org.wso2.andes.server.protocol.AmqpProtocolVersion;
import org.wso2.andes.server.protocol.MultiVersionProtocolEngine;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.transport.network.NetworkConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionProtocolEngineFactory
implements ProtocolEngineFactory {
    private static final Set<AmqpProtocolVersion> ALL_VERSIONS = EnumSet.allOf(AmqpProtocolVersion.class);
    private final IApplicationRegistry _appRegistry = ApplicationRegistry.getInstance();
    private final String _fqdn;
    private final Set<AmqpProtocolVersion> _supported;

    public MultiVersionProtocolEngineFactory() {
        this(1, "localhost", ALL_VERSIONS);
    }

    public MultiVersionProtocolEngineFactory(String fqdn, Set<AmqpProtocolVersion> versions) {
        this(1, fqdn, versions);
    }

    public MultiVersionProtocolEngineFactory(String fqdn) {
        this(1, fqdn, ALL_VERSIONS);
    }

    public MultiVersionProtocolEngineFactory(int instance, String fqdn, Set<AmqpProtocolVersion> supportedVersions) {
        this._fqdn = fqdn;
        this._supported = supportedVersions;
    }

    @Override
    public ProtocolEngine newProtocolEngine(NetworkConnection network) {
        return new MultiVersionProtocolEngine(this._appRegistry, this._fqdn, this._supported, network);
    }
}

