/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.information.management;

import java.util.List;
import javax.management.NotCompliantMBeanException;
import org.wso2.andes.management.common.mbeans.QueueManagementInformation;
import org.wso2.andes.management.common.mbeans.annotations.MBeanOperationParameter;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.cluster.GlobalQueueManager;
import org.wso2.andes.server.management.AMQManagedObject;
import org.wso2.andes.server.store.CassandraMessageStore;

public class QueueManagementInformationMBean
extends AMQManagedObject
implements QueueManagementInformation {
    GlobalQueueManager globalQueueManager;
    CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();

    public QueueManagementInformationMBean() throws NotCompliantMBeanException {
        super(QueueManagementInformation.class, "QueueManagementInformation");
        this.globalQueueManager = new GlobalQueueManager(this.messageStore);
    }

    public String getObjectInstanceName() {
        return "QueueManagementInformation";
    }

    public String[] getAllQueueNames() {
        try {
            List<String> queuesList = this.messageStore.getGlobalQueues();
            String[] queues = new String[queuesList.size()];
            queuesList.toArray(queues);
            return queues;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in accessing global queues", e);
        }
    }

    public boolean isQueueExists(String queueName) {
        try {
            List<String> queuesList = this.messageStore.getGlobalQueues();
            return queuesList.contains(queueName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in accessing global queues", e);
        }
    }

    public void deleteQueue(@MBeanOperationParameter(name="queueName", description="Name of the queue to be deleted") String queueName) {
        ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
        CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        try {
            messageStore.removeGlobalQueue(queueName);
            clusterManager.handleQueueRemoval(queueName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getMessageCount(String queueName) {
        return this.globalQueueManager.getMessageCount(queueName);
    }

    public int getSubscriptionCount(String queueName) {
        try {
            return this.globalQueueManager.getSubscriberCount(queueName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in getting subscriber count", e);
        }
    }
}

