/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.BasicAckBody;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAckMethodHandler
implements StateAwareMethodListener<BasicAckBody> {
    private static final Logger _log = Logger.getLogger(BasicAckMethodHandler.class);
    private static final BasicAckMethodHandler _instance = new BasicAckMethodHandler();

    public static BasicAckMethodHandler getInstance() {
        return _instance;
    }

    private BasicAckMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicAckBody body, int channelId) throws AMQException {
        AMQChannel channel;
        AMQProtocolSession protocolSession = stateManager.getProtocolSession();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Ack(Tag:" + body.getDeliveryTag() + ":Mult:" + body.getMultiple() + ") received on channel " + channelId));
        }
        if ((channel = protocolSession.getChannel(channelId)) == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.acknowledgeMessage(body.getDeliveryTag(), body.getMultiple());
    }
}

