/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.filter;

import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.common.AMQPFilterTypes;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.filter.FilterManager;
import org.wso2.andes.server.filter.JMSSelectorFilter;
import org.wso2.andes.server.filter.SimpleFilterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterManagerFactory {
    private static final Logger _logger = Logger.getLogger(FilterManagerFactory.class);

    public static FilterManager createManager(FieldTable filters) throws AMQException {
        SimpleFilterManager manager = null;
        if (filters != null) {
            String selector;
            if (filters.containsKey(AMQPFilterTypes.JMS_SELECTOR.getValue()) && (selector = filters.getString(AMQPFilterTypes.JMS_SELECTOR.getValue())) != null && !selector.equals("")) {
                manager = new SimpleFilterManager();
                manager.add(new JMSSelectorFilter(selector));
            }
        } else {
            _logger.debug((Object)"No Filters found.");
        }
        return manager;
    }

    public static FilterManager createManager(Map<String, Object> map) throws AMQException {
        return FilterManagerFactory.createManager(FieldTable.convertToFieldTable(map));
    }
}

