/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange.topic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.AMQShortStringTokenizer;
import org.wso2.andes.server.exchange.topic.TopicMatcherDFAState;
import org.wso2.andes.server.exchange.topic.TopicMatcherResult;
import org.wso2.andes.server.exchange.topic.TopicWord;
import org.wso2.andes.server.exchange.topic.TopicWordDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicParser {
    private static final byte TOPIC_DELIMITER = 46;
    private final TopicWordDictionary _dictionary = new TopicWordDictionary();
    private final AtomicReference<TopicMatcherDFAState> _stateMachine = new AtomicReference();
    private static final Position ERROR_POSITION = new Position(Integer.MAX_VALUE, null, true, false);

    public void addBinding(AMQShortString bindingKey, TopicMatcherResult result) {
        TopicMatcherDFAState newStateMachine;
        TopicMatcherDFAState startingStateMachine;
        while (!this._stateMachine.compareAndSet(startingStateMachine, newStateMachine = (startingStateMachine = this._stateMachine.get()) == null ? this.createStateMachine(bindingKey, result) : startingStateMachine.mergeStateMachines(this.createStateMachine(bindingKey, result)))) {
        }
    }

    public Collection<TopicMatcherResult> parse(AMQShortString routingKey) {
        TopicMatcherDFAState stateMachine = this._stateMachine.get();
        if (stateMachine == null) {
            return Collections.EMPTY_SET;
        }
        return stateMachine.parse(this._dictionary, routingKey);
    }

    TopicMatcherDFAState createStateMachine(AMQShortString bindingKey, TopicMatcherResult result) {
        int i;
        int lastWord;
        List<TopicWord> wordList = this.createTopicWordList(bindingKey);
        int wildCards = 0;
        for (TopicWord word : wordList) {
            if (word != TopicWord.WILDCARD_WORD) continue;
            ++wildCards;
        }
        if (wildCards == 0) {
            TopicMatcherDFAState[] states = new TopicMatcherDFAState[wordList.size() + 1];
            states[states.length - 1] = new TopicMatcherDFAState(Collections.EMPTY_MAP, Collections.singleton(result));
            for (int i2 = states.length - 2; i2 >= 0; --i2) {
                states[i2] = new TopicMatcherDFAState(Collections.singletonMap(wordList.get(i2), states[i2 + 1]), Collections.EMPTY_SET);
            }
            return states[0];
        }
        if (wildCards == wordList.size()) {
            HashMap<TopicWord, TopicMatcherDFAState> stateMap = new HashMap<TopicWord, TopicMatcherDFAState>();
            TopicMatcherDFAState state = new TopicMatcherDFAState(stateMap, Collections.singleton(result));
            stateMap.put(TopicWord.ANY_WORD, state);
            return state;
        }
        int positionCount = wordList.size() - wildCards;
        Position[] positions = new Position[positionCount + 1];
        if (wordList.get(wordList.size() - 1) == TopicWord.WILDCARD_WORD) {
            lastWord = wordList.size() - 1;
            positions[positionCount] = new Position(positionCount, TopicWord.ANY_WORD, true, true);
        } else {
            lastWord = wordList.size();
            positions[positionCount] = new Position(positionCount, TopicWord.ANY_WORD, false, true);
        }
        int pos = 0;
        int wordPos = 0;
        while (wordPos < lastWord) {
            TopicWord word;
            if ((word = wordList.get(wordPos++)) == TopicWord.WILDCARD_WORD) {
                int nextWordPos = wordPos++;
                word = wordList.get(nextWordPos);
                positions[pos] = new Position(pos++, word, true, false);
                continue;
            }
            positions[pos] = new Position(pos++, word, false, false);
        }
        for (int p = 0; p < positionCount; ++p) {
            int n;
            boolean followedByWildcards = true;
            for (n = p; followedByWildcards && n < positionCount + 1 && !positions[n]._selfTransition; ++n) {
                if (positions[n]._word == TopicWord.ANY_WORD) continue;
                followedByWildcards = false;
            }
            positions[p]._followedByAnyLoop = followedByWildcards && n != positionCount + 1;
        }
        HashMap<Set<Position>, SimpleState> stateMap = new HashMap<Set<Position>, SimpleState>();
        SimpleState state = new SimpleState();
        state._positions = Collections.singleton(positions[0]);
        stateMap.put(state._positions, state);
        this.calculateNextStates(state, stateMap, positions);
        SimpleState[] simpleStates = stateMap.values().toArray(new SimpleState[stateMap.size()]);
        HashMap[] dfaStateMaps = new HashMap[simpleStates.length];
        HashMap<SimpleState, TopicMatcherDFAState> simple2DFAMap = new HashMap<SimpleState, TopicMatcherDFAState>();
        for (i = 0; i < simpleStates.length; ++i) {
            boolean endState = false;
            for (Position position : simpleStates[i]._positions) {
                if (!position._endState) continue;
                endState = true;
                break;
            }
            Set<TopicMatcherResult> results = endState ? Collections.singleton(result) : Collections.EMPTY_SET;
            dfaStateMaps[i] = new HashMap();
            simple2DFAMap.put(simpleStates[i], new TopicMatcherDFAState(dfaStateMaps[i], results));
        }
        for (i = 0; i < simpleStates.length; ++i) {
            SimpleState simpleState = simpleStates[i];
            Map<TopicWord, SimpleState> nextSimpleStateMap = simpleState._nextState;
            for (Map.Entry entry : nextSimpleStateMap.entrySet()) {
                dfaStateMaps[i].put(entry.getKey(), simple2DFAMap.get(entry.getValue()));
            }
        }
        return (TopicMatcherDFAState)simple2DFAMap.get(state);
    }

    /*
     * WARNING - void declaration
     */
    private void calculateNextStates(SimpleState state, Map<Set<Position>, SimpleState> stateMap, Position[] positions) {
        HashMap transitions = new HashMap();
        for (Position pos : state._positions) {
            int n;
            if (pos._selfTransition) {
                void var7_10;
                Set set = (Set)transitions.get(TopicWord.ANY_WORD);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    transitions.put(TopicWord.ANY_WORD, hashSet);
                }
                var7_10.add(pos);
            }
            Position nextPosition = (n = pos._position + 1) == positions.length ? ERROR_POSITION : positions[n];
            HashSet<Position> dest = (HashSet<Position>)transitions.get(pos._word);
            if (dest == null) {
                dest = new HashSet<Position>();
                transitions.put(pos._word, dest);
            }
            dest.add(nextPosition);
        }
        Set anyWordTransitions = (Set)transitions.get(TopicWord.ANY_WORD);
        if (anyWordTransitions != null) {
            for (Set set : transitions.values()) {
                set.addAll(anyWordTransitions);
            }
        }
        state._nextState = new HashMap<TopicWord, SimpleState>();
        for (Map.Entry entry : transitions.entrySet()) {
            if (((Set)entry.getValue()).size() > 1) {
                ((Set)entry.getValue()).remove(ERROR_POSITION);
            }
            Position loopingTerminal = null;
            for (Position destPos : (Set)entry.getValue()) {
                if (!destPos._selfTransition || !destPos._endState) continue;
                loopingTerminal = destPos;
                break;
            }
            if (loopingTerminal != null) {
                entry.setValue(Collections.singleton(loopingTerminal));
            } else {
                Position anyLoop = null;
                for (Position destPos : (Set)entry.getValue()) {
                    if (!destPos._followedByAnyLoop || anyLoop != null && anyLoop._position >= destPos._position) continue;
                    anyLoop = destPos;
                }
                if (anyLoop != null) {
                    ArrayList<Position> removals = new ArrayList<Position>();
                    for (Position destPos : (Set)entry.getValue()) {
                        if (destPos._position >= anyLoop._position) continue;
                        removals.add(destPos);
                    }
                    ((Set)entry.getValue()).removeAll(removals);
                }
            }
            SimpleState stateForEntry = stateMap.get(entry.getValue());
            if (stateForEntry == null) {
                stateForEntry = new SimpleState();
                stateForEntry._positions = (Set)entry.getValue();
                stateMap.put((Set<Position>)entry.getValue(), stateForEntry);
                this.calculateNextStates(stateForEntry, stateMap, positions);
            }
            state._nextState.put((TopicWord)entry.getKey(), stateForEntry);
        }
        SimpleState anyWordState = state._nextState.get(TopicWord.ANY_WORD);
        if (anyWordState != null) {
            ArrayList<TopicWord> arrayList = new ArrayList<TopicWord>();
            for (Map.Entry<TopicWord, SimpleState> entry : state._nextState.entrySet()) {
                if (entry.getValue() != anyWordState || entry.getKey() == TopicWord.ANY_WORD) continue;
                arrayList.add(entry.getKey());
            }
            for (TopicWord removeKey : arrayList) {
                state._nextState.remove(removeKey);
            }
        }
    }

    private List<TopicWord> createTopicWordList(AMQShortString bindingKey) {
        AMQShortStringTokenizer tokens = bindingKey.tokenize((byte)46);
        TopicWord previousWord = null;
        ArrayList<TopicWord> wordList = new ArrayList<TopicWord>();
        while (tokens.hasMoreTokens()) {
            TopicWord nextWord = this._dictionary.getOrCreateWord(tokens.nextToken());
            if (previousWord == TopicWord.WILDCARD_WORD) {
                if (nextWord == TopicWord.WILDCARD_WORD) continue;
                if (nextWord == TopicWord.ANY_WORD) {
                    wordList.set(wordList.size() - 1, TopicWord.ANY_WORD);
                    nextWord = TopicWord.WILDCARD_WORD;
                }
            }
            wordList.add(nextWord);
            previousWord = nextWord;
        }
        return wordList;
    }

    public static void main(String[] args) {
        TopicParser.printMatches("#.b.*.*.*.*.*.h.#.j.*.*.*.*.*.*.q.#.r.*.*.*.*.*.*.*.*", "a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z");
        TopicParser.printMatches(new String[]{"#.a.#", "#.b.#", "#.c.#", "#.d.#", "#.e.#", "#.f.#", "#.g.#", "#.h.#", "#.i.#", "#.j.#", "#.k.#", "#.l.#", "#.m.#", "#.n.#", "#.o.#", "#.p.#", "#.q.#"}, "a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z");
        TopicParser.printMatches("", "");
        TopicParser.printMatches("a", "a");
        TopicParser.printMatches("a", "");
        TopicParser.printMatches("", "a");
        TopicParser.printMatches("a.b", "a.b");
        TopicParser.printMatches("a", "a.b");
        TopicParser.printMatches("a.b", "a");
        TopicParser.printMatches("*", "a");
        TopicParser.printMatches("*.b", "a.b");
        TopicParser.printMatches("*.*", "a.b");
        TopicParser.printMatches("a.*", "a.b");
        TopicParser.printMatches("a.*.#", "a.b");
        TopicParser.printMatches("a.#.b", "a.b");
        TopicParser.printMatches("#.b", "a");
        TopicParser.printMatches("#.b", "a.b");
        TopicParser.printMatches("#.a.b", "a.b");
        TopicParser.printMatches("#", "");
        TopicParser.printMatches("#", "a");
        TopicParser.printMatches("#", "a.b");
        TopicParser.printMatches("#.#", "a.b");
        TopicParser.printMatches("#.*", "a.b");
        TopicParser.printMatches("#.a.b", "a.b");
        TopicParser.printMatches("a.b.#", "a.b");
        TopicParser.printMatches("a.#", "a.b");
        TopicParser.printMatches("#.*.#", "a.b");
        TopicParser.printMatches("#.*.b.#", "a.b");
        TopicParser.printMatches("#.a.*.#", "a.b");
        TopicParser.printMatches("#.a.#.b.#", "a.b");
        TopicParser.printMatches("#.*.#.*.#", "a.b");
        TopicParser.printMatches("*.#.*.#", "a.b");
        TopicParser.printMatches("#.*.#.*", "a.b");
        TopicParser.printMatches(new String[]{"a.#.b.#", "a.*.#.b.#"}, "a.b.b.b.b.b.b.b.c");
        TopicParser.printMatches(new String[]{"a.b", "a.c"}, "a.b");
        TopicParser.printMatches(new String[]{"a.#", "a.c", "#.b"}, "a.b");
        TopicParser.printMatches(new String[]{"a.#", "a.c", "#.b", "#", "*.*"}, "a.b");
        TopicParser.printMatches(new String[]{"a.b.c.d.e.#", "a.b.c.d.#", "a.b.c.d.*", "a.b.c.#", "#.e", "a.*.c.d.e", "#.c.*.#.*.*"}, "a.b.c.d.e");
        TopicParser.printMatches(new String[]{"a.b.c.d.e.#", "a.b.c.d.#", "a.b.c.d.*", "a.b.c.#", "#.e", "a.*.c.d.e", "#.c.*.#.*.*"}, "a.b.c.d.f.g");
    }

    private static void printMatches(String[] bindingKeys, String routingKey) {
        TopicMatcherDFAState sm = null;
        HashMap<1, String> resultMap = new HashMap<1, String>();
        TopicParser parser = new TopicParser();
        long start = System.currentTimeMillis();
        for (int i = 0; i < bindingKeys.length; ++i) {
            System.out.println(System.currentTimeMillis() - start + ":\t" + bindingKeys[i]);
            TopicMatcherResult r = new TopicMatcherResult(){};
            resultMap.put(r, bindingKeys[i]);
            AMQShortString bindingKeyShortString = new AMQShortString(bindingKeys[i]);
            System.err.println("=====================================================");
            System.err.println("Adding binding key: " + bindingKeyShortString);
            System.err.println("-----------------------------------------------------");
            sm = i == 0 ? parser.createStateMachine(bindingKeyShortString, r) : sm.mergeStateMachines(parser.createStateMachine(bindingKeyShortString, r));
            System.err.println(sm.reachableStates());
            System.err.println("=====================================================");
            try {
                System.in.read();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        AMQShortString routingKeyShortString = new AMQShortString(routingKey);
        Collection<TopicMatcherResult> results = sm.parse(parser._dictionary, routingKeyShortString);
        ArrayList resultStrings = new ArrayList();
        for (TopicMatcherResult result : results) {
            resultStrings.add(resultMap.get(result));
        }
        ArrayList<String> nonMatches = new ArrayList<String>(Arrays.asList(bindingKeys));
        nonMatches.removeAll(resultStrings);
        System.out.println("\"" + routingKeyShortString + "\" matched with " + resultStrings + " DID NOT MATCH with " + nonMatches);
    }

    private static void printMatches(String bindingKey, String routingKey) {
        TopicParser.printMatches(new String[]{bindingKey}, routingKey);
    }

    private static boolean matches(String bindingKey, String routingKey) {
        AMQShortString bindingKeyShortString = new AMQShortString(bindingKey);
        AMQShortString routingKeyShortString = new AMQShortString(routingKey);
        TopicParser parser = new TopicParser();
        TopicMatcherResult result = new TopicMatcherResult(){};
        TopicMatcherDFAState sm = parser.createStateMachine(bindingKeyShortString, result);
        return !sm.parse(parser._dictionary, routingKeyShortString).isEmpty();
    }

    private static class SimpleState {
        Set<Position> _positions;
        Map<TopicWord, SimpleState> _nextState;

        private SimpleState() {
        }
    }

    private static class Position {
        private final TopicWord _word;
        private final boolean _selfTransition;
        private final int _position;
        private final boolean _endState;
        private boolean _followedByAnyLoop;

        public Position(int position, TopicWord word, boolean selfTransition, boolean endState) {
            this._position = position;
            this._word = word;
            this._selfTransition = selfTransition;
            this._endState = endState;
        }
    }
}

