/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import java.util.ArrayList;
import java.util.Map;
import javax.management.JMException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.wso2.andes.management.common.mbeans.annotations.MBeanConstructor;
import org.wso2.andes.management.common.mbeans.annotations.MBeanDescription;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.AbstractExchangeMBean;
import org.wso2.andes.server.exchange.HeadersExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBeanDescription(value="Management Bean for Headers Exchange")
final class HeadersExchangeMBean
extends AbstractExchangeMBean<HeadersExchange> {
    @MBeanConstructor(value="Creates an MBean for AMQ Headers exchange")
    public HeadersExchangeMBean(HeadersExchange headersExchange) throws JMException {
        super(headersExchange);
        this.init();
    }

    @Override
    protected void init() throws OpenDataException {
        this._bindingItemTypes = new OpenType[3];
        this._bindingItemTypes[0] = SimpleType.INTEGER;
        this._bindingItemTypes[1] = SimpleType.STRING;
        this._bindingItemTypes[2] = new ArrayType(1, SimpleType.STRING);
        this._bindingDataType = new CompositeType("Exchange Binding", "Queue name and header bindings", HEADERS_COMPOSITE_ITEM_NAMES.toArray(new String[HEADERS_COMPOSITE_ITEM_NAMES.size()]), HEADERS_COMPOSITE_ITEM_DESC.toArray(new String[HEADERS_COMPOSITE_ITEM_DESC.size()]), this._bindingItemTypes);
        this._bindinglistDataType = new TabularType("Exchange Bindings", "List of exchange bindings for " + this.getName(), this._bindingDataType, HEADERS_TABULAR_UNIQUE_INDEX.toArray(new String[HEADERS_TABULAR_UNIQUE_INDEX.size()]));
    }

    @Override
    public TabularData bindings() throws OpenDataException {
        TabularDataSupport bindingList = new TabularDataSupport(this._bindinglistDataType);
        int count = 1;
        for (Binding binding : ((HeadersExchange)this.getExchange()).getBindings()) {
            String queueName = binding.getQueue().getNameShortString().toString();
            Map<String, Object> headerMappings = binding.getArguments();
            ArrayList<String> mappingList = new ArrayList<String>();
            if (headerMappings != null) {
                for (Map.Entry<String, Object> entry : headerMappings.entrySet()) {
                    mappingList.add(entry.getKey() + "=" + entry.getValue());
                }
            }
            Object[] bindingItemValues = new Object[]{count++, queueName, mappingList.toArray(new String[0])};
            CompositeDataSupport bindingData = new CompositeDataSupport(this._bindingDataType, HEADERS_COMPOSITE_ITEM_NAMES.toArray(new String[HEADERS_COMPOSITE_ITEM_NAMES.size()]), bindingItemValues);
            bindingList.put(bindingData);
        }
        return bindingList;
    }
}

