/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.configuration;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.wso2.andes.server.configuration.VirtualHostConfiguration;
import org.wso2.andes.server.configuration.management.ConfigurationManagementMBean;
import org.wso2.andes.server.configuration.plugins.ConfigurationPlugin;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.server.virtualhost.VirtualHostRegistry;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ServerConfiguration
extends ConfigurationPlugin
implements SignalHandler {
    protected static final Logger _logger = Logger.getLogger(ServerConfiguration.class);
    public static final int DEFAULT_BUFFER_SIZE = 262144;
    public static final String DEFAULT_STATUS_UPDATES = "on";
    public static final String SECURITY_CONFIG_RELOADED = "SECURITY CONFIGURATION RELOADED";
    public static final int DEFAULT_FRAME_SIZE = 65536;
    public static final int DEFAULT_PORT = 5672;
    public static final int DEFAULT_SSL_PORT = 8672;
    public static final long DEFAULT_HOUSEKEEPING_PERIOD = 30000L;
    public static final int DEFAULT_JMXPORT = 8999;
    public static final String QPID_HOME = "QPID_HOME";
    public static final String QPID_WORK = "QPID_WORK";
    public static final String LIB_DIR = "lib";
    public static final String PLUGIN_DIR = "plugins";
    public static final String CACHE_DIR = "cache";
    private Map<String, VirtualHostConfiguration> _virtualHosts = new HashMap<String, VirtualHostConfiguration>();
    private File _configFile;
    private File _vhostsFile;
    private Logger _log = Logger.getLogger(this.getClass());
    private ConfigurationManagementMBean _mbean;
    private static final Map<String, String> envVarMap = new HashMap<String, String>();
    public static final String MGMT_CUSTOM_REGISTRY_SOCKET = "management.custom-registry-socket";
    public static final String STATUS_UPDATES = "status-updates";
    public static final String ADVANCED_LOCALE = "advanced.locale";

    public ServerConfiguration(File configurationURL) throws ConfigurationException {
        this(ServerConfiguration.parseConfig(configurationURL));
        this._configFile = configurationURL;
        try {
            Signal sig = new Signal("HUP");
            Signal.handle(sig, this);
        }
        catch (Exception e) {
            _logger.info((Object)("Signal HUP not supported for OS: " + System.getProperty("os.name")));
        }
    }

    public ServerConfiguration(Configuration conf) {
        envVarMap.put("QPID_ENABLEDIRECTBUFFERS", "advanced.enableDirectBuffers");
        envVarMap.put("QPID_SSLPORT", "connector.ssl.port");
        envVarMap.put("QPID_WRITEBIASED", "advanced.useWriteBiasedPool");
        envVarMap.put("QPID_JMXPORT", "management.jmxport");
        envVarMap.put("QPID_FRAMESIZE", "advanced.framesize");
        envVarMap.put("QPID_MSGAUTH", "security.msg-auth");
        envVarMap.put("QPID_AUTOREGISTER", "auto_register");
        envVarMap.put("QPID_MANAGEMENTENABLED", "management.enabled");
        envVarMap.put("QPID_HEARTBEATDELAY", "heartbeat.delay");
        envVarMap.put("QPID_HEARTBEATTIMEOUTFACTOR", "heartbeat.timeoutFactor");
        envVarMap.put("QPID_MAXIMUMMESSAGEAGE", "maximumMessageAge");
        envVarMap.put("QPID_MAXIMUMMESSAGECOUNT", "maximumMessageCount");
        envVarMap.put("QPID_MAXIMUMQUEUEDEPTH", "maximumQueueDepth");
        envVarMap.put("QPID_MAXIMUMMESSAGESIZE", "maximumMessageSize");
        envVarMap.put("QPID_MAXIMUMCHANNELCOUNT", "maximumChannelCount");
        envVarMap.put("QPID_MINIMUMALERTREPEATGAP", "minimumAlertRepeatGap");
        envVarMap.put("QPID_QUEUECAPACITY", "capacity");
        envVarMap.put("QPID_FLOWRESUMECAPACITY", "flowResumeCapacity");
        envVarMap.put("QPID_SOCKETRECEIVEBUFFER", "connector.socketReceiveBuffer");
        envVarMap.put("QPID_SOCKETWRITEBUFFER", "connector.socketWriteBuffer");
        envVarMap.put("QPID_TCPNODELAY", "connector.tcpNoDelay");
        envVarMap.put("QPID_ENABLEPOOLEDALLOCATOR", "advanced.enablePooledAllocator");
        envVarMap.put("QPID_STATUS-UPDATES", STATUS_UPDATES);
        this._configuration = conf;
    }

    public void initialise() throws ConfigurationException {
        this.setConfiguration("", this._configuration);
        this.setupVirtualHosts(this._configuration);
    }

    public String[] getElementsProcessed() {
        return new String[]{""};
    }

    public void validateConfiguration() throws ConfigurationException {
        if (this.getListValue("security.jmx.access").size() > 0) {
            String message = "Validation error : security/jmx/access is no longer a supported element within the configuration xml." + (this._configFile == null ? "" : " Configuration file : " + this._configFile);
            throw new ConfigurationException(message);
        }
        if (this.getListValue("security.jmx.principal-database").size() > 0) {
            String message = "Validation error : security/jmx/principal-database is no longer a supported element within the configuration xml." + (this._configFile == null ? "" : " Configuration file : " + this._configFile);
            throw new ConfigurationException(message);
        }
        if (this.getListValue("security.principal-databases.principal-database(0).class").size() > 0) {
            String message = "Validation error : security/principal-databases is no longer supported within the configuration xml." + (this._configFile == null ? "" : " Configuration file : " + this._configFile);
            throw new ConfigurationException(message);
        }
    }

    protected void setupVirtualHosts(Configuration conf) throws ConfigurationException {
        List vhostFiles = conf.getList("virtualhosts");
        Configuration vhostConfig = conf.subset("virtualhosts");
        if (!vhostFiles.isEmpty() && !vhostConfig.subset("virtualhost").isEmpty()) {
            throw new ConfigurationException("Only one of external or embedded virtualhosts configuration allowed.");
        }
        if (vhostFiles.size() > 1) {
            throw new ConfigurationException("Only one external virtualhosts configuration file allowed, multiple filenames found.");
        }
        HierarchicalConfiguration vhostConfiguration = new HierarchicalConfiguration();
        if (!vhostConfig.subset("virtualhost").isEmpty()) {
            vhostConfiguration = vhostConfig;
        } else {
            for (String fileName : vhostFiles) {
                this._vhostsFile = new File(fileName);
                if (!this._vhostsFile.exists()) {
                    throw new ConfigurationException("Virtualhosts file does not exist");
                }
                vhostConfiguration = ServerConfiguration.parseConfig(new File(fileName));
                String defaultVirtualHost = vhostConfiguration.getString("default");
                this._configuration.setProperty("virtualhosts.default", (Object)defaultVirtualHost);
            }
        }
        List hosts = vhostConfiguration.getList("virtualhost.name");
        for (int j = 0; j < hosts.size(); ++j) {
            String name = (String)hosts.get(j);
            VirtualHostConfiguration virtualhost = new VirtualHostConfiguration(name, vhostConfiguration.subset("virtualhost." + name));
            this._virtualHosts.put(virtualhost.getName(), virtualhost);
        }
    }

    private static void substituteEnvironmentVariables(Configuration conf) {
        for (Map.Entry<String, String> var : envVarMap.entrySet()) {
            String val = System.getenv(var.getKey());
            if (val == null) continue;
            conf.setProperty(var.getValue(), (Object)val);
        }
    }

    private static Configuration parseConfig(File file) throws ConfigurationException {
        ConfigurationFactory factory = new ConfigurationFactory();
        factory.setConfigurationFileName(file.getAbsolutePath());
        Configuration conf = factory.getConfiguration();
        Iterator keys = conf.getKeys();
        if (!keys.hasNext()) {
            keys = null;
            conf = ServerConfiguration.flatConfig(file);
        }
        ServerConfiguration.substituteEnvironmentVariables(conf);
        return conf;
    }

    public boolean getStatusUpdatesEnabled() {
        String value = this.getStringValue(STATUS_UPDATES, DEFAULT_STATUS_UPDATES);
        return value.equalsIgnoreCase(DEFAULT_STATUS_UPDATES);
    }

    public Locale getLocale() {
        Locale locale;
        String localeString = this.getStringValue(ADVANCED_LOCALE);
        if (localeString == null) {
            return Locale.getDefault();
        }
        String[] parts = localeString.split("_");
        switch (parts.length) {
            case 1: {
                locale = new Locale(localeString);
                break;
            }
            case 2: {
                locale = new Locale(parts[0], parts[1]);
                break;
            }
            default: {
                StringBuilder variant = new StringBuilder(parts[2]);
                if (parts.length > 3) {
                    for (int index = 3; index < parts.length; ++index) {
                        variant.append('_').append(parts[index]);
                    }
                }
                locale = new Locale(parts[0], parts[1], variant.toString());
            }
        }
        return locale;
    }

    public static final Configuration flatConfig(File file) throws ConfigurationException {
        final MyConfiguration conf = new MyConfiguration();
        conf.addConfiguration((Configuration)new SystemConfiguration(){

            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        conf.addConfiguration((Configuration)new XMLConfiguration(file){

            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        return conf;
    }

    public String getConfigurationURL() {
        return this._configFile == null ? "" : this._configFile.getAbsolutePath();
    }

    public void handle(Signal arg0) {
        try {
            this.reparseConfigFileSecuritySections();
        }
        catch (ConfigurationException e) {
            _logger.error((Object)"Could not reload configuration file security sections", (Throwable)e);
        }
    }

    public void reparseConfigFileSecuritySections() throws ConfigurationException {
        if (this._configFile != null) {
            Configuration newConfig = ServerConfiguration.parseConfig(this._configFile);
            this.setConfiguration("", newConfig);
            ApplicationRegistry.getInstance().getSecurityManager().configureHostPlugins(this);
            Configuration newVhosts = this._vhostsFile == null ? newConfig.subset("virtualhosts") : ServerConfiguration.parseConfig(this._vhostsFile);
            VirtualHostRegistry vhostRegistry = ApplicationRegistry.getInstance().getVirtualHostRegistry();
            for (String hostName : this._virtualHosts.keySet()) {
                VirtualHost vhost = vhostRegistry.getVirtualHost(hostName);
                Configuration vhostConfig = newVhosts.subset("virtualhost." + hostName);
                vhost.getConfiguration().setConfiguration("virtualhosts.virtualhost", vhostConfig);
                vhost.getSecurityManager().configureGlobalPlugins(this);
                vhost.getSecurityManager().configureHostPlugins(vhost.getConfiguration());
            }
            _logger.warn((Object)SECURITY_CONFIG_RELOADED);
        }
    }

    public String getQpidWork() {
        return System.getProperty(QPID_WORK, System.getProperty("java.io.tmpdir"));
    }

    public String getQpidHome() {
        return System.getProperty(QPID_HOME);
    }

    public void setJMXManagementPort(int mport) {
        this.getConfig().setProperty("management.jmxport", (Object)mport);
    }

    public int getJMXManagementPort() {
        return this.getIntValue("management.jmxport", 8999);
    }

    public boolean getUseCustomRMISocketFactory() {
        return this.getBooleanValue(MGMT_CUSTOM_REGISTRY_SOCKET, true);
    }

    public void setUseCustomRMISocketFactory(boolean bool) {
        this.getConfig().setProperty(MGMT_CUSTOM_REGISTRY_SOCKET, (Object)bool);
    }

    public boolean getPlatformMbeanserver() {
        return this.getBooleanValue("management.platform-mbeanserver", true);
    }

    public String[] getVirtualHosts() {
        return this._virtualHosts.keySet().toArray(new String[this._virtualHosts.size()]);
    }

    public String getPluginDirectory() {
        return this.getStringValue("plugin-directory");
    }

    public String getCacheDirectory() {
        return this.getStringValue("cache-directory");
    }

    public VirtualHostConfiguration getVirtualHostConfig(String name) {
        return this._virtualHosts.get(name);
    }

    public void setVirtualHostConfig(VirtualHostConfiguration config) {
        this._virtualHosts.put(config.getName(), config);
    }

    public int getFrameSize() {
        return this.getIntValue("advanced.framesize", 65536);
    }

    public boolean getSynchedClocks() {
        return this.getBooleanValue("advanced.synced-clocks");
    }

    public boolean getMsgAuth() {
        return this.getBooleanValue("security.msg-auth");
    }

    public String getManagementKeyStorePath() {
        return this.getStringValue("management.ssl.keyStorePath");
    }

    public boolean getManagementSSLEnabled() {
        return this.getBooleanValue("management.ssl.enabled", true);
    }

    public String getManagementKeyStorePassword() {
        return this.getStringValue("management.ssl.keyStorePassword");
    }

    public boolean getQueueAutoRegister() {
        return this.getBooleanValue("queue.auto_register", true);
    }

    public boolean getClusteringEnabled() {
        return this.getBooleanValue("clustering.enabled", false);
    }

    public String getZookeeperConnection() {
        return this.getStringValue("clustering.coordination.ZooKeeperConnection", "127.0.0.1:2180");
    }

    public String getReferenceTime() {
        return this.getStringValue("clustering.coordination.ReferenceTime", "2012-02-29 08:08:08");
    }

    public boolean isOnceInOrderSupportEnabled() {
        return this.getBooleanValue("clustering.OnceInOrderSupportEnabled", false);
    }

    public int getGlobalQueueWorkerMessageBatchSize() {
        return this.getIntValue("clustering.tuning.messageBatchSizes.globalQueueWorkerMessageBatchSize", 500);
    }

    public int getContentPublisherMessageBatchSize() {
        return this.getIntValue("clustering.tuning.messageBatchSizes.contentPublisherMessageBatchSize", 100);
    }

    public int getMetadataPublisherMessageBatchSize() {
        return this.getIntValue("clustering.tuning.messageBatchSizes.medataDatePublisherMessageBatchSize", 100);
    }

    public int getMessageBatchSizeForSubscribersQueues() {
        return this.getIntValue("clustering.tuning.messageBatchSizes.messageBatchSizeForSubscribersQueues", 20);
    }

    public int getMessageBatchSizeForSubscribers() {
        return this.getIntValue("clustering.tuning.messageBatchSizes.messageBatchSizeForSubscribers", 10);
    }

    public int getFlusherPoolSize() {
        return this.getIntValue("clustering.tuning.threading.flusherPoolSize", 10);
    }

    public int getSubscriptionPoolSize() {
        return this.getIntValue("clustering.tuning.threading.subscriptionPoolSize", 20);
    }

    public int getMaxAckWaitTime() {
        return this.getIntValue("clustering.tuning.waitTimes.maxAckWaitTime", 1);
    }

    public int getMaxAckWaitTimeForBatch() {
        return this.getIntValue("clustering.tuning.waitTimes.maxAckWaitTimeForBatch", 2);
    }

    public int getQueueWorkerInterval() {
        return this.getIntValue("clustering.tuning.waitTimes.queueWorkerInterval", 500);
    }

    public int getPubSubMessageRemovalTaskInterval() {
        return this.getIntValue("clustering.tuning.waitTimes.pubSubMessageRemovalTaskInterval", 5000);
    }

    public int getContentRemovalTaskInterval() {
        return this.getIntValue("clustering.tuning.waitTimes.contentRemovalTaskInterval", 4000);
    }

    public int getContentRemovalTimeDifference() {
        return this.getIntValue("clustering.tuning.waitTimes.contentRemovalTimeDifference", 120);
    }

    public int getVirtualHostSyncTaskInterval() {
        return this.getIntValue("clustering.tuning.waitTimes.virtualHostSyncTaskInterval", 3600);
    }

    public boolean getManagementEnabled() {
        return this.getBooleanValue("management.enabled", true);
    }

    public void setManagementEnabled(boolean enabled) {
        this.getConfig().setProperty("management.enabled", (Object)enabled);
    }

    public int getHeartBeatDelay() {
        return this.getIntValue("heartbeat.delay", 5);
    }

    public double getHeartBeatTimeout() {
        return this.getDoubleValue("heartbeat.timeoutFactor", 2.0);
    }

    public int getDeliveryPoolSize() {
        return this.getIntValue("delivery.poolsize");
    }

    public long getMaximumMessageAge() {
        return this.getLongValue("maximumMessageAge");
    }

    public long getMaximumMessageCount() {
        return this.getLongValue("maximumMessageCount");
    }

    public long getMaximumQueueDepth() {
        return this.getLongValue("maximumQueueDepth");
    }

    public long getMaximumMessageSize() {
        return this.getLongValue("maximumMessageSize");
    }

    public long getMinimumAlertRepeatGap() {
        return this.getLongValue("minimumAlertRepeatGap");
    }

    public long getCapacity() {
        return this.getLongValue("capacity");
    }

    public long getFlowResumeCapacity() {
        return this.getLongValue("flowResumeCapacity", this.getCapacity());
    }

    public int getConnectorProcessors() {
        return this.getIntValue("connector.processors", 4);
    }

    public List getPorts() {
        return this.getListValue("connector.port", Collections.singletonList(5672));
    }

    public List getPortExclude010() {
        return this.getListValue("connector.non010port");
    }

    public List getPortExclude091() {
        return this.getListValue("connector.non091port");
    }

    public List getPortExclude09() {
        return this.getListValue("connector.non09port");
    }

    public List getPortExclude08() {
        return this.getListValue("connector.non08port");
    }

    public String getBind() {
        return this.getStringValue("connector.bind", "*");
    }

    public int getReceiveBufferSize() {
        return this.getIntValue("connector.socketReceiveBuffer", 262144);
    }

    public int getWriteBufferSize() {
        return this.getIntValue("connector.socketWriteBuffer", 262144);
    }

    public boolean getTcpNoDelay() {
        return this.getBooleanValue("connector.tcpNoDelay", true);
    }

    public boolean getEnableExecutorPool() {
        return this.getBooleanValue("advanced.filterchain[@enableExecutorPool]");
    }

    public boolean getEnableSSL() {
        return this.getBooleanValue("connector.ssl.enabled");
    }

    public boolean getSSLOnly() {
        return this.getBooleanValue("connector.ssl.sslOnly");
    }

    public List getSSLPorts() {
        return this.getListValue("connector.ssl.port", Collections.singletonList(8672));
    }

    public String getKeystorePath() {
        return this.getStringValue("connector.ssl.keystorePath", "none");
    }

    public String getKeystorePassword() {
        return this.getStringValue("connector.ssl.keystorePassword", "none");
    }

    public String getCertType() {
        return this.getStringValue("connector.ssl.certType", "SunX509");
    }

    public boolean getUseBiasedWrites() {
        return this.getBooleanValue("advanced.useWriteBiasedPool");
    }

    public String getDefaultVirtualHost() {
        return this.getStringValue("virtualhosts.default");
    }

    public void setDefaultVirtualHost(String vhost) {
        this.getConfig().setProperty("virtualhosts.default", (Object)vhost);
    }

    public void setHousekeepingExpiredMessageCheckPeriod(long value) {
        this.getConfig().setProperty("housekeeping.expiredMessageCheckPeriod", (Object)value);
    }

    public long getHousekeepingCheckPeriod() {
        return this.getLongValue("housekeeping.checkPeriod", this.getLongValue("housekeeping.expiredMessageCheckPeriod", 30000L));
    }

    public long getStatisticsSamplePeriod() {
        return this.getConfig().getLong("statistics.sample.period", 5000L);
    }

    public boolean isStatisticsGenerationBrokerEnabled() {
        return this.getConfig().getBoolean("statistics.generation.broker", false);
    }

    public boolean isStatisticsGenerationVirtualhostsEnabled() {
        return this.getConfig().getBoolean("statistics.generation.virtualhosts", false);
    }

    public boolean isStatisticsGenerationConnectionsEnabled() {
        return this.getConfig().getBoolean("statistics.generation.connections", false);
    }

    public long getStatisticsReportingPeriod() {
        return this.getConfig().getLong("statistics.reporting.period", 0L);
    }

    public boolean isStatisticsReportResetEnabled() {
        return this.getConfig().getBoolean("statistics.reporting.reset", false);
    }

    public int getMaxChannelCount() {
        return this.getIntValue("maximumChannelCount", 256);
    }

    public static class MyConfiguration
    extends CompositeConfiguration {
        public String interpolate(String obj) {
            return super.interpolate(obj);
        }
    }
}

