/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.configuration;

import org.wso2.andes.server.configuration.ServerConfiguration;

public class ClusterConfiguration {
    private final ServerConfiguration serverConfig;
    private final String zookeeperConnection;
    private String bindIpAddress;

    public ClusterConfiguration(ServerConfiguration serverConfig) {
        this.serverConfig = serverConfig;
        this.zookeeperConnection = serverConfig.getZookeeperConnection();
    }

    public Boolean isClusteringEnabled() {
        return this.serverConfig.getClusteringEnabled();
    }

    public String getZookeeperConnection() {
        return this.zookeeperConnection;
    }

    public boolean isOnceInOrderSupportEnabled() {
        return this.serverConfig.isOnceInOrderSupportEnabled();
    }

    public int getMessageBatchSizeForSubscribersQueues() {
        return this.serverConfig.getMessageBatchSizeForSubscribersQueues();
    }

    public int getMessageBatchSizeForSubscribers() {
        return this.serverConfig.getMessageBatchSizeForSubscribers();
    }

    public int getFlusherPoolSize() {
        return this.serverConfig.getFlusherPoolSize();
    }

    public int getSubscriptionPoolSize() {
        return this.serverConfig.getSubscriptionPoolSize();
    }

    public int getMaxAckWaitTime() {
        return this.serverConfig.getMaxAckWaitTime();
    }

    public int getMaxAckWaitTimeForBatch() {
        return this.serverConfig.getMaxAckWaitTimeForBatch();
    }

    public int getQueueWorkerInterval() {
        return this.serverConfig.getQueueWorkerInterval();
    }

    public int getPubSubMessageRemovalTaskInterval() {
        return this.serverConfig.getPubSubMessageRemovalTaskInterval();
    }

    public int getContentRemovalTaskInterval() {
        return this.serverConfig.getContentRemovalTaskInterval();
    }

    public int getContentRemovalTimeDifference() {
        return this.serverConfig.getContentRemovalTimeDifference();
    }

    public int getVirtualHostSyncTaskInterval() {
        return this.serverConfig.getVirtualHostSyncTaskInterval();
    }

    public String getReferenceTime() {
        return this.serverConfig.getReferenceTime();
    }

    public String getBindIpAddress() {
        return this.bindIpAddress;
    }

    public void setBindIpAddress(String bindIpAddress) {
        this.bindIpAddress = bindIpAddress;
    }

    public int getGlobalQueueWorkerMessageBatchSize() {
        return this.serverConfig.getGlobalQueueWorkerMessageBatchSize();
    }

    public int getContentPublisherMessageBatchSize() {
        return this.serverConfig.getContentPublisherMessageBatchSize();
    }

    public int getMetadataPublisherMessageBatchSize() {
        return this.serverConfig.getMetadataPublisherMessageBatchSize();
    }
}

