/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.lock;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.ClusteringEnabledSubscriptionManager;
import org.wso2.andes.server.cassandra.OnceInOrderEnabledSubscriptionManager;
import org.wso2.andes.server.cluster.coordination.CoordinationConstants;
import org.wso2.andes.server.cluster.coordination.CoordinationException;
import org.wso2.andes.server.cluster.coordination.ZooKeeperAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueResourceLock {
    private final Object lock = new Object();
    private String myNode;
    private String myZNode = null;
    private int myId;
    private ZooKeeperAgent zkAgent;
    private String connectionString;
    private String queue;
    private Semaphore queueLock;
    private static Log log = LogFactory.getLog(QueueResourceLock.class);

    public QueueResourceLock(String connectionString, String queue) {
        this.connectionString = connectionString;
        this.queue = queue;
    }

    public QueueResourceLock(String queue) {
        this.queue = queue;
        ClusteringEnabledSubscriptionManager sm = ClusterResourceHolder.getInstance().getSubscriptionManager();
        if (sm instanceof OnceInOrderEnabledSubscriptionManager) {
            this.queueLock = ((OnceInOrderEnabledSubscriptionManager)sm).getQueueLock().get(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acquire() throws InterruptedException, CoordinationException {
        if (!ClusterResourceHolder.getInstance().getClusterConfiguration().isClusteringEnabled().booleanValue()) {
            if (this.queueLock == null) throw new CoordinationException("Queue Resource Lock not initialized properly");
            this.queueLock.acquire();
            return;
        }
        try {
            if (this.zkAgent == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.zkAgent == null) {
                        this.zkAgent = new ZooKeeperAgent(this.connectionString);
                        this.zkAgent.initQueueResourceLockCoordination(this.queue);
                    }
                }
            }
            this.createNode();
            this.proceed();
            return;
        }
        catch (Exception e) {
            throw new CoordinationException("Error Acquiring Lock ", e);
        }
    }

    public void release() throws CoordinationException {
        if (!ClusterResourceHolder.getInstance().getClusterConfiguration().isClusteringEnabled().booleanValue()) {
            if (this.queueLock != null) {
                this.queueLock.release();
            } else {
                throw new CoordinationException("Queue Resource Lock not initialized properly");
            }
        }
        try {
            this.deleteNode();
        }
        catch (Exception e) {
            throw new CoordinationException("Error while releasing lock", e);
        }
    }

    private void createNode() throws InterruptedException, KeeperException {
        String nodeName = CoordinationConstants.QUEUE_RESOURCE_LOCK_NODE + UUID.randomUUID().toString().replace("-", "_");
        this.myNode = nodeName.replace("/", "");
        String path = CoordinationConstants.QUEUE_RESOURCE_LOCK_PARENT + "_" + this.queue + nodeName;
        this.zkAgent.getZooKeeper().create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    private void deleteNode() throws InterruptedException, KeeperException {
        if (this.zkAgent != null) {
            String path = CoordinationConstants.QUEUE_RESOURCE_LOCK_PARENT + "_" + this.queue + CoordinationConstants.NODE_SEPARATOR + this.myZNode;
            this.zkAgent.getZooKeeper().delete(path, -1);
        }
    }

    private List<String> getChildren() throws InterruptedException, KeeperException {
        return this.zkAgent.getZooKeeper().getChildren(CoordinationConstants.QUEUE_RESOURCE_LOCK_PARENT + "_" + this.queue, false);
    }

    private boolean proceed() throws InterruptedException, KeeperException {
        while (true) {
            final Semaphore lock = new Semaphore(1);
            lock.acquire();
            List<String> childNodes = this.getChildren();
            HashMap<Integer, String> nodeIdMap = new HashMap<Integer, String>();
            String selectedNode = null;
            int currentMin = Integer.MAX_VALUE;
            for (String child : childNodes) {
                String id = child.substring(this.myNode.length());
                int seqNumber = Integer.parseInt(id);
                if (child.contains(this.myNode)) {
                    this.myId = seqNumber;
                    this.myZNode = child;
                }
                nodeIdMap.put(seqNumber, child);
                if (seqNumber >= currentMin) continue;
                selectedNode = child;
                currentMin = seqNumber;
            }
            if (selectedNode.contains(this.myNode)) break;
            int myLockHolder = --this.myId;
            Stat stat = this.zkAgent.getZooKeeper().exists(CoordinationConstants.QUEUE_RESOURCE_LOCK_PARENT + "_" + this.queue + CoordinationConstants.NODE_SEPARATOR + (String)nodeIdMap.get(myLockHolder), new Watcher(){

                public void process(WatchedEvent watchedEvent) {
                    if (Watcher.Event.EventType.NodeDeleted == watchedEvent.getType()) {
                        log.debug((Object)"Locked Release Detected.. Trying to acquire lock again..");
                        lock.release();
                    }
                }
            });
            if (stat == null) {
                log.debug((Object)"Locked Release Detected.. Trying to acquire lock again..");
                continue;
            }
            lock.acquire();
        }
        log.debug((Object)"Lock acquired..");
        return true;
    }

    public void destroy() throws CoordinationException {
        if (ClusterResourceHolder.getInstance().getClusterConfiguration().isClusteringEnabled().booleanValue()) {
            try {
                this.zkAgent.getZooKeeper().close();
            }
            catch (InterruptedException e) {
                throw new CoordinationException("Error while releasing the Queue Lock ", e);
            }
            finally {
                this.zkAgent = null;
            }
        }
    }
}

