/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.MessageIdGenerator;
import org.wso2.andes.server.store.CassandraMessageStore;

public class TimeStampBasedMessageIdGenerator
implements MessageIdGenerator {
    private volatile long lastCurrentTime;
    private volatile long lastMessageId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextId() {
        long ts = ClusterResourceHolder.getInstance().getReferenceTime().getCurrentTime();
        CassandraMessageStore ms = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        if (this.lastCurrentTime == ts) {
            TimeStampBasedMessageIdGenerator timeStampBasedMessageIdGenerator = this;
            synchronized (timeStampBasedMessageIdGenerator) {
                long mid;
                if (this.lastCurrentTime == ts) {
                    this.lastMessageId = ms.currentMessageId().incrementAndGet();
                    return this.lastMessageId;
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(ts).append(TimeStampBasedMessageIdGenerator.getTwoDigitNodeId(ClusterResourceHolder.getInstance().getClusterManager().getNodeId())).append("00");
                this.lastMessageId = mid = Long.parseLong(buffer.toString());
                ms.currentMessageId().set(this.lastMessageId);
                this.lastCurrentTime = ts;
                return this.lastMessageId;
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(ts).append(TimeStampBasedMessageIdGenerator.getTwoDigitNodeId(ClusterResourceHolder.getInstance().getClusterManager().getNodeId())).append("00");
        long mid = Long.parseLong(buffer.toString());
        TimeStampBasedMessageIdGenerator timeStampBasedMessageIdGenerator = this;
        synchronized (timeStampBasedMessageIdGenerator) {
            this.lastCurrentTime = ts;
            this.lastMessageId = mid;
            ms.currentMessageId().set(this.lastMessageId);
            return this.lastMessageId;
        }
    }

    private static String getTwoDigitNodeId(int nodeId) {
        switch (nodeId / 10) {
            case 0: {
                return "0" + nodeId;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "" + nodeId;
            }
        }
        throw new RuntimeException("Node id range exceeded - supported range 0-99");
    }
}

